@extends('layouts.app')

@section('title', 'Agendar Evento - SGE')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Agendar Evento</h5>
            <a href="{{ route('eventos.index') }}" class="btn btn-sm btn-secondary">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>
        
        <div style="background: #f8f9fa; padding: 15px; border-radius: 4px;">
                <form method="POST" action="{{ route('eventos.store') }}">
                    @csrf

                <div class="mb-2">
                    <label for="titulo" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Título <span class="text-danger">*</span></label>
                    <input type="text" class="form-control form-control-sm @error('titulo') is-invalid @enderror" 
                           id="titulo" name="titulo" value="{{ old('titulo') }}" required>
                    @error('titulo')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-2">
                    <label for="descricao" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Descrição</label>
                    <textarea class="form-control form-control-sm @error('descricao') is-invalid @enderror" 
                              id="descricao" name="descricao" rows="3">{{ old('descricao') }}</textarea>
                    @error('descricao')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="row">
                    <div class="col-md-4 mb-2">
                        <label for="data" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Data <span class="text-danger">*</span></label>
                        <input type="date" class="form-control form-control-sm @error('data') is-invalid @enderror" 
                               id="data" name="data" value="{{ old('data') }}" required>
                        @error('data')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-4 mb-2">
                        <label for="hora_inicio" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Hora Início</label>
                        <input type="time" class="form-control form-control-sm @error('hora_inicio') is-invalid @enderror" 
                               id="hora_inicio" name="hora_inicio" value="{{ old('hora_inicio') }}">
                        @error('hora_inicio')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-4 mb-2">
                        <label for="hora_fim" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Hora Fim</label>
                        <input type="time" class="form-control form-control-sm @error('hora_fim') is-invalid @enderror" 
                               id="hora_fim" name="hora_fim" value="{{ old('hora_fim') }}">
                        @error('hora_fim')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="mb-2">
                    <label for="tipo" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Tipo <span class="text-danger">*</span></label>
                    <select class="form-select form-select-sm @error('tipo') is-invalid @enderror" 
                            id="tipo" name="tipo" required>
                        <option value="Geral" {{ old('tipo') == 'Geral' ? 'selected' : '' }}>Geral</option>
                        <option value="Turma" {{ old('tipo') == 'Turma' ? 'selected' : '' }}>Turma</option>
                        <option value="Disciplina" {{ old('tipo') == 'Disciplina' ? 'selected' : '' }}>Disciplina</option>
                    </select>
                    @error('tipo')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-2" id="turma-field" style="display:none;">
                    <label for="turma_id" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Turma</label>
                    <select class="form-select form-select-sm @error('turma_id') is-invalid @enderror" 
                            id="turma_id" name="turma_id">
                        <option value="">Selecione</option>
                        @foreach($turmas as $turma)
                            <option value="{{ $turma->id }}" {{ old('turma_id') == $turma->id ? 'selected' : '' }}>
                                {{ $turma->codigo }} - {{ $turma->nome }}
                            </option>
                        @endforeach
                    </select>
                    @error('turma_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-2" id="disciplina-field" style="display:none;">
                    <label for="disciplina_id" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Disciplina</label>
                    <select class="form-select form-select-sm @error('disciplina_id') is-invalid @enderror" 
                            id="disciplina_id" name="disciplina_id">
                        <option value="">Selecione</option>
                        @foreach($disciplinas as $disciplina)
                            <option value="{{ $disciplina->id }}" {{ old('disciplina_id') == $disciplina->id ? 'selected' : '' }}>
                                {{ $disciplina->nome }}
                            </option>
                        @endforeach
                    </select>
                    @error('disciplina_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <input type="hidden" name="ano_letivo_id" value="{{ $anoLetivo->id }}">

                <div class="mt-2">
                    <button type="submit" class="btn btn-sm btn-primary">Agendar Evento</button>
                    <a href="{{ route('eventos.index') }}" class="btn btn-sm btn-secondary">Cancelar</a>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.getElementById('tipo').addEventListener('change', function() {
    const tipo = this.value;
    document.getElementById('turma-field').style.display = tipo === 'Turma' ? 'block' : 'none';
    document.getElementById('disciplina-field').style.display = tipo === 'Disciplina' ? 'block' : 'none';
});

// Trigger on load
document.getElementById('tipo').dispatchEvent(new Event('change'));
</script>
@endsection



