@extends('layouts.app')

@section('title', 'Dashboard - SGE')

@section('content')
<div class="dashboard-container">
    @if(auth()->user()->isSuperadmin() || auth()->user()->isAdmin())
        <!-- Statistics Cards - Primeira Linha -->
        <div class="row g-2 mb-2">
            <div class="col-lg-3 col-md-6">
                <div class="stat-card stat-card-primary">
                    <div class="stat-card-icon">
                        <i class="bi bi-people-fill"></i>
                    </div>
                    <div class="stat-card-content">
                        <h3 class="stat-card-number">{{ $total_alunos ?? 0 }}</h3>
                        <p class="stat-card-label">{{ __('common.students') }}</p>
                    </div>
                    <div class="stat-card-link">
                        <a href="{{ route('admin.alunos.index') }}" class="text-white">
                            <i class="bi bi-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="stat-card stat-card-success">
                    <div class="stat-card-icon">
                        <i class="bi bi-mortarboard-fill"></i>
                    </div>
                    <div class="stat-card-content">
                        <h3 class="stat-card-number">{{ $total_professores ?? 0 }}</h3>
                        <p class="stat-card-label">{{ __('common.teachers') }}</p>
                    </div>
                    <div class="stat-card-link">
                        <a href="{{ route('admin.professores.index') }}" class="text-white">
                            <i class="bi bi-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="stat-card stat-card-info">
                    <div class="stat-card-icon">
                        <i class="bi bi-building"></i>
                    </div>
                    <div class="stat-card-content">
                        <h3 class="stat-card-number">{{ $total_turmas ?? 0 }}</h3>
                        <p class="stat-card-label">{{ __('common.classes') }}</p>
                    </div>
                    <div class="stat-card-link">
                        <a href="{{ route('admin.turmas.index') }}" class="text-white">
                            <i class="bi bi-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="stat-card stat-card-secondary">
                    <div class="stat-card-icon">
                        <i class="bi bi-book-fill"></i>
                    </div>
                    <div class="stat-card-content">
                        <h3 class="stat-card-number">{{ $total_disciplinas ?? 0 }}</h3>
                        <p class="stat-card-label">{{ __('common.subjects') }}</p>
                    </div>
                    <div class="stat-card-link">
                        <a href="{{ route('admin.disciplinas.index') }}" class="text-white">
                            <i class="bi bi-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistics Cards - Segunda Linha -->
        <div class="row g-2 mb-2">
            <div class="col-lg-3 col-md-6">
                <div class="stat-card stat-card-warning">
                    <div class="stat-card-icon">
                        <i class="bi bi-clipboard-check-fill"></i>
                    </div>
                    <div class="stat-card-content">
                        <h3 class="stat-card-number">{{ $total_avaliacoes ?? 0 }}</h3>
                        <p class="stat-card-label">{{ __('common.evaluations') }}</p>
                    </div>
                    <div class="stat-card-link">
                        <a href="{{ route('avaliacoes.index') }}" class="text-white">
                            <i class="bi bi-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="stat-card stat-card-purple">
                    <div class="stat-card-icon">
                        <i class="bi bi-file-earmark-text-fill"></i>
                    </div>
                    <div class="stat-card-content">
                        <h3 class="stat-card-number">{{ $total_trabalhos ?? 0 }}</h3>
                        <p class="stat-card-label">{{ __('common.plans') }}</p>
                    </div>
                    <div class="stat-card-link">
                        <a href="{{ route('trabalhos.index') }}" class="text-white">
                            <i class="bi bi-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="stat-card stat-card-danger">
                    <div class="stat-card-icon">
                        <i class="bi bi-calendar-event-fill"></i>
                    </div>
                    <div class="stat-card-content">
                        <h3 class="stat-card-number">{{ $total_eventos ?? 0 }}</h3>
                        <p class="stat-card-label">{{ __('common.events') }}</p>
                    </div>
                    <div class="stat-card-link">
                        <a href="{{ route('eventos.index') }}" class="text-white">
                            <i class="bi bi-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="stat-card stat-card-teal">
                    <div class="stat-card-icon">
                        <i class="bi bi-cash-coin"></i>
                    </div>
                    <div class="stat-card-content">
                        <h3 class="stat-card-number">
                            <i class="bi bi-currency-exchange"></i>
                        </h3>
                        <p class="stat-card-label">{{ __('common.financial') }}</p>
                    </div>
                    <div class="stat-card-link">
                        <a href="{{ route('financeiro.index') }}" class="text-white">
                            <i class="bi bi-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Calendar -->
        <div class="row g-1">
            <div class="col-12">
                <div class="card dashboard-card">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="card-title mb-0">
                            <i class="bi bi-calendar-event-fill text-primary me-2"></i>
                            {{ __('common.calendar_events') }}
                        </h5>
                    </div>
                    <div class="card-body">
                        <div id="calendar-container"></div>
                    </div>
                </div>
            </div>
        </div>
    @endif

    @if(auth()->user()->isProfessor())
        <div class="row g-4">
            <div class="col-12">
                <div class="card dashboard-card">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="card-title mb-0">
                            <i class="bi bi-mortarboard-fill text-primary me-2"></i>
                            {{ __('common.my_classes') }}
                        </h5>
                    </div>
                    <div class="card-body">
                        @if(isset($turmas) && $turmas->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>{{ __('common.classes') }}</th>
                                            <th>{{ __('common.subjects') }}</th>
                                            <th>{{ __('common.actions') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($turmas as $turma)
                                            <tr>
                                                <td>
                                                    <i class="bi bi-building text-primary me-2"></i>
                                                    <strong>{{ $turma->nome }}</strong>
                                                </td>
                                                <td>
                                                    <i class="bi bi-book text-info me-2"></i>
                                                    {{ $turma->pivot->disciplina->nome ?? 'N/A' }}
                                                </td>
                                                <td>
                                                    <a href="{{ route('avaliacoes.create', ['turma_id' => $turma->id, 'disciplina_id' => $turma->pivot->disciplina_id ?? 0]) }}" 
                                                       class="btn btn-sm btn-primary">
                                                        <i class="bi bi-clipboard-plus me-1"></i> Lançar Notas
                                                    </a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="text-center py-4">
                                <i class="bi bi-inbox display-4 text-muted"></i>
                                <p class="text-muted mt-3">{{ __('common.no_class_assigned') }}</p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    @endif

    @if(auth()->user()->isAluno())
        <div class="row g-4">
            <div class="col-lg-8">
                <div class="card dashboard-card">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="card-title mb-0">
                            <i class="bi bi-clipboard-check-fill text-success me-2"></i>
                            {{ __('common.my_evaluations') }}
                        </h5>
                    </div>
                    <div class="card-body">
                        @if(isset($avaliacoes) && $avaliacoes->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>{{ __('common.subjects') }}</th>
                                            <th>{{ __('common.quarter') }}</th>
                                            <th>{{ __('common.grade') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($avaliacoes as $avaliacao)
                                            <tr>
                                                <td>
                                                    <i class="bi bi-book text-primary me-2"></i>
                                                    <strong>{{ $avaliacao->disciplina->nome }}</strong>
                                                </td>
                                                <td>
                                                    <span class="badge bg-info">{{ $avaliacao->trimestre->nome }}</span>
                                                </td>
                                                <td>
                                                    <span class="badge bg-success">{{ $avaliacao->media_nacional ?? 'N/A' }}</span>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="text-center py-4">
                                <i class="bi bi-inbox display-4 text-muted"></i>
                                <p class="text-muted mt-3">Nenhuma avaliação registrada</p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card dashboard-card">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="card-title mb-0">
                            <i class="bi bi-cash-coin text-warning me-2"></i>
                            Situação Financeira
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="text-center mb-3">
                            <span class="badge bg-{{ $situacao_financeira === 'REGULAR' ? 'success' : 'danger' }} fs-6 px-3 py-2">
                                {{ $situacao_financeira ?? 'REGULAR' }}
                            </span>
                        </div>
                        @if(isset($dividas) && $dividas > 0)
                            <div class="alert alert-warning mb-0">
                                <i class="bi bi-exclamation-triangle me-2"></i>
                                <strong>Dívidas:</strong> {{ number_format($dividas, 2, ',', '.') }} MT
                            </div>
                        @else
                            <div class="alert alert-success mb-0">
                                <i class="bi bi-check-circle me-2"></i>
                                <strong>Em dia!</strong> Nenhuma dívida pendente.
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>

<style>
.dashboard-container {
    padding: 0;
    margin-top: -1rem;
    margin-bottom: 0;
}

.stat-card {
    background: white;
    border-radius: 0.5rem;
    padding: 0.75rem 1rem;
    display: flex;
    align-items: center;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
    height: 100%;
    min-height: 80px;
    border: none;
}

.stat-card::before {
    display: none;
}

.stat-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
}

.stat-card-primary { 
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}
.stat-card-success { 
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: white;
}
.stat-card-info { 
    background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
    color: white;
}
.stat-card-warning { 
    background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
    color: white;
}
.stat-card-danger { 
    background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
    color: white;
}
.stat-card-secondary { 
    background: linear-gradient(135deg, #6b7280 0%, #4b5563 100%);
    color: white;
}
.stat-card-purple { 
    background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%);
    color: white;
}
.stat-card-teal { 
    background: linear-gradient(135deg, #14b8a6 0%, #0d9488 100%);
    color: white;
}

.stat-card-icon {
    width: 45px;
    height: 45px;
    border-radius: 0.5rem;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.2rem;
    margin-right: 0.75rem;
    background: rgba(255, 255, 255, 0.2);
    backdrop-filter: blur(10px);
    color: white;
    flex-shrink: 0;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

.stat-card-content {
    flex: 1;
}

.stat-card-number {
    font-size: 1.5rem;
    font-weight: 700;
    margin: 0;
    color: white;
    line-height: 1.2;
    text-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
}

.stat-card-label {
    font-size: 0.75rem;
    color: rgba(255, 255, 255, 0.9);
    margin: 0;
    font-weight: 500;
    line-height: 1.2;
    text-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
}

.stat-card-link {
    position: absolute;
    top: 0.75rem;
    right: 0.75rem;
    opacity: 0.7;
    transition: all 0.2s;
    background: rgba(255, 255, 255, 0.2);
    width: 28px;
    height: 28px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    backdrop-filter: blur(10px);
}

.stat-card-link a {
    color: white !important;
    text-decoration: none;
}

.stat-card:hover .stat-card-link {
    opacity: 1;
    background: rgba(255, 255, 255, 0.3);
    transform: scale(1.1);
}

.dashboard-card {
    border: none;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    border-radius: 0.75rem;
    overflow: hidden;
}

.dashboard-card .card-header {
    padding: 0.5rem 0.75rem;
    font-weight: 600;
    font-size: 0.875rem;
}

.dashboard-card .card-body {
    padding: 0.5rem 0.75rem;
}

.quick-action-btn {
    display: flex;
    flex-direction: column;
    align-items: center;
    padding: 1.5rem;
    text-decoration: none;
    color: #374151;
    border: 2px solid #e5e7eb;
    border-radius: 0.75rem;
    transition: all 0.2s;
    text-align: center;
}

.quick-action-btn:hover {
    border-color: #667eea;
    background-color: #f3f4f6;
    color: #667eea;
    transform: translateY(-2px);
}

.quick-action-icon {
    width: 50px;
    height: 50px;
    border-radius: 0.5rem;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    color: white;
    margin-bottom: 0.75rem;
}

.bg-purple {
    background-color: #8b5cf6 !important;
}

.info-item {
    display: flex;
    align-items: flex-start;
    gap: 1rem;
}

.info-item i {
    font-size: 1.5rem;
    margin-top: 0.25rem;
}

.info-item strong {
    display: block;
    margin-bottom: 0.25rem;
    color: #1f2937;
}

.table-hover tbody tr:hover {
    background-color: #f9fafb;
}

/* Calendar Styles */
#calendar-container {
    max-width: 100%;
    margin: 0 auto;
}

.calendar {
    width: 100%;
    border-collapse: collapse;
    background: white;
}

.calendar-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 0.25rem;
    padding: 0.25rem;
}

.calendar-nav-btn {
    background: #667eea;
    color: white;
    border: none;
    padding: 0.25rem 0.5rem;
    border-radius: 0.25rem;
    cursor: pointer;
    font-size: 0.75rem;
    transition: background 0.2s;
}

.calendar-nav-btn:hover {
    background: #5568d3;
}

.calendar-month-year {
    font-size: 0.875rem;
    font-weight: 600;
    color: #1f2937;
}

.calendar th {
    padding: 0.25rem 0.375rem;
    text-align: center;
    font-weight: 600;
    color: #6b7280;
    background: #f9fafb;
    border: 1px solid #e5e7eb;
    font-size: 0.7rem;
}

.calendar td {
    padding: 0.15rem;
    text-align: center;
    border: 1px solid #e5e7eb;
    vertical-align: top;
    height: 50px;
    width: 14.28%;
    position: relative;
}

.calendar td.other-month {
    background: #f9fafb;
    color: #9ca3af;
}

.calendar td.today {
    background: #eff6ff;
    font-weight: 600;
}

.calendar-day-number {
    display: block;
    margin-bottom: 0.05rem;
    font-weight: 500;
    font-size: 0.75rem;
}

.event-badge {
    display: block;
    font-size: 0.6rem;
    padding: 0.05rem 0.2rem;
    margin: 0.025rem 0;
    border-radius: 0.15rem;
    background: #667eea;
    color: white;
    cursor: pointer;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    transition: background 0.2s;
    line-height: 1.1;
}

.event-badge:hover {
    background: #5568d3;
}

.event-badge.tipo-geral {
    background: #10b981;
}

.event-badge.tipo-turma {
    background: #3b82f6;
}

.event-badge.tipo-disciplina {
    background: #f59e0b;
}

.event-badge.tipo-feriado-nacional {
    background: #dc2626;
    font-weight: 600;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const eventos = @json($eventos ?? []);
    
    // Feriados Nacionais de Moçambique
    function getFeriadosNacionais(year) {
        return [
            { data: `${year}-01-01`, titulo: 'Dia de Ano Novo', tipo: 'Feriado Nacional', descricao: 'Feriado Nacional' },
            { data: `${year}-02-03`, titulo: 'Dia dos Heróis Moçambicanos', tipo: 'Feriado Nacional', descricao: 'Feriado Nacional' },
            { data: `${year}-04-07`, titulo: 'Dia da Mulher Moçambicana', tipo: 'Feriado Nacional', descricao: 'Feriado Nacional' },
            { data: `${year}-05-01`, titulo: 'Dia do Trabalhador', tipo: 'Feriado Nacional', descricao: 'Feriado Nacional' },
            { data: `${year}-06-25`, titulo: 'Dia da Independência', tipo: 'Feriado Nacional', descricao: 'Feriado Nacional' },
            { data: `${year}-09-07`, titulo: 'Dia da Vitória', tipo: 'Feriado Nacional', descricao: 'Feriado Nacional' },
            { data: `${year}-09-25`, titulo: 'Dia das Forças Armadas', tipo: 'Feriado Nacional', descricao: 'Feriado Nacional' },
            { data: `${year}-10-04`, titulo: 'Dia da Paz e Reconciliação', tipo: 'Feriado Nacional', descricao: 'Feriado Nacional' },
            { data: `${year}-10-12`, titulo: 'Dia dos Professores', tipo: 'Feriado Nacional', descricao: 'Feriado Nacional' },
            { data: `${year}-12-25`, titulo: 'Dia de Natal', tipo: 'Feriado Nacional', descricao: 'Feriado Nacional' }
        ];
    }
    
    let currentDate = new Date();
    let currentMonth = currentDate.getMonth();
    let currentYear = currentDate.getFullYear();
    
    const monthNames = [
        'Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho',
        'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'
    ];
    
    const weekDays = ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sáb'];
    
    function formatDate(date) {
        const year = date.getFullYear();
        const month = String(date.getMonth() + 1).padStart(2, '0');
        const day = String(date.getDate()).padStart(2, '0');
        return `${year}-${month}-${day}`;
    }
    
    function getEventsForDate(date) {
        const dateStr = formatDate(date);
        const year = date.getFullYear();
        
        // Buscar eventos do banco de dados
        const eventosDoBanco = eventos.filter(evento => {
            const eventoDate = new Date(evento.data);
            return formatDate(eventoDate) === dateStr;
        });
        
        // Buscar feriados nacionais
        const feriados = getFeriadosNacionais(year);
        const feriadosDoDia = feriados.filter(feriado => feriado.data === dateStr);
        
        // Combinar eventos e feriados
        return [...eventosDoBanco, ...feriadosDoDia];
    }
    
    function renderCalendar() {
        const container = document.getElementById('calendar-container');
        const firstDay = new Date(currentYear, currentMonth, 1);
        const lastDay = new Date(currentYear, currentMonth + 1, 0);
        const daysInMonth = lastDay.getDate();
        const startingDayOfWeek = firstDay.getDay();
        
        let html = `
            <div class="calendar-header">
                <button class="calendar-nav-btn" onclick="previousMonth()">
                    <i class="bi bi-chevron-left"></i> Anterior
                </button>
                <div class="calendar-month-year">
                    ${monthNames[currentMonth]} ${currentYear}
                </div>
                <button class="calendar-nav-btn" onclick="nextMonth()">
                    Próximo <i class="bi bi-chevron-right"></i>
                </button>
            </div>
            <table class="calendar">
                <thead>
                    <tr>
                        ${weekDays.map(day => `<th>${day}</th>`).join('')}
                    </tr>
                </thead>
                <tbody>
        `;
        
        let date = 1;
        let today = new Date();
        let isToday = today.getMonth() === currentMonth && today.getFullYear() === currentYear;
        
        for (let i = 0; i < 6; i++) {
            html += '<tr>';
            for (let j = 0; j < 7; j++) {
                if (i === 0 && j < startingDayOfWeek) {
                    const prevMonth = new Date(currentYear, currentMonth, 0);
                    const prevDate = prevMonth.getDate() - startingDayOfWeek + j + 1;
                    html += `<td class="other-month"><span class="calendar-day-number">${prevDate}</span></td>`;
                } else if (date > daysInMonth) {
                    const nextDate = date - daysInMonth;
                    html += `<td class="other-month"><span class="calendar-day-number">${nextDate}</span></td>`;
                    date++;
                } else {
                    const cellDate = new Date(currentYear, currentMonth, date);
                    const dayEvents = getEventsForDate(cellDate);
                    const isTodayCell = isToday && date === today.getDate();
                    
                    html += `<td ${isTodayCell ? 'class="today"' : ''}>
                        <span class="calendar-day-number">${date}</span>
                        ${dayEvents.map(evento => {
                            const tipoClass = evento.tipo ? evento.tipo.toLowerCase().replace(/\s+/g, '-') : 'geral';
                            const titulo = evento.titulo || evento.nome || 'Evento';
                            const descricao = evento.descricao || '';
                            return `<span class="event-badge tipo-${tipoClass}" title="${titulo}${descricao ? ' - ' + descricao : ''}">${titulo}</span>`;
                        }).join('')}
                    </td>`;
                    date++;
                }
            }
            html += '</tr>';
            if (date > daysInMonth) break;
        }
        
        html += `
                </tbody>
            </table>
        `;
        
        container.innerHTML = html;
    }
    
    window.previousMonth = function() {
        currentMonth--;
        if (currentMonth < 0) {
            currentMonth = 11;
            currentYear--;
        }
        renderCalendar();
    };
    
    window.nextMonth = function() {
        currentMonth++;
        if (currentMonth > 11) {
            currentMonth = 0;
            currentYear++;
        }
        renderCalendar();
    };
    
    renderCalendar();
});
</script>
@endsection
