@extends('layouts.app')

@section('title', 'Todas as Disciplinas - Avaliações')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card mb-3">
            <div class="card-body">
                <form method="GET" action="{{ route('avaliacoes.todas-disciplinas') }}" class="row g-3">
                    <div class="col-md-4">
                        <label for="ano_letivo_id" class="form-label">Ano Lectivo</label>
                        <select name="ano_letivo_id" id="ano_letivo_id" class="form-select" required>
                            <option value="">Selecione o Ano Lectivo</option>
                            @foreach($anosLetivos ?? [] as $ano)
                                <option value="{{ $ano->id }}" {{ ($anoLetivoId ?? '') == $ano->id ? 'selected' : '' }}>
                                    {{ $ano->ano_inicial ?? explode('/', $ano->ano)[0] ?? $ano->ano }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label for="turma_id" class="form-label">Turma</label>
                        <select name="turma_id" id="turma_id" class="form-select" required>
                            <option value="">Selecione a Turma</option>
                            @foreach($todasTurmas ?? [] as $t)
                                <option value="{{ $t->id }}" {{ ($turmaId ?? '') == $t->id ? 'selected' : '' }}>
                                    {{ $t->codigo }} - {{ $t->nome }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label for="disciplina_id" class="form-label">Disciplina (opcional)</label>
                        <select name="disciplina_id" id="disciplina_id" class="form-select">
                            <option value="">Todas as Disciplinas</option>
                            @foreach($todasDisciplinas ?? [] as $disc)
                                <option value="{{ $disc->id }}" {{ ($disciplinaId ?? '') == $disc->id ? 'selected' : '' }}>
                                    {{ $disc->nome }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-12">
                        <button type="submit" class="btn btn-primary btn-sm">Filtrar</button>
                        <a href="{{ route('avaliacoes.todas-disciplinas') }}" class="btn btn-secondary btn-sm">Limpar</a>
                    </div>
                </form>
            </div>
        </div>

        @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        @if(isset($turma) && isset($anoLetivo))
            <div class="d-flex justify-content-between align-items-center mb-3 pb-2 border-bottom">
                <div class="text-muted small">
                    <span>{{ $turma->codigo }} - {{ $turma->nome }}</span>
                    <span class="ms-3">{{ $anoLetivo->ano_inicial ?? explode('/', $anoLetivo->ano)[0] ?? $anoLetivo->ano }}</span>
                    <span class="ms-3">{{ $disciplinas->count() }} disciplinas</span>
                </div>
                <div>
                    <a href="{{ route('avaliacoes.download-pdf-todas-disciplinas', ['turma_id' => $turma->id, 'ano_letivo_id' => $anoLetivo->id]) }}" 
                       class="btn btn-sm btn-outline-danger">
                        <i class="bi bi-file-earmark-pdf"></i> Download PDF
                    </a>
                    <button onclick="window.print()" class="btn btn-sm btn-outline-primary">
                        <i class="bi bi-printer"></i> Imprimir
                    </button>
                    <a href="{{ route('avaliacoes.index') }}" class="btn btn-sm btn-outline-secondary">Voltar</a>
                </div>
            </div>

        @if(isset($disciplinas) && $disciplinas->count() > 0)
            @php
                $isSecundario = ($turma->nivel_ensino ?? 'PRIMARIO') === 'SECUNDARIO';
            @endphp
            @foreach($disciplinas as $disciplina)
            <div class="mb-3">
                <h6 class="mb-2">{{ $disciplina->nome }}</h6>
                <div class="table-responsive">
                    <table class="table table-bordered table-sm" style="font-size: 0.7rem;">
                        <style>
                            .table-bordered th, .table-bordered td {
                                padding: 0.25rem 0.35rem !important;
                            }
                        </style>
                        <thead>
                            @if($isSecundario)
                                <tr>
                                    <th rowspan="2" class="align-middle">N°</th>
                                    <th rowspan="2" class="align-middle">Nome</th>
                                    <th rowspan="2" class="align-middle">G</th>
                                    @foreach($trimestres as $trimestre)
                                        <th colspan="4" class="text-center">{{ $trimestre->numero }}° Trimestre</th>
                                    @endforeach
                                    <th rowspan="2" class="align-middle">MFrD</th>
                                    <th rowspan="2" class="align-middle">Classificação</th>
                                </tr>
                                <tr>
                                    @foreach($trimestres as $trimestre)
                                        <th>Teste 1</th>
                                        <th>Teste 2</th>
                                        <th>Av. Final</th>
                                        <th>Média</th>
                                    @endforeach
                                </tr>
                            @else
                                <tr>
                                    <th rowspan="3" class="align-middle">N°</th>
                                    <th rowspan="3" class="align-middle">Nome</th>
                                    <th rowspan="3" class="align-middle">G</th>
                                    @foreach($trimestres as $trimestre)
                                        <th colspan="8" class="text-center">{{ $trimestre->numero }}° Trimestre</th>
                                    @endforeach
                                    <th rowspan="3" class="align-middle">MFrD</th>
                                    <th rowspan="3" class="align-middle">Classificação</th>
                                </tr>
                                <tr>
                                    @foreach($trimestres as $trimestre)
                                        <th colspan="3">A.Prática</th>
                                        <th colspan="2">ACS</th>
                                        <th rowspan="2" class="align-middle">MACS</th>
                                        <th rowspan="2" class="align-middle">AT</th>
                                        <th rowspan="2" class="align-middle">MT</th>
                                    @endforeach
                                </tr>
                                <tr>
                                    @foreach($trimestres as $trimestre)
                                        <th>1ª</th>
                                        <th>2ª</th>
                                        <th>MAP</th>
                                        <th>1ª</th>
                                        <th>2ª</th>
                                    @endforeach
                                </tr>
                            @endif
                        </thead>
                        <tbody>
                            @foreach($alunos as $index => $aluno)
                                @php
                                    $primeiraAvaliacao = collect($avaliacoesPorDisciplina[$disciplina->id][$aluno->id] ?? [])->first();
                                    $mfrd = $primeiraAvaliacao ? $primeiraAvaliacao->mfrd : null;
                                    $aprovado = \App\Models\Avaliacao::isAprovado($mfrd);
                                @endphp
                                <tr>
                                    <td class="text-center">{{ $index + 1 }}</td>
                                    <td>{{ $aluno->user->name }}</td>
                                    <td class="text-center">{{ $aluno->genero == 'M' ? 'H' : ($aluno->genero == 'F' ? 'M' : '') }}</td>
                                    @foreach($trimestres as $trimestre)
                                        @php
                                            $avaliacao = $avaliacoesPorDisciplina[$disciplina->id][$aluno->id][$trimestre->id] ?? null;
                                        @endphp
                                        @if($isSecundario)
                                            <td class="text-center {{ $avaliacao && $avaliacao->teste1 !== null && $avaliacao->teste1 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->teste1 !== null ? number_format($avaliacao->teste1, 1, '.', '') : '' }}</td>
                                            <td class="text-center {{ $avaliacao && $avaliacao->teste2 !== null && $avaliacao->teste2 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->teste2 !== null ? number_format($avaliacao->teste2, 1, '.', '') : '' }}</td>
                                            <td class="text-center {{ $avaliacao && $avaliacao->avaliacao_final !== null && $avaliacao->avaliacao_final < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->avaliacao_final !== null ? number_format($avaliacao->avaliacao_final, 1, '.', '') : '' }}</td>
                                            <td class="text-center fw-bold {{ $avaliacao && $avaliacao->media_nacional !== null && $avaliacao->media_nacional < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->media_nacional !== null ? number_format($avaliacao->media_nacional, 1, '.', '') : '' }}</td>
                                        @else
                                            <td class="text-center {{ $avaliacao && $avaliacao->a_pratica_1 !== null && $avaliacao->a_pratica_1 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->a_pratica_1 !== null ? number_format($avaliacao->a_pratica_1, 1, '.', '') : '' }}</td>
                                            <td class="text-center {{ $avaliacao && $avaliacao->a_pratica_2 !== null && $avaliacao->a_pratica_2 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->a_pratica_2 !== null ? number_format($avaliacao->a_pratica_2, 1, '.', '') : '' }}</td>
                                            <td class="text-center fw-bold {{ $avaliacao && $avaliacao->map !== null && $avaliacao->map < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->map !== null ? number_format($avaliacao->map, 1, '.', '') : '' }}</td>
                                            <td class="text-center {{ $avaliacao && $avaliacao->acs_1 !== null && $avaliacao->acs_1 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->acs_1 !== null ? number_format($avaliacao->acs_1, 1, '.', '') : '' }}</td>
                                            <td class="text-center {{ $avaliacao && $avaliacao->acs_2 !== null && $avaliacao->acs_2 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->acs_2 !== null ? number_format($avaliacao->acs_2, 1, '.', '') : '' }}</td>
                                            <td class="text-center fw-bold {{ $avaliacao && $avaliacao->macs !== null && $avaliacao->macs < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->macs !== null ? number_format($avaliacao->macs, 1, '.', '') : '' }}</td>
                                            <td class="text-center {{ $avaliacao && $avaliacao->at !== null && $avaliacao->at < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->at !== null ? number_format($avaliacao->at, 1, '.', '') : '' }}</td>
                                            <td class="text-center fw-bold {{ $avaliacao && $avaliacao->mt !== null && $avaliacao->mt < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->mt !== null ? number_format($avaliacao->mt, 0, '.', '') : '' }}</td>
                                        @endif
                                    @endforeach
                                    <td class="text-center fw-bold {{ $mfrd !== null && $mfrd < 10 ? 'text-danger' : '' }}">{{ $mfrd !== null ? number_format($mfrd, 0, '.', '') : '' }}</td>
                                    <td class="text-center {{ $aprovado ? 'text-success' : ($mfrd !== null ? 'text-danger' : '') }}">{{ $mfrd !== null ? ($aprovado ? 'APROVADO' : 'REPROVADO') : '' }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            @endforeach
        @elseif(isset($turma))
            <div class="alert alert-info">
                Nenhuma disciplina encontrada com os filtros selecionados.
            </div>
        @endif
        @endif
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const anoLetivoSelect = document.getElementById('ano_letivo_id');
        const turmaSelect = document.getElementById('turma_id');
        
        if (anoLetivoSelect) {
            anoLetivoSelect.addEventListener('change', function() {
                // Limpar seleção de turma quando mudar o ano letivo
                if (turmaSelect) {
                    turmaSelect.value = '';
                }
            });
        }
    });
</script>
@endsection

