<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Situação Pedagógica - {{ $configuracao['escola'] }}</title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
            font-family: 'Times New Roman', Times, serif;
        }
        
        @page {
            size: A4;
            margin: 15mm;
        }
        
        body {
            background-color: #f5f5f5;
            color: #000;
            line-height: 1.4;
            padding: 20px;
        }
        
        .document {
            background-color: white;
            padding: 20px;
            max-width: 100%;
        }
        
        .header {
            margin-bottom: 15px;
        }
        
        .escola-nome {
            font-size: 14pt;
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        .titulo {
            font-size: 12pt;
            font-weight: bold;
            margin-bottom: 10px;
        }
        
        .info-header {
            display: flex;
            justify-content: space-between;
            font-size: 10pt;
            margin-bottom: 15px;
        }
        
        .info-left {
            flex: 1;
        }
        
        .info-right {
            text-align: right;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 9pt;
            margin-bottom: 20px;
        }
        
        table th,
        table td {
            border: 1px solid #000;
            padding: 4px;
            text-align: center;
        }
        
        table th {
            background-color: #f0f0f0;
            font-weight: bold;
        }
        
        .col-numero {
            width: 30px;
        }
        
        .col-nome {
            width: 200px;
            text-align: left;
        }
        
        .col-genero {
            width: 40px;
        }
        
        .col-disciplina {
            width: 50px;
        }
        
        .col-media {
            width: 60px;
        }
        
        .col-classificacao {
            width: 100px;
        }
        
        .footer {
            text-align: center;
            margin-top: 30px;
            font-size: 10pt;
        }
        
        @media print {
            body {
                padding: 0;
            }
            .no-print {
                display: none;
            }
        }
        
        .print-btn {
            position: fixed;
            bottom: 20px;
            right: 20px;
            padding: 10px 20px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 14px;
            z-index: 1000;
        }
        
        .print-btn:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <div class="document">
        <div class="header">
            <div class="escola-nome">{{ strtoupper($configuracao['escola']) }}</div>
            <div class="titulo">Aproveitamento Pedagógico do {{ $trimestre->numero }}º Trimestre</div>
        </div>
        
        <div class="info-header">
            <div class="info-left">
                @if($turma->codigo)
                    {{ strtoupper($turma->codigo) }}
                @endif
            </div>
            <div class="info-right">
                Turma: {{ strtoupper($turma->nome) }} | Ano Lectivo: {{ $anoLetivo->ano_inicial ?? $anoLetivo->ano }}
            </div>
        </div>
        
        <table>
            <thead>
                <tr>
                    <th class="col-numero">Nº</th>
                    <th class="col-nome">Nome Completo</th>
                    <th class="col-genero">Gén.</th>
                    <th colspan="{{ $disciplinas->count() }}" style="text-align: center;">Médias por Disciplina</th>
                    <th class="col-media">Média Trimestral</th>
                    <th class="col-classificacao">Classificação</th>
                </tr>
                <tr>
                    <th></th>
                    <th></th>
                    <th></th>
                    @foreach($disciplinas as $disciplina)
                        @php
                            $abreviacoes = [
                                'Português' => 'Port.',
                                'Matemática' => 'Mat.',
                                'Ciências Naturais' => 'C. Nat.',
                                'Ciências Sociais' => 'C. Soc.',
                                'Educação Visual e Ofícios' => 'EVO',
                                'Educação Física' => 'E. Fis.',
                                'Física' => 'Físi',
                                'História' => 'HIST',
                                'Inglês' => 'Ingl.',
                                'Química' => 'Quím.',
                                'Biologia' => 'Biol.',
                            ];
                            $abrev = $abreviacoes[$disciplina->nome] ?? strtoupper(substr($disciplina->nome, 0, 5));
                        @endphp
                        <th class="col-disciplina">{{ $abrev }}</th>
                    @endforeach
                    <th></th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @foreach($situacoes as $index => $situacao)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td style="text-align: left;">{{ $situacao['aluno']->user->name }}</td>
                        <td>{{ $situacao['aluno']->genero == 'M' ? 'M' : ($situacao['aluno']->genero == 'F' ? 'F' : '-') }}</td>
                        @foreach($disciplinas as $disciplina)
                            <td>
                                @if(isset($situacao['mediasPorDisciplina'][$disciplina->id]) && $situacao['mediasPorDisciplina'][$disciplina->id] !== null)
                                    {{ $situacao['mediasPorDisciplina'][$disciplina->id] }}
                                @else
                                    -
                                @endif
                            </td>
                        @endforeach
                        <td>
                            @if($situacao['mediaTrimestralGeral'] !== null)
                                {{ $situacao['mediaTrimestralGeral'] }}
                            @else
                                -
                            @endif
                        </td>
                        <td><strong>{{ $situacao['classificacaoMedia'] ?? '-' }}</strong></td>
                    </tr>
                @endforeach
            </tbody>
        </table>
        
        <div class="footer">
            O(A) Director(a) de Turma
        </div>
    </div>
    
    <button class="print-btn no-print" onclick="window.print()">Imprimir</button>
</body>
</html>

