@extends('layouts.app')

@section('title', 'Situação Pedagógica - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h2>Situação Pedagógica</h2>
        </div>

        <div class="card">
            <div class="card-body">
                <form method="GET" action="{{ route('avaliacoes.situacao-pedagogica') }}" class="row g-3">
                    <div class="col-md-6">
                        <label for="turma_id" class="form-label">Turma</label>
                        <select class="form-select" name="turma_id" id="turma_id" required>
                            <option value="">Selecione uma turma</option>
                            @foreach($turmas as $turma)
                                <option value="{{ $turma->id }}">{{ $turma->codigo }} - {{ $turma->nome }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label for="trimestre_id" class="form-label">Trimestre</label>
                        <select class="form-select" name="trimestre_id" id="trimestre_id" required>
                            @foreach($trimestres as $trim)
                                <option value="{{ $trim->id }}" {{ $trim->numero == 1 ? 'selected' : '' }}>
                                    {{ $trim->numero }}º Trimestre
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-12">
                        <button type="submit" class="btn btn-primary">Visualizar Situação Pedagógica</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

