<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Avaliações - Todas as Disciplinas</title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        @page {
            size: A4 landscape;
            margin: 10mm;
        }
        
        body {
            font-family: Arial, sans-serif;
            font-size: 7pt;
            line-height: 1.2;
            color: #000;
            background: white;
        }
        
        .header {
            text-align: center;
            margin-bottom: 10px;
            padding-bottom: 8px;
            border-bottom: 2px solid #000;
            page-break-inside: avoid;
        }
        
        .emblema-topo {
            display: flex;
            justify-content: center;
            margin-bottom: 5px;
        }
        
        .emblema-container {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }
        
        .emblema {
            width: 50px;
            height: 50px;
            object-fit: contain;
        }
        
        .emblema-fallback {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: linear-gradient(135deg, #006600, #ffcc00, #ff0000, #000000, #ffffff);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 7px;
            text-align: center;
            padding: 3px;
            border: 1px solid #ddd;
        }
        
        .emblema-legenda {
            font-size: 8px;
            color: #333;
            margin-top: 2px;
            font-weight: bold;
        }
        
        .republica {
            font-size: 10pt;
            font-weight: bold;
            text-transform: uppercase;
            margin-bottom: 2px;
            color: #006600;
        }
        
        .distrito {
            font-size: 9pt;
            margin-bottom: 2px;
        }
        
        .escola {
            font-size: 9pt;
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        .titulo {
            font-size: 10pt;
            font-weight: bold;
            text-transform: uppercase;
            margin-top: 5px;
        }
        
        .info-header {
            font-size: 8pt;
            margin-bottom: 8px;
            padding: 5px;
            background-color: #f5f5f5;
            border: 1px solid #ddd;
        }
        
        .disciplina-section {
            margin-bottom: 20px;
            page-break-after: always;
        }
        
        .disciplina-section:last-child {
            page-break-after: auto;
        }
        
        .disciplina-nome {
            font-size: 9pt;
            font-weight: bold;
            margin-bottom: 5px;
            padding: 3px;
            background-color: #f0f0f0;
            border-bottom: 1px solid #000;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 6pt;
            margin-bottom: 10px;
        }
        
        table th,
        table td {
            border: 1px solid #000;
            padding: 2px;
            text-align: center;
        }
        
        table th {
            background-color: #f0f0f0;
            font-weight: bold;
        }
        
        .text-danger {
            color: #dc3545;
        }
        
        .text-success {
            color: #28a745;
        }
    </style>
</head>
<body>
    @php
        $isSecundario = ($turma->nivel_ensino ?? 'PRIMARIO') === 'SECUNDARIO';
    @endphp
    @foreach($disciplinas as $disciplina)
        <div class="disciplina-section">
            <div class="header">
                <div class="emblema-topo">
                    <div class="emblema-container">
                        <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRrnygkYHScEgMfdru0i6n-whqZS5e9mSPLwA&s" 
                             alt="Emblema da República de Moçambique" 
                             class="emblema"
                             onerror="this.style.display='none'; document.getElementById('emblema-fallback-{{ $disciplina->id }}').style.display='flex';">
                        <div id="emblema-fallback-{{ $disciplina->id }}" class="emblema-fallback" style="display: none;">
                            MZ
                        </div>
                        <div class="emblema-legenda">República de Moçambique</div>
                    </div>
                </div>
                
                <div class="republica">{{ $configuracao['republica'] }}</div>
                <div class="distrito">{{ $configuracao['distrito'] }}</div>
                <div class="escola">{{ $configuracao['escola'] }}</div>
                <div class="titulo">AVALIAÇÕES - TODAS AS DISCIPLINAS</div>
            </div>
            
            <div class="info-header">
                <strong>Turma:</strong> {{ $turma->codigo }} - {{ $turma->nome }} | 
                <strong>Ano Lectivo:</strong> {{ $anoLetivo->ano_inicial ?? $anoLetivo->ano }} | 
                <strong>Disciplina:</strong> {{ $disciplina->nome }}
            </div>
            
            <div class="disciplina-nome">{{ $disciplina->nome }}</div>
            <table>
                <thead>
                    @if($isSecundario)
                        <tr>
                            <th rowspan="2" class="align-middle">N°</th>
                            <th rowspan="2" class="align-middle">Nome</th>
                            <th rowspan="2" class="align-middle">G</th>
                            @foreach($trimestres as $trimestre)
                                <th colspan="4" class="text-center">{{ $trimestre->numero }}° Trimestre</th>
                            @endforeach
                            <th rowspan="2" class="align-middle">MFrD</th>
                            <th rowspan="2" class="align-middle">Classificação</th>
                        </tr>
                        <tr>
                            @foreach($trimestres as $trimestre)
                                <th>Teste 1</th>
                                <th>Teste 2</th>
                                <th>Av. Final</th>
                                <th>Média</th>
                            @endforeach
                        </tr>
                    @else
                        <tr>
                            <th rowspan="3" class="align-middle">N°</th>
                            <th rowspan="3" class="align-middle">Nome</th>
                            <th rowspan="3" class="align-middle">G</th>
                            @foreach($trimestres as $trimestre)
                                <th colspan="8" class="text-center">{{ $trimestre->numero }}° Trimestre</th>
                            @endforeach
                            <th rowspan="3" class="align-middle">MFrD</th>
                            <th rowspan="3" class="align-middle">Classificação</th>
                        </tr>
                        <tr>
                            @foreach($trimestres as $trimestre)
                                <th colspan="3">A.Prática</th>
                                <th colspan="2">ACS</th>
                                <th rowspan="2" class="align-middle">MACS</th>
                                <th rowspan="2" class="align-middle">AT</th>
                                <th rowspan="2" class="align-middle">MT</th>
                            @endforeach
                        </tr>
                        <tr>
                            @foreach($trimestres as $trimestre)
                                <th>1ª</th>
                                <th>2ª</th>
                                <th>MAP</th>
                                <th>1ª</th>
                                <th>2ª</th>
                            @endforeach
                        </tr>
                    @endif
                </thead>
                <tbody>
                    @foreach($alunos as $index => $aluno)
                        @php
                            $primeiraAvaliacao = collect($avaliacoesPorDisciplina[$disciplina->id][$aluno->id] ?? [])->first();
                            $mfrd = $primeiraAvaliacao ? $primeiraAvaliacao->mfrd : null;
                            $aprovado = \App\Models\Avaliacao::isAprovado($mfrd);
                        @endphp
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td style="text-align: left;">{{ $aluno->user->name }}</td>
                            <td>{{ $aluno->genero == 'M' ? 'H' : ($aluno->genero == 'F' ? 'M' : '') }}</td>
                            @foreach($trimestres as $trimestre)
                                @php
                                    $avaliacao = $avaliacoesPorDisciplina[$disciplina->id][$aluno->id][$trimestre->id] ?? null;
                                @endphp
                                @if($isSecundario)
                                    <td class="{{ $avaliacao && $avaliacao->teste1 !== null && $avaliacao->teste1 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->teste1 !== null ? number_format($avaliacao->teste1, 1, '.', '') : '' }}</td>
                                    <td class="{{ $avaliacao && $avaliacao->teste2 !== null && $avaliacao->teste2 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->teste2 !== null ? number_format($avaliacao->teste2, 1, '.', '') : '' }}</td>
                                    <td class="{{ $avaliacao && $avaliacao->avaliacao_final !== null && $avaliacao->avaliacao_final < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->avaliacao_final !== null ? number_format($avaliacao->avaliacao_final, 1, '.', '') : '' }}</td>
                                    <td style="font-weight: bold;" class="{{ $avaliacao && $avaliacao->media_nacional !== null && $avaliacao->media_nacional < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->media_nacional !== null ? number_format($avaliacao->media_nacional, 1, '.', '') : '' }}</td>
                                @else
                                    <td class="{{ $avaliacao && $avaliacao->a_pratica_1 !== null && $avaliacao->a_pratica_1 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->a_pratica_1 !== null ? number_format($avaliacao->a_pratica_1, 1, '.', '') : '' }}</td>
                                    <td class="{{ $avaliacao && $avaliacao->a_pratica_2 !== null && $avaliacao->a_pratica_2 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->a_pratica_2 !== null ? number_format($avaliacao->a_pratica_2, 1, '.', '') : '' }}</td>
                                    <td style="font-weight: bold;" class="{{ $avaliacao && $avaliacao->map !== null && $avaliacao->map < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->map !== null ? number_format($avaliacao->map, 1, '.', '') : '' }}</td>
                                    <td class="{{ $avaliacao && $avaliacao->acs_1 !== null && $avaliacao->acs_1 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->acs_1 !== null ? number_format($avaliacao->acs_1, 1, '.', '') : '' }}</td>
                                    <td class="{{ $avaliacao && $avaliacao->acs_2 !== null && $avaliacao->acs_2 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->acs_2 !== null ? number_format($avaliacao->acs_2, 1, '.', '') : '' }}</td>
                                    <td style="font-weight: bold;" class="{{ $avaliacao && $avaliacao->macs !== null && $avaliacao->macs < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->macs !== null ? number_format($avaliacao->macs, 1, '.', '') : '' }}</td>
                                    <td class="{{ $avaliacao && $avaliacao->at !== null && $avaliacao->at < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->at !== null ? number_format($avaliacao->at, 1, '.', '') : '' }}</td>
                                    <td style="font-weight: bold;" class="{{ $avaliacao && $avaliacao->mt !== null && $avaliacao->mt < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->mt !== null ? number_format($avaliacao->mt, 0, '.', '') : '' }}</td>
                                @endif
                            @endforeach
                            <td style="font-weight: bold;" class="{{ $mfrd !== null && $mfrd < 10 ? 'text-danger' : '' }}">{{ $mfrd !== null ? number_format($mfrd, 0, '.', '') : '' }}</td>
                            <td class="{{ $aprovado ? 'text-success' : ($mfrd !== null ? 'text-danger' : '') }}">{{ $mfrd !== null ? ($aprovado ? 'APROVADO' : 'REPROVADO') : '' }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @endforeach
</body>
</html>

