<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Notas por Estudante - {{ $turma->codigo }}</title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        @page {
            size: A4 landscape;
            margin: 10mm;
        }
        
        body {
            font-family: Arial, sans-serif;
            font-size: 8pt;
            line-height: 1.2;
            color: #000;
            background: white;
        }
        
        .document {
            width: 100%;
        }
        
        .header {
            text-align: center;
            margin-bottom: 10px;
            padding-bottom: 8px;
            border-bottom: 2px solid #000;
        }
        
        .escola-nome {
            font-size: 12pt;
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        .titulo {
            font-size: 10pt;
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        .info-header {
            font-size: 9pt;
            margin-bottom: 10px;
        }
        
        .aluno-section {
            margin-bottom: 20px;
            page-break-inside: avoid;
        }
        
        .aluno-nome {
            font-size: 10pt;
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 7pt;
            margin-bottom: 15px;
        }
        
        table th,
        table td {
            border: 1px solid #000;
            padding: 3px;
            text-align: center;
        }
        
        table th {
            background-color: #f0f0f0;
            font-weight: bold;
        }
        
        .text-danger {
            color: #dc3545;
        }
        
        .text-success {
            color: #28a745;
        }
        
        .no-print {
            display: none;
        }
        
        @media print {
            body {
                padding: 0;
            }
            .no-print {
                display: none;
            }
        }
        
        .print-btn {
            position: fixed;
            bottom: 20px;
            right: 20px;
            padding: 10px 20px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 14px;
            z-index: 1000;
        }
        
        .print-btn:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <div class="document">
        <div class="header">
            <div class="escola-nome">{{ strtoupper($configuracao['escola']) }}</div>
            <div class="titulo">NOTAS POR ESTUDANTE</div>
            <div class="info-header">
                Turma: {{ strtoupper($turma->codigo . ' - ' . $turma->nome) }} | 
                Ano Lectivo: {{ $anoLetivo->ano_inicial ?? $anoLetivo->ano }}
            </div>
        </div>
        
        @php
            $isSecundario = ($turma->nivel_ensino ?? 'PRIMARIO') === 'SECUNDARIO';
        @endphp
        @foreach($alunos as $aluno)
            <div class="aluno-section">
                <div class="aluno-nome">{{ $aluno->user->name }}</div>
                <table>
                    <thead>
                        @if($isSecundario)
                            <tr>
                                <th rowspan="2" style="vertical-align: middle;">Disciplina</th>
                                @foreach($trimestres as $trimestre)
                                    <th colspan="4" class="text-center">{{ $trimestre->numero }}° Trimestre</th>
                                @endforeach
                                <th rowspan="2" style="vertical-align: middle;">MFrD</th>
                                <th rowspan="2" style="vertical-align: middle;">Classificação</th>
                            </tr>
                            <tr>
                                @foreach($trimestres as $trimestre)
                                    <th>Teste 1</th>
                                    <th>Teste 2</th>
                                    <th>Av. Final</th>
                                    <th>Média</th>
                                @endforeach
                            </tr>
                        @else
                            <tr>
                                <th rowspan="3" style="vertical-align: middle;">Disciplina</th>
                                @foreach($trimestres as $trimestre)
                                    <th colspan="8" class="text-center">{{ $trimestre->numero }}° Trimestre</th>
                                @endforeach
                                <th rowspan="3" style="vertical-align: middle;">MFrD</th>
                                <th rowspan="3" style="vertical-align: middle;">Classificação</th>
                            </tr>
                            <tr>
                                @foreach($trimestres as $trimestre)
                                    <th colspan="3">A.Prática</th>
                                    <th colspan="2">ACS</th>
                                    <th rowspan="2" style="vertical-align: middle;">MACS</th>
                                    <th rowspan="2" style="vertical-align: middle;">AT</th>
                                    <th rowspan="2" style="vertical-align: middle;">MT</th>
                                @endforeach
                            </tr>
                            <tr>
                                @foreach($trimestres as $trimestre)
                                    <th>1ª</th>
                                    <th>2ª</th>
                                    <th>MAP</th>
                                    <th>1ª</th>
                                    <th>2ª</th>
                                @endforeach
                            </tr>
                        @endif
                    </thead>
                    <tbody>
                        @foreach($disciplinas as $disciplina)
                            @php
                                $primeiraAvaliacao = null;
                                $mfrd = null;
                                foreach ($trimestres as $trimestre) {
                                    $av = $avaliacoesPorAluno[$aluno->id][$disciplina->id][$trimestre->id] ?? null;
                                    if ($av && $av->mfrd !== null) {
                                        $primeiraAvaliacao = $av;
                                        $mfrd = $av->mfrd;
                                        break;
                                    }
                                }
                                $aprovado = \App\Models\Avaliacao::isAprovado($mfrd);
                            @endphp
                            <tr>
                                <td style="text-align: left;">{{ $disciplina->nome }}</td>
                            @foreach($trimestres as $trimestre)
                                @php
                                    $avaliacao = $avaliacoesPorAluno[$aluno->id][$disciplina->id][$trimestre->id] ?? null;
                                @endphp
                                @if($isSecundario)
                                    <td class="{{ $avaliacao && $avaliacao->teste1 !== null && $avaliacao->teste1 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->teste1 !== null ? number_format($avaliacao->teste1, 1, '.', '') : '' }}</td>
                                    <td class="{{ $avaliacao && $avaliacao->teste2 !== null && $avaliacao->teste2 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->teste2 !== null ? number_format($avaliacao->teste2, 1, '.', '') : '' }}</td>
                                    <td class="{{ $avaliacao && $avaliacao->avaliacao_final !== null && $avaliacao->avaliacao_final < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->avaliacao_final !== null ? number_format($avaliacao->avaliacao_final, 1, '.', '') : '' }}</td>
                                    <td style="font-weight: bold;" class="{{ $avaliacao && $avaliacao->media_nacional !== null && $avaliacao->media_nacional < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->media_nacional !== null ? number_format($avaliacao->media_nacional, 1, '.', '') : '' }}</td>
                                @else
                                    <td class="{{ $avaliacao && $avaliacao->a_pratica_1 !== null && $avaliacao->a_pratica_1 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->a_pratica_1 !== null ? number_format($avaliacao->a_pratica_1, 1, '.', '') : '' }}</td>
                                    <td class="{{ $avaliacao && $avaliacao->a_pratica_2 !== null && $avaliacao->a_pratica_2 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->a_pratica_2 !== null ? number_format($avaliacao->a_pratica_2, 1, '.', '') : '' }}</td>
                                    <td style="font-weight: bold;" class="{{ $avaliacao && $avaliacao->map !== null && $avaliacao->map < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->map !== null ? number_format($avaliacao->map, 1, '.', '') : '' }}</td>
                                    <td class="{{ $avaliacao && $avaliacao->acs_1 !== null && $avaliacao->acs_1 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->acs_1 !== null ? number_format($avaliacao->acs_1, 1, '.', '') : '' }}</td>
                                    <td class="{{ $avaliacao && $avaliacao->acs_2 !== null && $avaliacao->acs_2 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->acs_2 !== null ? number_format($avaliacao->acs_2, 1, '.', '') : '' }}</td>
                                    <td style="font-weight: bold;" class="{{ $avaliacao && $avaliacao->macs !== null && $avaliacao->macs < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->macs !== null ? number_format($avaliacao->macs, 1, '.', '') : '' }}</td>
                                    <td class="{{ $avaliacao && $avaliacao->at !== null && $avaliacao->at < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->at !== null ? number_format($avaliacao->at, 1, '.', '') : '' }}</td>
                                    <td style="font-weight: bold;" class="{{ $avaliacao && $avaliacao->mt !== null && $avaliacao->mt < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->mt !== null ? number_format($avaliacao->mt, 0, '.', '') : '' }}</td>
                                @endif
                            @endforeach
                                <td style="font-weight: bold;" class="{{ $mfrd !== null && $mfrd < 10 ? 'text-danger' : '' }}">{{ $mfrd !== null ? number_format($mfrd, 0, '.', '') : '' }}</td>
                                <td class="{{ $aprovado ? 'text-success' : ($mfrd !== null ? 'text-danger' : '') }}">{{ $mfrd !== null ? ($aprovado ? 'APROVADO' : 'REPROVADO') : '' }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endforeach
    </div>
    
    <button class="print-btn no-print" onclick="window.print()">Imprimir</button>
</body>
</html>

