<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ficha de Registo de Avaliações - {{ $disciplina->nome }}</title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        @page {
            size: A4 landscape;
            margin: 8mm;
        }
        
        body {
            font-family: Arial, sans-serif;
            font-size: 8pt;
            line-height: 1.2;
            color: #000;
            background: white;
            overflow-x: auto;
        }
        
        .document {
            width: 100%;
            min-width: 100%;
        }
        
        .header {
            text-align: center;
            margin-bottom: 10px;
            padding-bottom: 8px;
            border-bottom: 2px solid #000;
        }
        
        .emblema-topo {
            display: flex;
            justify-content: center;
            margin-bottom: 8px;
        }
        
        .emblema {
            width: 60px;
            height: 60px;
            object-fit: contain;
        }
        
        .emblema-fallback {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background: linear-gradient(135deg, #006600, #ffcc00, #ff0000, #000000, #ffffff);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 8px;
            text-align: center;
            padding: 5px;
            border: 1px solid #ddd;
        }
        
        .republica {
            font-size: 11pt;
            font-weight: bold;
            text-transform: uppercase;
            margin-bottom: 2px;
            color: #006600;
        }
        
        .distrito {
            font-size: 9pt;
            font-weight: bold;
            margin-bottom: 2px;
            color: #006600;
        }
        
        .escola {
            font-size: 11pt;
            font-weight: bold;
            text-transform: uppercase;
            margin-bottom: 5px;
            color: #900;
        }
        
        .titulo {
            font-size: 12pt;
            font-weight: bold;
            text-transform: uppercase;
            margin-top: 5px;
        }
        
        .info-header {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
            font-size: 9pt;
        }
        
        .info-left, .info-right {
            font-weight: bold;
        }
        
        .table-container {
            width: 100%;
            border-collapse: collapse;
            font-size: 7.5pt;
            margin-top: 5px;
            table-layout: auto;
        }
        
        .table-container th,
        .table-container td {
            border: 1px solid #000;
            padding: 4px 3px;
            text-align: center;
            vertical-align: middle;
        }
        
        .table-container th {
            background-color: #f0f0f0;
            font-weight: bold;
            font-size: 7pt;
        }
        
        .col-numero {
            width: 30px;
            min-width: 30px;
            max-width: 30px;
        }
        
        .col-nome {
            width: 150px;
            min-width: 150px;
            max-width: 150px;
            text-align: left;
            padding-left: 5px;
        }
        
        .col-genero {
            width: 25px;
            min-width: 25px;
            max-width: 25px;
        }
        
        .col-trimestre {
            width: auto;
            min-width: 200px;
        }
        
        .col-sub {
            width: 35px;
            min-width: 35px;
            max-width: 35px;
        }
        
        .col-media {
            width: 40px;
            min-width: 40px;
            max-width: 40px;
            font-weight: bold;
        }
        
        .col-mfrd {
            width: 45px;
            min-width: 45px;
            max-width: 45px;
            font-weight: bold;
        }
        
        .col-classificacao {
            width: 80px;
            min-width: 80px;
            max-width: 80px;
            font-weight: bold;
            text-align: center;
        }
        
        .nome-aluno {
            text-align: left;
            font-size: 7.5pt;
            padding-left: 5px;
        }
        
        .valor-nota {
            font-size: 8pt;
            padding: 3px;
        }
        
        .valor-media {
            font-weight: bold;
            font-size: 8pt;
            padding: 3px;
        }
        
        .table-container tbody tr:nth-child(even) {
            background-color: #fafafa;
        }
        
        @media print {
            body {
                background: white;
            }
            
            .no-print {
                display: none;
            }
        }
        
        .print-btn {
            display: block;
            width: 200px;
            margin: 20px auto;
            padding: 10px;
            background: #006600;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14pt;
        }
        
        .print-btn:hover {
            background: #008800;
        }
    </style>
</head>
<body>
    <div class="document">
        <div class="header">
            <div class="emblema-topo">
                <div class="emblema-container">
                    <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRrnygkYHScEgMfdru0i6n-whqZS5e9mSPLwA&s" 
                         alt="Emblema" 
                         class="emblema"
                         onerror="this.style.display='none'; document.getElementById('emblema-fallback').style.display='flex';">
                    <div id="emblema-fallback" class="emblema-fallback" style="display: none;">
                        MZ
                    </div>
                </div>
            </div>
            
            <div class="republica">{{ $configuracao['republica'] }}</div>
            <div class="distrito">{{ $configuracao['distrito'] }}</div>
            <div class="escola">{{ $configuracao['escola'] }}</div>
            <div class="titulo">FICHA DE REGISTO DE AVALIAÇÕES</div>
        </div>
        
        <div class="info-header">
            <div class="info-left">DISCIPLINA: {{ strtoupper($disciplina->nome) }}</div>
            <div class="info-right">
                @if($turma->codigo)
                    {{ strtoupper($turma->codigo) }}
                @endif
                @if($turma->codigo && $turma->nome)
                    | 
                @endif
                TURMA: {{ strtoupper($turma->nome) }} | ANO LECTIVO: {{ $anoLetivo->ano_inicial ?? $anoLetivo->ano }}
            </div>
        </div>
        
        {{-- Debug: Mostrar quantos trimestres foram carregados --}}
        @if(config('app.debug'))
            <div class="no-print" style="padding: 5px; background: #f0f0f0; margin-bottom: 5px; font-size: 8pt;">
                <strong>Debug:</strong> {{ $trimestres->count() }} trimestre(s) carregado(s): 
                @foreach($trimestres as $t)
                    {{ $t->numero }}° ({{ $t->nome }})
                @endforeach
            </div>
        @endif
        
        @php
            $isSecundario = ($turma->nivel_ensino ?? 'PRIMARIO') === 'SECUNDARIO';
        @endphp
        <div style="overflow-x: auto; width: 100%;" class="table-wrapper">
        <table class="table-container">
            <thead>
                @if($isSecundario)
                    <tr>
                        <th rowspan="2" class="col-numero">N°</th>
                        <th rowspan="2" class="col-nome">Nome completo do aluno</th>
                        <th rowspan="2" class="col-genero">G</th>
                        @foreach($trimestres as $trimestre)
                            <th colspan="4" class="col-trimestre">{{ $trimestre->numero }}° Trimestre</th>
                        @endforeach
                        <th rowspan="2" class="col-mfrd">MFrD</th>
                        <th rowspan="2" class="col-classificacao">Classificação</th>
                    </tr>
                    <tr>
                        @foreach($trimestres as $trimestre)
                            <th class="col-sub">Teste 1</th>
                            <th class="col-sub">Teste 2</th>
                            <th class="col-sub">Av. Final</th>
                            <th class="col-media">Média</th>
                        @endforeach
                    </tr>
                @else
                    <tr>
                        <th rowspan="2" class="col-numero">N°</th>
                        <th rowspan="2" class="col-nome">Nome completo do aluno</th>
                        <th rowspan="2" class="col-genero">G</th>
                        @foreach($trimestres as $trimestre)
                            <th colspan="8" class="col-trimestre">{{ $trimestre->numero }}° Trimestre</th>
                        @endforeach
                        <th rowspan="2" class="col-mfrd">MFrD</th>
                        <th rowspan="2" class="col-classificacao">Classificação</th>
                    </tr>
                    <tr>
                        @foreach($trimestres as $trimestre)
                            <th colspan="3">A.Prática</th>
                            <th colspan="3">ACS</th>
                            <th rowspan="2">AT</th>
                            <th rowspan="2">MT</th>
                        @endforeach
                    </tr>
                    <tr>
                        <th></th>
                        <th></th>
                        <th></th>
                        @foreach($trimestres as $trimestre)
                            <th class="col-sub">1ª</th>
                            <th class="col-sub">2ª</th>
                            <th class="col-media">MAP</th>
                            <th class="col-sub">1ª</th>
                            <th class="col-sub">2ª</th>
                            <th class="col-media">MACS</th>
                        @endforeach
                        <th></th>
                        <th></th>
                    </tr>
                @endif
            </thead>
            <tbody>
                @foreach($alunos as $index => $aluno)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td class="nome-aluno">{{ $aluno->user->name }}</td>
                        <td>{{ $aluno->genero == 'M' ? 'H' : ($aluno->genero == 'F' ? 'M' : '') }}</td>
                        @foreach($trimestres as $trimestre)
                            @php
                                $avaliacao = $avaliacoes[$aluno->id][$trimestre->id] ?? null;
                            @endphp
                            @if($isSecundario)
                                <td class="valor-nota" style="{{ $avaliacao && $avaliacao->teste1 !== null && $avaliacao->teste1 < 10 ? 'color: red;' : '' }}">
                                    @if($avaliacao && $avaliacao->teste1 !== null)
                                        {{ number_format($avaliacao->teste1, 1, '.', '') }}
                                    @endif
                                </td>
                                <td class="valor-nota" style="{{ $avaliacao && $avaliacao->teste2 !== null && $avaliacao->teste2 < 10 ? 'color: red;' : '' }}">
                                    @if($avaliacao && $avaliacao->teste2 !== null)
                                        {{ number_format($avaliacao->teste2, 1, '.', '') }}
                                    @endif
                                </td>
                                <td class="valor-nota" style="{{ $avaliacao && $avaliacao->avaliacao_final !== null && $avaliacao->avaliacao_final < 10 ? 'color: red;' : '' }}">
                                    @if($avaliacao && $avaliacao->avaliacao_final !== null)
                                        {{ number_format($avaliacao->avaliacao_final, 1, '.', '') }}
                                    @endif
                                </td>
                                <td class="valor-media" style="{{ $avaliacao && $avaliacao->media_nacional !== null && $avaliacao->media_nacional < 10 ? 'color: red;' : '' }}">
                                    @if($avaliacao && $avaliacao->media_nacional !== null)
                                        {{ number_format($avaliacao->media_nacional, 1, '.', '') }}
                                    @endif
                                </td>
                            @else
                                {{-- A.Prática 1ª --}}
                                <td class="valor-nota" style="{{ $avaliacao && $avaliacao->a_pratica_1 !== null && $avaliacao->a_pratica_1 < 10 ? 'color: red;' : '' }}">
                                    @if($avaliacao && $avaliacao->a_pratica_1 !== null)
                                        {{ number_format($avaliacao->a_pratica_1, 1, '.', '') }}
                                    @endif
                                </td>
                                {{-- A.Prática 2ª --}}
                                <td class="valor-nota" style="{{ $avaliacao && $avaliacao->a_pratica_2 !== null && $avaliacao->a_pratica_2 < 10 ? 'color: red;' : '' }}">
                                    @if($avaliacao && $avaliacao->a_pratica_2 !== null)
                                        {{ number_format($avaliacao->a_pratica_2, 1, '.', '') }}
                                    @endif
                                </td>
                                {{-- MAP --}}
                                <td class="valor-media" style="{{ $avaliacao && $avaliacao->map !== null && $avaliacao->map < 10 ? 'color: red;' : '' }}">
                                    @if($avaliacao && $avaliacao->map !== null)
                                        {{ number_format($avaliacao->map, 1, '.', '') }}
                                    @endif
                                </td>
                                {{-- ACS 1ª --}}
                                <td class="valor-nota" style="{{ $avaliacao && $avaliacao->acs_1 !== null && $avaliacao->acs_1 < 10 ? 'color: red;' : '' }}">
                                    @if($avaliacao && $avaliacao->acs_1 !== null)
                                        {{ number_format($avaliacao->acs_1, 1, '.', '') }}
                                    @endif
                                </td>
                                {{-- ACS 2ª --}}
                                <td class="valor-nota" style="{{ $avaliacao && $avaliacao->acs_2 !== null && $avaliacao->acs_2 < 10 ? 'color: red;' : '' }}">
                                    @if($avaliacao && $avaliacao->acs_2 !== null)
                                        {{ number_format($avaliacao->acs_2, 1, '.', '') }}
                                    @endif
                                </td>
                                {{-- MACS --}}
                                <td class="valor-media" style="{{ $avaliacao && $avaliacao->macs !== null && $avaliacao->macs < 10 ? 'color: red;' : '' }}">
                                    @if($avaliacao && $avaliacao->macs !== null)
                                        {{ number_format($avaliacao->macs, 1, '.', '') }}
                                    @endif
                                </td>
                                {{-- AT --}}
                                <td class="valor-nota" style="{{ $avaliacao && $avaliacao->at !== null && $avaliacao->at < 10 ? 'color: red;' : '' }}">
                                    @if($avaliacao && $avaliacao->at !== null)
                                        {{ number_format($avaliacao->at, 1, '.', '') }}
                                    @endif
                                </td>
                                {{-- MT --}}
                                <td class="valor-media" style="{{ $avaliacao && $avaliacao->mt !== null && $avaliacao->mt < 10 ? 'color: red;' : '' }}">
                                    @if($avaliacao && $avaliacao->mt !== null)
                                        {{ number_format($avaliacao->mt, 0, '.', '') }}
                                    @endif
                                </td>
                            @endif
                        @endforeach
                        {{-- MFrD --}}
                        @php
                            $primeiraAvaliacao = collect($avaliacoes[$aluno->id])->first();
                            $mfrd = $primeiraAvaliacao ? $primeiraAvaliacao->mfrd : null;
                            // Aprovado se MFrD >= 10 (com arredondamento por excesso de 9.5-9.99 para 10)
                            $aprovado = \App\Models\Avaliacao::isAprovado($mfrd);
                        @endphp
                        <td class="valor-media" style="{{ $mfrd !== null && !\App\Models\Avaliacao::isAprovado($mfrd) ? 'color: red;' : '' }}">
                            @if($mfrd !== null)
                                {{ number_format($mfrd, 0, '.', '') }}
                            @endif
                        </td>
                        {{-- Classificação --}}
                        <td class="valor-media" style="font-weight: bold; {{ $aprovado ? 'color: green;' : 'color: red;' }}">
                            @if($mfrd !== null)
                                {{ $aprovado ? 'APROVADO' : 'REPROVADO' }}
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
        </div>
    </div>
    
    <button class="print-btn no-print" onclick="window.print()">Imprimir</button>
    
    <script>
        // Garantir que todos os trimestres sejam visíveis
        document.addEventListener('DOMContentLoaded', function() {
            const table = document.querySelector('.table-container');
            const trimestres = {{ $trimestres->count() }};
            console.log('Trimestres carregados:', trimestres);
            
            // Verificar se a tabela está cortando algum trimestre
            const headerCells = document.querySelectorAll('.table-container thead tr:first-child th');
            console.log('Células de cabeçalho encontradas:', headerCells.length);
        });
    </script>
</body>
</html>

