@extends('layouts.app')

@section('title', 'Login - SGE')

@section('content')
<style>
    .login-container {
        min-height: calc(100vh - 200px);
        display: flex;
        align-items: center;
        justify-content: center;
    }
</style>
<div class="login-container">
    <div class="row justify-content-center w-100">
        <div class="col-md-4">
            <div class="card">
                <div class="card-header bg-primary-custom text-white">
                    <h4 class="mb-0">Login - SGE</h4>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('login') }}">
                        @csrf

                        <div class="mb-3">
                            <label for="login" class="form-label">Código</label>
                            <input type="text" class="form-control @error('login') is-invalid @enderror" 
                                   id="login" name="login" value="{{ old('login') }}" required autofocus>
                            @error('login')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                    <div class="mb-3">
                        <label for="password" class="form-label">Senha</label>
                        <input type="password" class="form-control @error('password') is-invalid @enderror" 
                               id="password" name="password" required>
                        @error('password')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3 form-check">
                        <input type="checkbox" class="form-check-input" id="remember" name="remember">
                        <label class="form-check-label" for="remember">Lembrar-me</label>
                    </div>

                    <button type="submit" class="btn btn-primary-custom w-100">Entrar</button>
                </form>

                <div class="mt-3 text-center">
                    <a href="{{ route('password.request') }}">Esqueceu a senha?</a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection



