@extends('layouts.app')

@section('title', 'Pagamento Confirmado - Estudante')

@section('content')
<div class="row justify-content-center">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0">Pagamento Confirmado</h5>
            </div>
            <div class="card-body text-center">
                <div class="mb-4">
                    <i class="bi bi-check-circle display-1 text-success"></i>
                </div>
                
                <h4>Pagamento Aprovado!</h4>
                <p class="text-muted">O seu pagamento foi processado com sucesso.</p>

                <div class="alert alert-success">
                    <strong>Referência:</strong> {{ $payment->reference }}<br>
                    <strong>Valor:</strong> {{ number_format($payment->valor, 2, ',', '.') }} MT<br>
                    <strong>Data:</strong> {{ $payment->data_pagamento->format('d/m/Y H:i') }}
                </div>

                @if($payment->invoice)
                    <div class="d-grid gap-2">
                        <a href="{{ route('aluno.invoice.show', $payment->invoice) }}" class="btn btn-primary">
                            <i class="bi bi-receipt me-1"></i> Ver Factura
                        </a>
                        <a href="{{ route('aluno.invoice.download', $payment->invoice) }}" class="btn btn-outline-primary">
                            <i class="bi bi-download me-1"></i> Descarregar Factura PDF
                        </a>
                    </div>
                @endif

                <div class="mt-3">
                    <a href="{{ route('aluno.financeiro') }}" class="btn btn-secondary">Voltar</a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

