@extends('layouts.app')

@section('title', 'Processar Pagamento - Estudante')

@section('content')
<div class="row justify-content-center">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">Processar Pagamento</h5>
            </div>
            <div class="card-body text-center">
                <div class="mb-4">
                    <i class="bi bi-{{ $payment->metodo === 'MPESA' ? 'phone' : 'wallet2' }} display-1 text-primary"></i>
                </div>
                
                <h4>Referência: {{ $payment->reference }}</h4>
                <p class="text-muted">Valor: {{ number_format($payment->valor, 2, ',', '.') }} MT</p>
                <p class="text-muted">Método: {{ $payment->metodo === 'MPESA' ? 'M-Pesa' : 'Emola' }}</p>

                <div class="alert alert-info">
                    <i class="bi bi-info-circle me-2"></i>
                    <strong>Nota:</strong> Esta é uma simulação. Em produção, será redireccionado para o gateway de pagamento real.
                </div>

                <form method="POST" action="{{ route('aluno.payment.confirm', $payment) }}">
                    @csrf
                    <button type="submit" class="btn btn-success btn-lg">
                        <i class="bi bi-check-circle me-1"></i> Confirmar Pagamento (Simulação)
                    </button>
                </form>

                <div class="mt-3">
                    <a href="{{ route('aluno.financeiro') }}" class="btn btn-secondary">Cancelar</a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

