@extends('layouts.app')

@section('title', 'Minhas Notas - Estudante')

@section('content')
<style>
    /* Estilos Mobile para Visualização de Notas */
    @media (max-width: 768px) {
        .notas-mobile-header {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
            padding: 1rem;
            margin: -1rem -1rem 1.5rem -1rem;
            position: relative;
        }
        
        .notas-mobile-header .back-btn {
            position: absolute;
            top: 1rem;
            left: 1rem;
            color: white;
            font-size: 1.5rem;
            text-decoration: none;
            z-index: 10;
        }
        
        .notas-mobile-header h1 {
            font-size: 1.1rem;
            font-weight: bold;
            margin: 0.5rem 0;
            text-align: center;
        }
        
        .notas-mobile-filters {
            background: white;
            padding: 1rem;
            margin: 0 -1rem 1rem -1rem;
            border-bottom: 1px solid #e0e0e0;
        }
        
        .notas-mobile-filters .form-select {
            font-size: 0.9rem;
            padding: 0.5rem;
        }
        
        .notas-mobile-disciplina-card {
            background: white;
            border: 1px solid #e0e0e0;
            border-radius: 12px;
            margin-bottom: 1rem;
            padding: 1rem;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }
        
        .notas-mobile-disciplina-header {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            margin-bottom: 1rem;
            padding-bottom: 0.75rem;
            border-bottom: 2px solid #4a90e2;
        }
        
        .notas-mobile-disciplina-header i {
            font-size: 1.2rem;
            color: #4a90e2;
        }
        
        .notas-mobile-disciplina-header h5 {
            font-size: 1rem;
            font-weight: 600;
            color: #333;
            margin: 0;
        }
        
        .notas-mobile-trimestre-card {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 0.75rem;
            margin-bottom: 0.75rem;
        }
        
        .notas-mobile-trimestre-title {
            font-size: 0.85rem;
            font-weight: 600;
            color: #4a90e2;
            margin-bottom: 0.75rem;
            text-align: center;
            padding: 0.5rem;
            background: white;
            border-radius: 6px;
        }
        
        .notas-mobile-secao {
            margin-bottom: 0.75rem;
        }
        
        .notas-mobile-secao-titulo {
            font-size: 0.75rem;
            font-weight: 600;
            color: #666;
            margin-bottom: 0.5rem;
            padding-bottom: 0.25rem;
            border-bottom: 1px solid #dee2e6;
        }
        
        .notas-mobile-notas-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 0.5rem;
            margin-bottom: 0.5rem;
        }
        
        .notas-mobile-nota-item {
            background: white;
            border: 1px solid #dee2e6;
            border-radius: 6px;
            padding: 0.5rem;
            text-align: center;
        }
        
        .notas-mobile-nota-label {
            font-size: 0.65rem;
            color: #666;
            margin-bottom: 0.25rem;
            font-weight: 500;
        }
        
        .notas-mobile-nota-valor {
            font-size: 0.9rem;
            font-weight: 600;
            color: #333;
        }
        
        .notas-mobile-nota-valor.media {
            font-size: 1rem;
            color: #4a90e2;
        }
        
        .notas-mobile-nota-valor.reprovado {
            color: #dc3545;
        }
        
        .notas-mobile-nota-valor.aprovado {
            color: #28a745;
        }
        
        .notas-mobile-actions {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            padding: 1rem;
            border-top: 1px solid #e0e0e0;
            z-index: 100;
            box-shadow: 0 -2px 8px rgba(0,0,0,0.1);
            display: flex;
            gap: 0.75rem;
        }
        
        .notas-mobile-actions .btn {
            flex: 1;
            padding: 0.75rem;
            font-size: 0.9rem;
            font-weight: 600;
            border-radius: 8px;
        }
        
        .notas-mobile-content {
            padding-bottom: 80px;
        }
    }
    
    /* Desktop - manter layout atual */
    @media (min-width: 769px) {
        .notas-mobile-header,
        .notas-mobile-filters,
        .notas-mobile-content,
        .notas-mobile-actions {
            display: none;
        }
    }
</style>

<!-- Layout Mobile -->
<div class="d-md-none notas-mobile-content">
    <div class="notas-mobile-header">
        <a href="{{ route('aluno.dashboard') }}" class="back-btn">
            <i class="bi bi-arrow-left"></i>
        </a>
        <h1>Minhas Notas</h1>
    </div>
    
    <div class="notas-mobile-filters">
        <form method="GET" action="{{ route('aluno.notas') }}">
            <div class="mb-3">
                <label for="ano_letivo_id_mobile" class="form-label small">Ano Lectivo:</label>
                <select name="ano_letivo_id" id="ano_letivo_id_mobile" class="form-select" onchange="this.form.submit()">
                    @foreach($anosLetivos ?? [] as $ano)
                        @php
                            $anoRaw = $ano->getRawOriginal('ano');
                            $anoFinal = strpos($anoRaw, '/') !== false ? explode('/', $anoRaw)[1] : $anoRaw;
                        @endphp
                        <option value="{{ $ano->id }}" {{ $anoLetivoAtivo && $anoLetivoAtivo->id == $ano->id ? 'selected' : '' }}>
                            {{ $anoFinal }}
                            @if($ano->ativo) (Activo) @endif
                        </option>
                    @endforeach
                </select>
            </div>
            @if($disciplinas->count() > 0)
                <div>
                    <label for="trimestre_id_mobile" class="form-label small">Filtrar por Trimestre:</label>
                    <select name="trimestre_id" id="trimestre_id_mobile" class="form-select" onchange="this.form.submit()">
                        <option value="">Todos os Trimestres</option>
                        @foreach($trimestres as $trimestre)
                            <option value="{{ $trimestre->id }}" {{ request('trimestre_id') == $trimestre->id ? 'selected' : '' }}>
                                {{ $trimestre->nome }}
                            </option>
                        @endforeach
                    </select>
                </div>
            @endif
        </form>
    </div>
    
    @if($disciplinas->count() > 0)
        @php
            $trimestreSelecionado = request('trimestre_id') ? $trimestres->firstWhere('id', request('trimestre_id')) : null;
            $trimestresParaMostrar = $trimestreSelecionado ? collect([$trimestreSelecionado]) : $trimestres;
            
            $todosTrimestresCompletos = true;
            foreach ($disciplinas as $disciplina) {
                foreach ($trimestres as $trimestre) {
                    $avaliacao = $avaliacoesPorDisciplina[$disciplina->id][$trimestre->id] ?? null;
                    if (!$avaliacao || $avaliacao->mt === null) {
                        $todosTrimestresCompletos = false;
                        break 2;
                    }
                }
            }
        @endphp
        
        @foreach($disciplinas as $disciplina)
            <div class="notas-mobile-disciplina-card">
                <div class="notas-mobile-disciplina-header">
                    <i class="bi bi-book"></i>
                    <h5>{{ $disciplina->nome }}</h5>
                </div>
                
                @foreach($trimestresParaMostrar as $trimestre)
                    @php
                        $avaliacao = $avaliacoesPorDisciplina[$disciplina->id][$trimestre->id] ?? null;
                        $mfrd = $avaliacao->mfrd ?? null;
                    @endphp
                    
                    <div class="notas-mobile-trimestre-card">
                        <div class="notas-mobile-trimestre-title">{{ $trimestre->nome }}</div>
                        
                        <!-- A.Prática -->
                        <div class="notas-mobile-secao">
                            <div class="notas-mobile-secao-titulo">A.Prática</div>
                            <div class="notas-mobile-notas-grid">
                                <div class="notas-mobile-nota-item">
                                    <div class="notas-mobile-nota-label">1ª</div>
                                    <div class="notas-mobile-nota-valor {{ $avaliacao && $avaliacao->a_pratica_1 !== null && $avaliacao->a_pratica_1 < 10 ? 'reprovado' : '' }}">
                                        {{ $avaliacao && $avaliacao->a_pratica_1 !== null ? number_format($avaliacao->a_pratica_1, 1) : '-' }}
                                    </div>
                                </div>
                                <div class="notas-mobile-nota-item">
                                    <div class="notas-mobile-nota-label">2ª</div>
                                    <div class="notas-mobile-nota-valor {{ $avaliacao && $avaliacao->a_pratica_2 !== null && $avaliacao->a_pratica_2 < 10 ? 'reprovado' : '' }}">
                                        {{ $avaliacao && $avaliacao->a_pratica_2 !== null ? number_format($avaliacao->a_pratica_2, 1) : '-' }}
                                    </div>
                                </div>
                                <div class="notas-mobile-nota-item">
                                    <div class="notas-mobile-nota-label">MAP</div>
                                    <div class="notas-mobile-nota-valor media {{ $avaliacao && $avaliacao->map !== null && $avaliacao->map < 10 ? 'reprovado' : '' }}">
                                        {{ $avaliacao && $avaliacao->map !== null ? number_format($avaliacao->map, 1) : '-' }}
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- ACS -->
                        <div class="notas-mobile-secao">
                            <div class="notas-mobile-secao-titulo">ACS</div>
                            <div class="notas-mobile-notas-grid">
                                <div class="notas-mobile-nota-item">
                                    <div class="notas-mobile-nota-label">1ª</div>
                                    <div class="notas-mobile-nota-valor {{ $avaliacao && $avaliacao->acs_1 !== null && $avaliacao->acs_1 < 10 ? 'reprovado' : '' }}">
                                        {{ $avaliacao && $avaliacao->acs_1 !== null ? number_format($avaliacao->acs_1, 1) : '-' }}
                                    </div>
                                </div>
                                <div class="notas-mobile-nota-item">
                                    <div class="notas-mobile-nota-label">2ª</div>
                                    <div class="notas-mobile-nota-valor {{ $avaliacao && $avaliacao->acs_2 !== null && $avaliacao->acs_2 < 10 ? 'reprovado' : '' }}">
                                        {{ $avaliacao && $avaliacao->acs_2 !== null ? number_format($avaliacao->acs_2, 1) : '-' }}
                                    </div>
                                </div>
                                <div class="notas-mobile-nota-item">
                                    <div class="notas-mobile-nota-label">MACS</div>
                                    <div class="notas-mobile-nota-valor media {{ $avaliacao && $avaliacao->macs !== null && $avaliacao->macs < 10 ? 'reprovado' : '' }}">
                                        {{ $avaliacao && $avaliacao->macs !== null ? number_format($avaliacao->macs, 1) : '-' }}
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- AT, MT e MFrD -->
                        <div class="notas-mobile-secao">
                            <div class="notas-mobile-notas-grid">
                                <div class="notas-mobile-nota-item">
                                    <div class="notas-mobile-nota-label">AT</div>
                                    <div class="notas-mobile-nota-valor {{ $avaliacao && $avaliacao->at !== null && $avaliacao->at < 10 ? 'reprovado' : '' }}">
                                        {{ $avaliacao && $avaliacao->at !== null ? number_format($avaliacao->at, 1) : '-' }}
                                    </div>
                                </div>
                                <div class="notas-mobile-nota-item">
                                    <div class="notas-mobile-nota-label">MT</div>
                                    <div class="notas-mobile-nota-valor media {{ $avaliacao && $avaliacao->mt !== null && $avaliacao->mt < 10 ? 'reprovado' : 'aprovado' }}">
                                        {{ $avaliacao && $avaliacao->mt !== null ? number_format($avaliacao->mt, 0) : '-' }}
                                    </div>
                                </div>
                                <div class="notas-mobile-nota-item">
                                    <div class="notas-mobile-nota-label">MFrD</div>
                                    <div class="notas-mobile-nota-valor media {{ $mfrd !== null && !\App\Models\Avaliacao::isAprovado($mfrd) ? 'reprovado' : ($mfrd !== null ? 'aprovado' : '') }}">
                                        {{ $mfrd !== null ? number_format($mfrd, 0) : '-' }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @endforeach
        
        <!-- Resultados Anuais Mobile -->
        @if($todosTrimestresCompletos && !$trimestreSelecionado)
            <div class="notas-mobile-disciplina-card" style="background: #fff3cd; border-color: #ffc107;">
                <div class="notas-mobile-disciplina-header" style="border-color: #ffc107;">
                    <i class="bi bi-trophy"></i>
                    <h5>Resultados Anuais (Finais)</h5>
                </div>
                
                @foreach($disciplinas as $disciplina)
                    @php
                        $mfrd = null;
                        foreach ($trimestres as $trimestre) {
                            $avaliacao = $avaliacoesPorDisciplina[$disciplina->id][$trimestre->id] ?? null;
                            if ($avaliacao && $avaliacao->mfrd !== null) {
                                $mfrd = $avaliacao->mfrd;
                                break;
                            }
                        }
                        $aprovado = $mfrd !== null ? \App\Models\Avaliacao::isAprovado($mfrd) : false;
                    @endphp
                    
                    <div class="notas-mobile-trimestre-card" style="margin-bottom: 0.5rem;">
                        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 0.5rem;">
                            <strong style="font-size: 0.9rem;">{{ $disciplina->nome }}</strong>
                            @if($mfrd !== null)
                                <span class="badge bg-{{ $aprovado ? 'success' : 'danger' }}" style="font-size: 0.85rem;">
                                    {{ $aprovado ? 'APROVADO' : 'REPROVADO' }}
                                </span>
                            @endif
                        </div>
                        <div style="text-align: center;">
                            <div style="font-size: 0.75rem; color: #666; margin-bottom: 0.25rem;">Média Final (MFrD)</div>
                            @if($mfrd !== null)
                                <div style="font-size: 1.5rem; font-weight: bold; color: {{ $aprovado ? '#28a745' : '#dc3545' }};">
                                    {{ number_format($mfrd, 0) }}
                                </div>
                            @else
                                <div style="font-size: 0.9rem; color: #999;">Aguardando cálculo</div>
                            @endif
                        </div>
                    </div>
                @endforeach
            </div>
        @endif
    @else
        <div class="notas-mobile-disciplina-card" style="text-align: center; padding: 2rem;">
            <i class="bi bi-inbox" style="font-size: 3rem; color: #ccc; margin-bottom: 1rem;"></i>
            <div style="color: #666;">Nenhuma nota registrada ainda.</div>
        </div>
    @endif
    
    <div class="notas-mobile-actions">
        <a href="{{ route('aluno.folheto-aproveitamento') }}" class="btn btn-warning" target="_blank">
            <i class="bi bi-file-text me-1"></i> Folheto
        </a>
    </div>
</div>

<!-- Layout Desktop -->
<div class="d-none d-md-block">
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">
                <i class="bi bi-clipboard-check text-success me-2"></i>
                Minhas Notas
            </h4>
            <div>
                <a href="{{ route('aluno.folheto-aproveitamento') }}" class="btn btn-warning btn-sm me-2" target="_blank">
                    <i class="bi bi-file-text me-1"></i> Folheto de Aproveitamento
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Filtro por Ano Letivo -->
<div class="card border-0 shadow-sm mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('aluno.notas') }}" class="row g-3 align-items-end">
            <div class="col-md-4">
                <label for="ano_letivo_id" class="form-label">Ano Lectivo:</label>
                <select name="ano_letivo_id" id="ano_letivo_id" class="form-select" onchange="this.form.submit()">
                    @foreach($anosLetivos ?? [] as $ano)
                        @php
                            $anoRaw = $ano->getRawOriginal('ano');
                            $anoFinal = strpos($anoRaw, '/') !== false ? explode('/', $anoRaw)[1] : $anoRaw;
                        @endphp
                        <option value="{{ $ano->id }}" {{ $anoLetivoAtivo && $anoLetivoAtivo->id == $ano->id ? 'selected' : '' }}>
                            {{ $anoFinal }}
                            @if($ano->ativo) (Activo) @endif
                        </option>
                    @endforeach
                </select>
            </div>
        </form>
    </div>
</div>

@if($disciplinas->count() > 0)
    <!-- Filtro por Trimestre -->
    <div class="card border-0 shadow-sm mb-3">
        <div class="card-body">
            <form method="GET" action="{{ route('aluno.notas') }}" class="row g-3 align-items-end">
                <div class="col-md-4">
                    <label for="trimestre_id" class="form-label">Filtrar por Trimestre:</label>
                    <select name="trimestre_id" id="trimestre_id" class="form-select" onchange="this.form.submit()">
                        <option value="">Todos os Trimestres</option>
                        @foreach($trimestres as $trimestre)
                            <option value="{{ $trimestre->id }}" {{ request('trimestre_id') == $trimestre->id ? 'selected' : '' }}>
                                {{ $trimestre->nome }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-8">
                    <button type="submit" class="btn btn-primary-custom">
                        <i class="bi bi-funnel me-1"></i> Filtrar
                    </button>
                    @if(request('trimestre_id'))
                        <a href="{{ route('aluno.notas') }}" class="btn btn-outline-secondary">
                            <i class="bi bi-x-circle me-1"></i> Limpar Filtro
                        </a>
                    @endif
                </div>
            </form>
        </div>
    </div>

    @php
        $trimestreSelecionado = request('trimestre_id') ? $trimestres->firstWhere('id', request('trimestre_id')) : null;
        $trimestresParaMostrar = $trimestreSelecionado ? collect([$trimestreSelecionado]) : $trimestres;
        
        // Verificar se todos os trimestres têm avaliações para mostrar resultados anuais
        $todosTrimestresCompletos = true;
        foreach ($disciplinas as $disciplina) {
            foreach ($trimestres as $trimestre) {
                $avaliacao = $avaliacoesPorDisciplina[$disciplina->id][$trimestre->id] ?? null;
                if (!$avaliacao || $avaliacao->mt === null) {
                    $todosTrimestresCompletos = false;
                    break 2;
                }
            }
        }
    @endphp

    <!-- Notas por Trimestre -->
    @foreach($disciplinas as $disciplina)
        <div class="card border-0 shadow-sm mb-3">
            <div class="card-header bg-white">
                <h5 class="mb-0">
                    <i class="bi bi-book text-primary me-2"></i>
                    {{ $disciplina->nome }}
                </h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-sm">
                        <thead class="table-light">
                            <tr>
                                <th rowspan="2" style="vertical-align: middle;">Trimestre</th>
                                <th colspan="3">A.Prática</th>
                                <th colspan="3">ACS</th>
                                <th rowspan="2" style="vertical-align: middle;">AT</th>
                                <th rowspan="2" style="vertical-align: middle;">MT</th>
                                <th rowspan="2" style="vertical-align: middle;">MFrD</th>
                            </tr>
                            <tr>
                                <th>1ª</th>
                                <th>2ª</th>
                                <th>MAP</th>
                                <th>1ª</th>
                                <th>2ª</th>
                                <th>MACS</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($trimestresParaMostrar as $trimestre)
                                @php
                                    $avaliacao = $avaliacoesPorDisciplina[$disciplina->id][$trimestre->id] ?? null;
                                    $mfrd = $avaliacao->mfrd ?? null;
                                @endphp
                                <tr>
                                    <td><strong>{{ $trimestre->nome }}</strong></td>
                                    <td class="text-center {{ $avaliacao && $avaliacao->a_pratica_1 !== null && $avaliacao->a_pratica_1 < 10 ? 'text-danger' : '' }}">
                                        {{ $avaliacao && $avaliacao->a_pratica_1 !== null ? number_format($avaliacao->a_pratica_1, 1) : '-' }}
                                    </td>
                                    <td class="text-center {{ $avaliacao && $avaliacao->a_pratica_2 !== null && $avaliacao->a_pratica_2 < 10 ? 'text-danger' : '' }}">
                                        {{ $avaliacao && $avaliacao->a_pratica_2 !== null ? number_format($avaliacao->a_pratica_2, 1) : '-' }}
                                    </td>
                                    <td class="text-center font-weight-bold {{ $avaliacao && $avaliacao->map !== null && $avaliacao->map < 10 ? 'text-danger' : '' }}">
                                        {{ $avaliacao && $avaliacao->map !== null ? number_format($avaliacao->map, 1) : '-' }}
                                    </td>
                                    <td class="text-center {{ $avaliacao && $avaliacao->acs_1 !== null && $avaliacao->acs_1 < 10 ? 'text-danger' : '' }}">
                                        {{ $avaliacao && $avaliacao->acs_1 !== null ? number_format($avaliacao->acs_1, 1) : '-' }}
                                    </td>
                                    <td class="text-center {{ $avaliacao && $avaliacao->acs_2 !== null && $avaliacao->acs_2 < 10 ? 'text-danger' : '' }}">
                                        {{ $avaliacao && $avaliacao->acs_2 !== null ? number_format($avaliacao->acs_2, 1) : '-' }}
                                    </td>
                                    <td class="text-center font-weight-bold {{ $avaliacao && $avaliacao->macs !== null && $avaliacao->macs < 10 ? 'text-danger' : '' }}">
                                        {{ $avaliacao && $avaliacao->macs !== null ? number_format($avaliacao->macs, 1) : '-' }}
                                    </td>
                                    <td class="text-center {{ $avaliacao && $avaliacao->at !== null && $avaliacao->at < 10 ? 'text-danger' : '' }}">
                                        {{ $avaliacao && $avaliacao->at !== null ? number_format($avaliacao->at, 1) : '-' }}
                                    </td>
                                    <td class="text-center font-weight-bold {{ $avaliacao && $avaliacao->mt !== null && $avaliacao->mt < 10 ? 'text-danger' : '' }}">
                                        {{ $avaliacao && $avaliacao->mt !== null ? number_format($avaliacao->mt, 0) : '-' }}
                                    </td>
                                    <td class="text-center font-weight-bold {{ $mfrd !== null && !\App\Models\Avaliacao::isAprovado($mfrd) ? 'text-danger' : '' }}">
                                        {{ $mfrd !== null ? number_format($mfrd, 0) : '-' }}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    @endforeach

    <!-- Resultados Anuais/Finais -->
    @if($todosTrimestresCompletos && !$trimestreSelecionado)
        <div class="card border-0 shadow-sm mt-4">
            <div class="card-header bg-warning bg-opacity-10">
                <h5 class="mb-0">
                    <i class="bi bi-trophy text-warning me-2"></i>
                    Resultados Anuais (Finais)
                </h5>
                <small class="text-muted">Disponíveis após a realização de todos os testes/avaliações</small>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Disciplina</th>
                                <th class="text-center">Média Final (MFrD)</th>
                                <th class="text-center">Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($disciplinas as $disciplina)
                                @php
                                    // Buscar MFrD de qualquer avaliação da disciplina (é o mesmo em todas)
                                    $mfrd = null;
                                    foreach ($trimestres as $trimestre) {
                                        $avaliacao = $avaliacoesPorDisciplina[$disciplina->id][$trimestre->id] ?? null;
                                        if ($avaliacao && $avaliacao->mfrd !== null) {
                                            $mfrd = $avaliacao->mfrd;
                                            break;
                                        }
                                    }
                                    $aprovado = $mfrd !== null ? \App\Models\Avaliacao::isAprovado($mfrd) : false;
                                @endphp
                                <tr>
                                    <td><strong>{{ $disciplina->nome }}</strong></td>
                                    <td class="text-center">
                                        @if($mfrd !== null)
                                            <span class="badge bg-{{ $aprovado ? 'success' : 'danger' }} fs-5 px-3 py-2">
                                                {{ number_format($mfrd, 0) }}
                                            </span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td class="text-center">
                                        @if($mfrd !== null)
                                            <span class="badge bg-{{ $aprovado ? 'success' : 'danger' }} fs-6">
                                                {{ $aprovado ? 'APROVADO' : 'REPROVADO' }}
                                            </span>
                                        @else
                                            <span class="text-muted">Aguardando cálculo</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    @elseif(!$todosTrimestresCompletos && !$trimestreSelecionado)
        <div class="alert alert-info mt-4">
            <i class="bi bi-info-circle me-2"></i>
            <strong>Resultados Anuais:</strong> Os resultados anuais estarão disponíveis após a realização de todos os testes/avaliações de todos os trimestres.
        </div>
    @endif
    @else
    <div class="alert alert-info text-center">
        <i class="bi bi-inbox display-4 d-block mb-3"></i>
        Nenhuma nota registrada ainda.
    </div>
@endif
</div>
@endsection
