@extends('layouts.app')

@section('title', 'Factura - Estudante')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3 no-print">
            <h4 class="mb-0">
                <i class="bi bi-receipt text-primary me-2"></i>
                Factura {{ $invoice->numero_factura }}
            </h4>
            <div>
                <button type="button" class="btn btn-info btn-sm" onclick="window.print()">
                    <i class="bi bi-printer me-1"></i> Imprimir
                </button>
                @if($invoice->status === 'PAGA')
                    <a href="{{ route('aluno.invoice.download', $invoice) }}" class="btn btn-primary btn-sm">
                        <i class="bi bi-download me-1"></i> Descarregar PDF
                    </a>
                @endif
                <a href="{{ route('aluno.invoice.index') }}" class="btn btn-secondary btn-sm no-print">
                    <i class="bi bi-arrow-left"></i> Voltar
                </a>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="row mb-4">
            <div class="col-md-6">
                @if(isset($logotipoUrl) && $logotipoUrl)
                    <img src="{{ $logotipoUrl }}" alt="Logotipo" style="max-height: 80px; margin-bottom: 10px;">
                @endif
                <p class="mb-0">
                    <strong>{{ \App\Models\Configuracao::get('escola', 'ESCOLA PRIMARIA E COMPLETA SGE') }}</strong>
                </p>
            </div>
            <div class="col-md-6 text-end">
                <h5 class="mb-2">FACTURA</h5>
                <p class="mb-1"><strong>Nº:</strong> {{ $invoice->numero_factura }}</p>
                <p class="mb-1"><strong>Data:</strong> {{ $invoice->data_emissao->format('d/m/Y') }}</p>
                @if($invoice->status === 'PAGA')
                    <span class="badge bg-success">Paga</span>
                @else
                    <span class="badge bg-warning">Pendente</span>
                @endif
            </div>
        </div>

        <hr>

        <div class="mb-4">
            <p class="mb-1"><strong>Aluno:</strong> {{ $invoice->aluno->user->name }}</p>
            <p class="mb-0"><strong>Código:</strong> {{ $invoice->aluno->codigo_estudante }}</p>
        </div>

        <hr>

        <div class="table-responsive">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Descrição</th>
                        <th class="text-end">Valor</th>
                    </tr>
                </thead>
                <tbody>
                    @if($invoice->itens)
                        @foreach($invoice->itens as $item)
                            <tr>
                                <td>{{ $item['descricao'] ?? 'Mensalidade' }}</td>
                                <td class="text-end">{{ number_format($item['valor'] ?? $invoice->valor, 2, ',', '.') }} MT</td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td>{{ $invoice->descricao ?? 'Mensalidade' }}</td>
                            <td class="text-end">{{ number_format($invoice->valor, 2, ',', '.') }} MT</td>
                        </tr>
                    @endif
                </tbody>
                <tfoot>
                    <tr>
                        <th class="text-end">Total</th>
                        <th class="text-end">{{ number_format($invoice->valor, 2, ',', '.') }} MT</th>
                    </tr>
                </tfoot>
            </table>
        </div>

        @if($invoice->payment)
            <div class="mt-4">
                <h5>Informações de Pagamento</h5>
                <p class="mb-0">
                    <strong>Método:</strong> {{ $invoice->payment->metodo === 'MPESA' ? 'M-Pesa' : 'Emola' }}<br>
                    <strong>Referência:</strong> {{ $invoice->payment->reference }}<br>
                    @if($invoice->payment->data_pagamento)
                        <strong>Data Pagamento:</strong> {{ $invoice->payment->data_pagamento->format('d/m/Y H:i') }}
                    @endif
                </p>
            </div>
        @endif

        <div class="mt-4 pt-3 border-top text-center" style="margin-top: auto;">
            <p class="text-muted mb-1" style="font-size: 0.85rem;">Documento gerado automaticamente pelo Sistema de Gestão Escolar</p>
            @if($invoice->codigo_verificacao)
                <p class="mb-0" style="font-size: 0.9rem;">
                    <strong>Código de Verificação:</strong> 
                    <span class="badge bg-secondary">{{ $invoice->codigo_verificacao }}</span>
                </p>
            @endif
        </div>
    </div>
</div>

<style>
    @media print {
        .no-print {
            display: none !important;
        }
        
        body {
            margin: 0;
            padding: 20px;
            font-size: 12px;
        }
        
        .card {
            border: none;
            box-shadow: none;
        }
        
        .card-body {
            padding: 0;
        }
        
        .table {
            border-collapse: collapse;
        }
        
        .table th,
        .table td {
            border: 1px solid #ddd;
            padding: 8px;
        }
        
        .table thead th {
            background-color: #f8f9fa;
            font-weight: bold;
        }
        
        .badge {
            border: 1px solid #000;
            padding: 4px 8px;
        }
        
        .text-end {
            text-align: right;
        }
        
        hr {
            border-top: 1px solid #000;
            margin: 15px 0;
        }
        
        @page {
            margin: 1cm;
        }
    }
    
    @media screen {
        .no-print {
            display: block;
        }
    }
</style>
@endsection

