<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Factura {{ $invoice->numero_factura }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 20px;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 30px;
            padding-bottom: 15px;
            border-bottom: 2px solid #333;
        }
        .logo-section {
            flex: 1;
        }
        .logo-section img {
            max-height: 80px;
            max-width: 200px;
        }
        .invoice-info {
            text-align: right;
            flex: 1;
        }
        .invoice-info h2 {
            margin: 0 0 10px 0;
            font-size: 24px;
            font-weight: bold;
        }
        .info-section {
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: left;
        }
        th {
            background-color: #f8f9fa;
            font-weight: bold;
        }
        .text-end {
            text-align: right;
        }
        .total {
            font-weight: bold;
            font-size: 14px;
            background-color: #f8f9fa;
        }
        .aluno-info {
            margin-bottom: 25px;
        }
        .aluno-info p {
            margin: 5px 0;
        }
        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 9px;
            color: #666;
            border-top: 1px solid #ddd;
            padding: 10px 20px;
            background-color: #fff;
        }
        @page {
            margin-bottom: 60px;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="logo-section">
            @if(isset($logotipoBase64) && $logotipoBase64)
                <img src="{{ $logotipoBase64 }}" alt="Logotipo" style="max-height: 80px;">
            @endif
            <p style="margin-top: 10px; font-weight: bold;">{{ \App\Models\Configuracao::get('escola', 'ESCOLA PRIMARIA E COMPLETA SGE') }}</p>
        </div>
        <div class="invoice-info">
            <h2>FACTURA</h2>
            <p><strong>Nº:</strong> {{ $invoice->numero_factura }}</p>
            <p><strong>Data:</strong> {{ $invoice->data_emissao->format('d/m/Y') }}</p>
        </div>
    </div>

    <div class="aluno-info">
        <p><strong>Aluno:</strong> {{ $invoice->aluno->user->name }}</p>
        <p><strong>Código:</strong> {{ $invoice->aluno->codigo_estudante }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Descrição</th>
                <th class="text-end">Valor</th>
            </tr>
        </thead>
        <tbody>
            @if($invoice->itens)
                @foreach($invoice->itens as $item)
                    <tr>
                        <td>{{ $item['descricao'] ?? 'Mensalidade' }}</td>
                        <td class="text-end">{{ number_format($item['valor'] ?? $invoice->valor, 2, ',', '.') }} MT</td>
                    </tr>
                @endforeach
            @else
                <tr>
                    <td>{{ $invoice->descricao ?? 'Mensalidade' }}</td>
                    <td class="text-end">{{ number_format($invoice->valor, 2, ',', '.') }} MT</td>
                </tr>
            @endif
        </tbody>
        <tfoot>
            <tr class="total">
                <td class="text-end">Total</td>
                <td class="text-end">{{ number_format($invoice->valor, 2, ',', '.') }} MT</td>
            </tr>
        </tfoot>
    </table>

    @if($invoice->payment)
        <div class="info-section">
            <h4>Informações de Pagamento</h4>
            <p><strong>Método:</strong> {{ $invoice->payment->metodo === 'MPESA' ? 'M-Pesa' : 'Emola' }}</p>
            <p><strong>Referência:</strong> {{ $invoice->payment->reference }}</p>
            @if($invoice->payment->data_pagamento)
                <p><strong>Data Pagamento:</strong> {{ $invoice->payment->data_pagamento->format('d/m/Y H:i') }}</p>
            @endif
        </div>
    @endif

    <div class="footer">
        <p style="margin: 0;">Documento gerado automaticamente pelo Sistema de Gestão Escolar</p>
        @if($invoice->codigo_verificacao)
            <p style="margin: 5px 0 0 0; font-weight: bold; color: #333;">Código de Verificação: <strong>{{ $invoice->codigo_verificacao }}</strong></p>
        @endif
    </div>
</body>
</html>

