@extends('layouts.app')

@section('title', 'Facturas - Estudante')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">
                <i class="bi bi-receipt text-primary me-2"></i>
                Minhas Facturas
            </h4>
            <a href="{{ route('aluno.financeiro') }}" class="btn btn-secondary btn-sm">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>
    </div>
</div>

@if($invoices->count() > 0)
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>Número</th>
                    <th>Data Emissão</th>
                    <th>Valor</th>
                    <th>Status</th>
                    <th>Acções</th>
                </tr>
            </thead>
            <tbody>
                @foreach($invoices as $invoice)
                    <tr>
                        <td>{{ $invoice->numero_factura }}</td>
                        <td>{{ $invoice->data_emissao->format('d/m/Y') }}</td>
                        <td>{{ number_format($invoice->valor, 2, ',', '.') }} MT</td>
                        <td>
                            @if($invoice->status === 'PAGA')
                                <span class="badge bg-success">Paga</span>
                            @else
                                <span class="badge bg-warning">Pendente</span>
                            @endif
                        </td>
                        <td>
                            <a href="{{ route('aluno.invoice.show', $invoice) }}" class="btn btn-sm btn-primary">
                                <i class="bi bi-eye"></i> Ver
                            </a>
                            @if($invoice->status === 'PAGA')
                                <a href="{{ route('aluno.invoice.download', $invoice) }}" class="btn btn-sm btn-outline-primary">
                                    <i class="bi bi-download"></i> PDF
                                </a>
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@else
    <div class="alert alert-info text-center">
        <i class="bi bi-inbox display-4 d-block mb-3"></i>
        Nenhuma factura encontrada.
    </div>
@endif
@endsection

