<div class="card shadow-sm border-0">
    <div class="card-body p-4">
        <div class="row mb-4">
            <div class="col-md-6">
                @if(isset($logotipoUrl) && $logotipoUrl)
                    <img src="{{ $logotipoUrl }}" alt="Logotipo" style="max-height: 80px; margin-bottom: 10px;">
                @endif
                <p class="mb-0">
                    <strong>{{ \App\Models\Configuracao::get('escola', 'ESCOLA PRIMARIA E COMPLETA SGE') }}</strong>
                </p>
            </div>
            <div class="col-md-6 text-end">
                <h5 class="mb-2">FACTURA</h5>
                <p class="mb-1"><strong>Nº:</strong> {{ $invoice->numero_factura }}</p>
                <p class="mb-1"><strong>Data:</strong> {{ $invoice->data_emissao->format('d/m/Y') }}</p>
                @if($invoice->status === 'PAGA')
                    <span class="badge bg-success">Paga</span>
                @else
                    <span class="badge bg-warning">Pendente</span>
                @endif
            </div>
        </div>

        <hr>

        <div class="mb-4">
            <p class="mb-1"><strong>Aluno:</strong> {{ $invoice->aluno->user->name }}</p>
            <p class="mb-0"><strong>Código:</strong> {{ $invoice->aluno->codigo_estudante }}</p>
        </div>

        <hr>

        <div class="table-responsive">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Descrição</th>
                        <th class="text-end">Valor</th>
                    </tr>
                </thead>
                <tbody>
                    @if($invoice->itens)
                        @foreach($invoice->itens as $item)
                            <tr>
                                <td>{{ $item['descricao'] ?? 'Mensalidade' }}</td>
                                <td class="text-end">{{ number_format($item['valor'] ?? $invoice->valor, 2, ',', '.') }} MT</td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td>{{ $invoice->descricao ?? 'Mensalidade' }}</td>
                            <td class="text-end">{{ number_format($invoice->valor, 2, ',', '.') }} MT</td>
                        </tr>
                    @endif
                </tbody>
                <tfoot>
                    <tr>
                        <th class="text-end">Total</th>
                        <th class="text-end">{{ number_format($invoice->valor, 2, ',', '.') }} MT</th>
                    </tr>
                </tfoot>
            </table>
        </div>

        @if($invoice->payment)
            <div class="mt-4">
                <h5>Informações de Pagamento</h5>
                <p class="mb-0">
                    <strong>Método:</strong> {{ $invoice->payment->metodo === 'MPESA' ? 'M-Pesa' : 'Emola' }}<br>
                    <strong>Referência:</strong> {{ $invoice->payment->reference }}<br>
                    @if($invoice->payment->data_pagamento)
                        <strong>Data Pagamento:</strong> {{ $invoice->payment->data_pagamento->format('d/m/Y H:i') }}
                    @endif
                </p>
            </div>
        @endif

        <div class="mt-4 pt-3 border-top text-center">
            <p class="text-muted mb-1" style="font-size: 0.85rem;">Documento gerado automaticamente pelo Sistema de Gestão Escolar</p>
            @if($invoice->codigo_verificacao)
                <p class="mb-0" style="font-size: 0.9rem;">
                    <strong>Código de Verificação:</strong> 
                    <span class="badge bg-secondary">{{ $invoice->codigo_verificacao }}</span>
                </p>
            @endif
        </div>
    </div>
</div>
