@extends('layouts.app')

@section('title', 'Meus Horários - Estudante')

@section('content')
<style>
    .horario-cell {
        padding: 6px 4px;
        text-align: center;
        font-size: 0.75rem;
        vertical-align: middle;
        min-height: 60px;
        border: 1px solid #dee2e6;
        position: relative;
    }
    .horario-cell.empty {
        background-color: #ffffff;
    }
    .horario-header {
        background-color: #e9ecef;
        font-weight: 600;
        text-align: center;
        padding: 10px 6px;
        font-size: 0.85rem;
        border: 1px solid #dee2e6;
    }
    .horario-time {
        background-color: #f8f9fa;
        font-weight: 600;
        text-align: center;
        padding: 10px 6px;
        font-size: 0.85rem;
        width: 90px;
        border: 1px solid #dee2e6;
    }
    .disciplina-badge {
        display: block;
        padding: 3px 5px;
        border-radius: 3px;
        font-weight: 600;
        margin-bottom: 3px;
        font-size: 0.75rem;
    }
    .professor-name {
        font-size: 0.7rem;
        color: #495057;
        font-weight: 500;
        display: block;
        margin-top: 2px;
    }
    .horario-table {
        border-collapse: collapse;
        width: 100%;
    }
    .horario-table td, .horario-table th {
        border: 1px solid #dee2e6;
    }
    
    /* Wrapper específico para mobile */
    .horarios-mobile-wrapper {
        width: 100%;
        overflow-x: visible;
    }
    
    /* Mobile - Scroll horizontal SIMPLES e FUNCIONAL */
    @media (max-width: 768px) {
        /* Wrapper - garantir que nada bloqueie */
        .horarios-mobile-wrapper {
            overflow-x: auto !important;
            overflow-y: visible !important;
            width: 100% !important;
            touch-action: pan-x pan-y !important;
            -webkit-overflow-scrolling: touch !important;
        }
        
        /* SOBRESCREVER overflow-x: hidden do body global */
        body.auth-layout {
            overflow-x: auto !important;
        }
        
        /* Permitir scroll no conteúdo principal */
        #mainContent {
            overflow-x: auto !important;
            overflow-y: auto !important;
        }
        
        /* Container principal */
        .horarios-mobile-wrapper .row {
            overflow-x: visible !important;
            width: 100% !important;
        }
        
        .horarios-mobile-wrapper .col-12 {
            overflow-x: visible !important;
            width: 100% !important;
        }
        
        /* Wrapper de scroll customizado - SUBSTITUI table-responsive */
        .horario-scroll-wrapper {
            width: 100% !important;
            overflow-x: auto !important;
            overflow-y: visible !important;
            -webkit-overflow-scrolling: touch !important;
            touch-action: pan-x pan-y !important;
            display: block !important;
            position: relative !important;
            -ms-overflow-style: -ms-autohiding-scrollbar !important;
            scroll-behavior: smooth !important;
            /* Garantir que nada bloqueie */
            pointer-events: auto !important;
        }
        
        /* Tabela dentro do wrapper */
        .horario-scroll-wrapper .horario-table {
            min-width: 900px !important;
            width: auto !important;
            display: table !important;
            margin: 0 !important;
        }
        
        /* Scrollbar customizada */
        .horario-scroll-wrapper::-webkit-scrollbar {
            height: 20px !important;
            display: block !important;
        }
        
        .horario-scroll-wrapper::-webkit-scrollbar-track {
            background: #e8e8e8 !important;
            border-radius: 10px !important;
        }
        
        .horario-scroll-wrapper::-webkit-scrollbar-thumb {
            background: #666 !important;
            border-radius: 10px !important;
            border: 4px solid #e8e8e8 !important;
        }
        
        .horario-scroll-wrapper::-webkit-scrollbar-thumb:active {
            background: #444 !important;
        }
        
        /* Células da tabela */
        .horarios-mobile-wrapper .horario-cell, 
        .horarios-mobile-wrapper .horario-header, 
        .horarios-mobile-wrapper .horario-time {
            min-width: 110px !important;
        }
        
        /* BOTÕES E LINKS - GARANTIR FUNCIONAMENTO TOTAL */
        .horarios-mobile-wrapper button, 
        .horarios-mobile-wrapper .btn, 
        .horarios-mobile-wrapper a.btn, 
        .horarios-mobile-wrapper input[type="button"], 
        .horarios-mobile-wrapper input[type="submit"],
        .horarios-mobile-wrapper a[href], 
        .horarios-mobile-wrapper a[onclick],
        .horarios-mobile-wrapper a {
            min-height: 50px !important;
            min-width: 50px !important;
            touch-action: manipulation !important;
            -webkit-tap-highlight-color: rgba(0,0,0,0.4) !important;
            cursor: pointer !important;
            pointer-events: auto !important;
            position: relative !important;
            z-index: 999 !important;
            /* Garantir que seja clicável */
            display: inline-block !important;
        }
        
    }
</style>

<div class="horarios-mobile-wrapper" style="width: 100% !important; overflow-x: visible !important;">
<div class="row" style="width: 100% !important; overflow-x: visible !important; margin: 0 !important;">
    <div class="col-12" style="width: 100% !important; overflow-x: visible !important; padding: 0 15px !important;">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">
                <i class="bi bi-calendar-week text-info me-2"></i>
                Meus Horários
            </h5>
            <div>
                <span class="badge bg-primary">{{ $anoLetivoAtivo->ano ?? 'N/A' }}</span>
            </div>
        </div>

        @if(isset($grades) && count($grades) > 0)
            @foreach($grades as $turmaId => $data)
                @php
                    $turma = $data['turma'];
                    $grade = $data['grade'];
                    $horarios = $data['horarios'];
                    $diasAbreviados = ['Segunda' => 'Seg', 'Terça' => 'Ter', 'Quarta' => 'Qua', 'Quinta' => 'Qui', 'Sexta' => 'Sex'];
                    
                    // Cores para disciplinas (gerar baseado no nome)
                    $coresDisciplinas = [];
                    $disciplinasUnicas = [];
                    foreach ($grade as $hora => $dias) {
                        foreach ($dias as $dia => $horario) {
                            if ($horario && $horario->disciplina) {
                                $disciplinasUnicas[$horario->disciplina->id] = $horario->disciplina->nome;
                            }
                        }
                    }
                    $paletaCores = [
                        '#d4edda', '#fff3cd', '#d1ecf1', '#f8d7da', 
                        '#e2e3e5', '#d4edda', '#cce5ff', '#ffe6cc',
                        '#e6f3ff', '#ffe6f0', '#f0e6ff', '#fff0e6'
                    ];
                    $corIndex = 0;
                    foreach ($disciplinasUnicas as $id => $nome) {
                        $coresDisciplinas[$id] = $paletaCores[$corIndex % count($paletaCores)];
                        $corIndex++;
                    }
                @endphp
                
                <div style="background: #fff; padding: 15px; border-radius: 4px; margin-bottom: 20px; box-shadow: 0 1px 3px rgba(0,0,0,0.1);">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h6 style="font-weight: 600; margin-bottom: 0; font-size: 0.95rem; color: #495057;">
                            <i class="bi bi-building text-primary me-2"></i>
                            Sala: {{ $turma->codigo ?? '' }} - {{ $turma->nome ?? 'Turma #' . $turmaId }}
                        </h6>
                    </div>
                    
                    <div class="horario-scroll-wrapper" style="width: 100%; overflow-x: auto; overflow-y: visible; -webkit-overflow-scrolling: touch; touch-action: pan-x pan-y; display: block; position: relative;">
                        <table class="horario-table" style="min-width: 900px; width: auto; display: table; margin: 0;">
                            <thead>
                                <tr>
                                    <th class="horario-time">Horário</th>
                                    @foreach($diasSemana as $dia)
                                        <th class="horario-header">{{ $diasAbreviados[$dia] }}</th>
                                    @endforeach
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($horarios as $horarioInfo)
                                    @php
                                        $horaInicio = $horarioInfo['inicio'];
                                        $isIntervalo = isset($horarioInfo['tipo']) && $horarioInfo['tipo'] === 'intervalo';
                                    @endphp
                                    <tr>
                                        <td class="horario-time" style="{{ $isIntervalo ? 'background-color: #fff3cd; color: #856404;' : '' }}">
                                            {{ $horarioInfo['display'] }}
                                        </td>
                                        @if($isIntervalo)
                                            <td colspan="{{ count($diasSemana) }}" class="horario-cell" style="background-color: #fff3cd; text-align: center; font-weight: 600; color: #856404;">
                                                Intervalo para Lanche
                                            </td>
                                        @else
                                            @foreach($diasSemana as $dia)
                                                @php
                                                    $horario = $grade[$horaInicio][$dia] ?? null;
                                                    $corFundo = $horario && $horario->disciplina ? ($coresDisciplinas[$horario->disciplina->id] ?? '#ffffff') : '#ffffff';
                                                @endphp
                                                <td class="horario-cell {{ !$horario ? 'empty' : '' }}" 
                                                    style="background-color: {{ $corFundo }};">
                                                    @if($horario)
                                                        <span class="disciplina-badge" style="background-color: rgba(255,255,255,0.85); color: #212529;">
                                                            {{ $horario->disciplina->nome }}
                                                        </span>
                                                        <span class="professor-name">
                                                            {{ $horario->professor->user->name }}
                                                        </span>
                                                    @else
                                                        <span style="color: #adb5bd; font-size: 0.9rem;">-</span>
                                                    @endif
                                                </td>
                                            @endforeach
                                        @endif
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            @endforeach
        @else
            <div style="background: #f8f9fa; padding: 20px; border-radius: 4px; text-align: center; font-size: 0.85rem;">
                Nenhum horário registrado
            </div>
        @endif
    </div>
</div>
</div>

<script>
// Script para garantir scroll e toque funcionem - VERSÃO AGRESSIVA
(function() {
    function forceMobileScroll() {
        if (window.innerWidth <= 768) {
            // Remover qualquer bloqueio de pointer-events
            var allElements = document.querySelectorAll('*');
            allElements.forEach(function(el) {
                // Pular elementos que devem ter pointer-events: none
                if (el.classList.contains('sidebar-overlay') || el.id === 'sidebarOverlay') {
                    return;
                }
                // Garantir que elementos na área de horários tenham pointer-events: auto
                if (el.closest('.horarios-mobile-wrapper')) {
                    var computed = window.getComputedStyle(el);
                    if (computed.pointerEvents === 'none' && !el.classList.contains('sidebar-overlay')) {
                        el.style.pointerEvents = 'auto';
                    }
                }
            });
            
            // Forçar estilos no wrapper customizado
            var wrappers = document.querySelectorAll('.horario-scroll-wrapper');
            wrappers.forEach(function(wrapper) {
                wrapper.style.cssText += 'overflow-x: auto !important; -webkit-overflow-scrolling: touch !important; touch-action: pan-x pan-y !important; width: 100% !important; display: block !important; pointer-events: auto !important; position: relative !important;';
                
                // Garantir que a tabela tenha largura mínima
                var table = wrapper.querySelector('.horario-table');
                if (table) {
                    table.style.cssText += 'min-width: 900px !important; width: auto !important; display: table !important;';
                }
            });
            
            // Garantir que TODOS os elementos interativos funcionem
            var interactive = document.querySelectorAll('.horarios-mobile-wrapper button, .horarios-mobile-wrapper .btn, .horarios-mobile-wrapper a, .horarios-mobile-wrapper [onclick], .horarios-mobile-wrapper input, .horarios-mobile-wrapper select');
            interactive.forEach(function(el) {
                el.style.cssText += 'pointer-events: auto !important; touch-action: manipulation !important; min-height: 48px !important; min-width: 48px !important; cursor: pointer !important;';
            });
            
            // Garantir que o mainContent não bloqueie
            var mainContent = document.getElementById('mainContent');
            if (mainContent) {
                mainContent.style.cssText += 'overflow-x: auto !important; touch-action: pan-x pan-y !important;';
            }
            
            // Garantir que container-fluid não bloqueie
            var container = document.querySelector('.container-fluid');
            if (container && container.closest('#mainContent')) {
                container.style.cssText += 'overflow-x: visible !important; width: 100% !important;';
            }
        }
    }
    
    // Executar imediatamente
    forceMobileScroll();
    
    // Executar quando DOM carregar
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', forceMobileScroll);
    }
    
    // Re-executar após um delay
    setTimeout(forceMobileScroll, 500);
    setTimeout(forceMobileScroll, 1000);
    
    // Re-executar em resize
    window.addEventListener('resize', function() {
        setTimeout(forceMobileScroll, 100);
    });
    
    // Re-executar quando a página ganhar foco (útil para mobile)
    window.addEventListener('focus', forceMobileScroll);
})();
</script>

@endsection
