@extends('layouts.app')

@section('title', 'Eventos - Estudante')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">
                <i class="bi bi-calendar-event text-warning me-2"></i>
                Eventos
            </h4>
            <div>
                <span class="badge bg-primary">{{ $anoLetivoAtivo->ano ?? 'N/A' }}</span>
            </div>
        </div>
    </div>
</div>

@if($eventos->count() > 0)
    <div class="row">
        @foreach($eventos as $evento)
            <div class="col-md-6 mb-3">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">{{ $evento->titulo }}</h5>
                    </div>
                    <div class="card-body">
                        <p class="mb-2">{{ $evento->descricao ?? 'Sem descrição' }}</p>
                        <div class="d-flex flex-column gap-2">
                            <div>
                                <i class="bi bi-calendar me-2"></i>
                                <strong>Data:</strong> {{ $evento->data->format('d/m/Y') }}
                            </div>
                            @if($evento->hora_inicio)
                                <div>
                                    <i class="bi bi-clock me-2"></i>
                                    <strong>Hora:</strong> {{ $evento->hora_inicio }}
                                    @if($evento->hora_fim)
                                        - {{ $evento->hora_fim }}
                                    @endif
                                </div>
                            @endif
                            @if($evento->turma)
                                <div>
                                    <i class="bi bi-building me-2"></i>
                                    <strong>Turma:</strong> {{ $evento->turma->codigo }} - {{ $evento->turma->nome }}
                                </div>
                            @endif
                            @if($evento->disciplina)
                                <div>
                                    <i class="bi bi-book me-2"></i>
                                    <strong>Disciplina:</strong> {{ $evento->disciplina->nome }}
                                </div>
                            @endif
                            <div>
                                @if($evento->cancelado)
                                    <span class="badge bg-danger">CANCELADO</span>
                                @else
                                    <span class="badge bg-success">CONFIRMADO</span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
@else
    <div class="alert alert-info text-center">
        <i class="bi bi-inbox display-4 d-block mb-3"></i>
        Nenhum evento registrado.
    </div>
@endif
@endsection

