@extends('layouts.app')

@section('title', 'Turmas - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Turmas</h5>
            <a href="{{ route('admin.turmas.create') }}" class="btn btn-sm btn-primary">Nova Turma</a>
        </div>

        <form method="GET" action="{{ route('admin.turmas.index') }}" class="mb-2" style="display: flex; gap: 8px; align-items: end;">
            <input type="text" class="form-control form-control-sm" name="search" id="search"
                   placeholder="Pesquisar..." value="{{ request('search') }}" style="flex: 1;">
            <select class="form-select form-select-sm" name="ano_letivo_id" id="ano_letivo_id" style="width: 150px;">
                <option value="">2026 (Padrão)</option>
                @foreach($anoLetivos as $ano)
                    <option value="{{ $ano->id }}" {{ request('ano_letivo_id') == $ano->id ? 'selected' : '' }}>{{ $ano->ano_inicial }}</option>
                @endforeach
            </select>
            <select class="form-select form-select-sm" name="nivel_ensino" id="nivel_ensino" style="width: 150px;">
                <option value="">Todos os Níveis</option>
                <option value="PRIMARIO" {{ request('nivel_ensino') == 'PRIMARIO' ? 'selected' : '' }}>Primário</option>
                <option value="SECUNDARIO" {{ request('nivel_ensino') == 'SECUNDARIO' ? 'selected' : '' }}>Secundário</option>
            </select>
            <button type="submit" class="btn btn-sm btn-primary">Filtrar</button>
            @if(request('search') || request('ano_letivo_id') || request('nivel_ensino'))
                <a href="{{ route('admin.turmas.index') }}" class="btn btn-sm btn-secondary">Limpar</a>
            @endif
        </form>

        <div class="js-ajax-pagination">
            <div class="table-responsive">
                <table class="table table-sm table-bordered" style="font-size: 0.85rem; margin-bottom: 0;">
                <thead style="background-color: #f8f9fa;">
                    <tr>
                        <th style="padding: 6px;">Classe</th>
                        <th style="padding: 6px;">Turma</th>
                        <th style="padding: 6px;">Nível</th>
                        <th style="padding: 6px;">Ano Letivo</th>
                        <th style="padding: 6px;">Capacidade</th>
                        <th style="padding: 6px;">Status</th>
                        <th style="padding: 6px;">Acções</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($turmas as $turma)
                        @php
                            try {
                                $anoLetivoAtivo = \App\Models\AnoLetivo::getAnoLetivoAtual();
                                $totalAlunos = $turma->alunos()->wherePivot('ano_letivo_id', $anoLetivoAtivo?->id)->count();
                            } catch (\Exception $e) {
                                $totalAlunos = 0;
                            }
                        @endphp
                        <tr>
                            <td style="padding: 5px;">{{ $turma->codigo }}</td>
                            <td style="padding: 5px;">
                                <a href="{{ route('admin.turmas.show', $turma) }}" style="text-decoration: none; color: inherit;">Turma {{ $turma->nome }}</a>
                            </td>
                            <td style="padding: 5px;">
                                {{ ($turma->nivel_ensino ?? 'PRIMARIO') === 'SECUNDARIO' ? 'Secundário' : 'Primário' }}
                            </td>
                            <td style="padding: 5px;">
                                @php
                                    try {
                                        $anoRaw = $turma->anoLetivo ? $turma->anoLetivo->getRawOriginal('ano') : null;
                                        $anoExibir = $anoRaw ? (strpos($anoRaw, '/') !== false ? explode('/', $anoRaw)[0] : $anoRaw) : '-';
                                    } catch (\Exception $e) {
                                        $anoExibir = '-';
                                    }
                                @endphp
                                {{ $anoExibir }}
                            </td>
                            <td style="padding: 5px;">
                                <span style="font-size: 0.75rem; padding: 2px 6px; background: #e7f3ff; color: #0066cc; border-radius: 3px;">{{ $totalAlunos }}/{{ $turma->capacidade_maxima ?: 35 }}</span>
                            </td>
                            <td style="padding: 5px;">
                                @if($turma->ativa)
                                    <span style="font-size: 0.75rem; padding: 2px 6px; background: #d4edda; color: #155724; border-radius: 3px;">Activa</span>
                                @else
                                    <span style="font-size: 0.75rem; padding: 2px 6px; background: #e2e3e5; color: #383d41; border-radius: 3px;">Inactiva</span>
                                @endif
                            </td>
                            <td style="padding: 5px;">
                                <div style="display: flex; gap: 4px; flex-wrap: wrap;">
                                    <a href="{{ route('admin.turmas.show', $turma) }}" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #e7f3ff; color: #0066cc; border: none;" title="Ver detalhes">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <a href="{{ route('admin.turmas.edit', $turma) }}" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #fff3cd; color: #856404; border: none;" title="Editar">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <a href="{{ route('admin.turmas.alocar-alunos', $turma) }}" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #d4edda; color: #155724; border: none;" title="Alocar Alunos">
                                        <i class="bi bi-people"></i>
                                    </a>
                                    <a href="{{ route('admin.turmas.atribuir-disciplinas', $turma) }}" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #d1ecf1; color: #0c5460; border: none;" title="Disciplinas e Professores">
                                        <i class="bi bi-book"></i>
                                    </a>
                                    <form action="{{ route('admin.turmas.destroy', $turma) }}" method="POST" class="d-inline delete-form"
                                          data-id="{{ $turma->id }}"
                                          data-confirm="Tem certeza que deseja eliminar esta turma?">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #f8d7da; color: #721c24; border: none;" title="Eliminar">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center text-muted">
                                <i class="bi bi-inbox"></i> Nenhuma turma encontrada
                            </td>
                        </tr>
                    @endforelse
                </tbody>
                </table>
            </div>
            
            @if(method_exists($turmas, 'links'))
                <div class="mt-3">
                    {{ $turmas->appends(request()->query())->links() }}
                </div>
            @endif
        </div>

    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Variável para controlar se já está processando uma requisição
    let processando = false;
    
    // Interceptar formulários de delete
    document.querySelectorAll('.delete-form').forEach(function(form) {
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            
            // Evitar múltiplas requisições simultâneas
            if (processando) {
                return false;
            }
            
            const confirmMsg = this.getAttribute('data-confirm');
            if (!confirm(confirmMsg)) {
                return false;
            }
            
            processando = true;
            
            const formData = new FormData(this);
            const row = this.closest('tr');
            const url = this.action;
            
            // Mostrar loading
            const submitBtn = this.querySelector('button[type="submit"]');
            const originalHTML = submitBtn.innerHTML;
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="bi bi-hourglass-split"></i>';
            
            fetch(url, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': formData.get('_token'),
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                },
                body: formData
            })
            .then(response => {
                if (!response.ok) {
                    return response.json().then(data => {
                        throw new Error(data.message || 'Erro ao processar requisição');
                    }).catch(err => {
                        // Se não conseguir parsear JSON, usar mensagem padrão
                        if (err.message === 'Erro ao processar requisição' && response.status === 404) {
                            throw new Error('O registo solicitado não foi encontrado ou foi eliminado.');
                        }
                        throw err;
                    });
                }
                return response.json();
            })
            .then(data => {
                processando = false;
                
                if (data.success) {
                    // Remover linha da tabela com animação
                    row.style.transition = 'opacity 0.3s';
                    row.style.opacity = '0';
                    setTimeout(function() {
                        row.remove();
                        // Verificar se a tabela ficou vazia
                        const tbody = document.querySelector('tbody');
                        if (tbody && tbody.children.length === 0) {
                            tbody.innerHTML = '<tr><td colspan="7" class="text-center text-muted"><i class="bi bi-inbox"></i> Nenhuma turma encontrada</td></tr>';
                        }
                    }, 300);
                } else {
                    alert('Erro: ' + (data.message || 'Erro desconhecido'));
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = originalHTML;
                }
            })
            .catch(error => {
                processando = false;
                console.error('Erro:', error);
                
                // Evitar múltiplos alerts
                if (!window.alertMostrado) {
                    window.alertMostrado = true;
                    alert('Erro: ' + (error.message || 'Erro ao eliminar turma. Por favor, tente novamente.'));
                    setTimeout(function() {
                        window.alertMostrado = false;
                    }, 1000);
                }
                
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalHTML;
            });
        });
    });
});
</script>
@endsection
