@extends('layouts.app')

@section('title', 'Atribuir Disciplinas - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <div>
                <h5 class="mb-0" style="font-weight: 600;">Atribuir Disciplinas e Professores</h5>
                <small class="text-muted">{{ $turma->codigo }} - Turma {{ $turma->nome }}@if($anoLetivo) | {{ $anoLetivo->ano_inicial ?? $anoLetivo->ano }}@endif</small>
            </div>
            <a href="{{ route('admin.turmas.show', $turma) }}" class="btn btn-sm btn-secondary">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>

        <div class="row">
            <!-- Disciplinas Atribuídas -->
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header" style="background-color: #f8f9fa; padding: 8px;">
                        <small class="text-muted" style="font-weight: 600;">
                            <i class="bi bi-check-circle text-success"></i> Disciplinas Atribuídas ({{ count($disciplinasComProfessores) }})
                        </small>
                    </div>
                    <div class="card-body" style="padding: 10px;">
                        @if(count($disciplinasComProfessores) > 0)
                            <div class="table-responsive" style="max-height: 500px; overflow-y: auto;">
                                <table class="table table-sm table-bordered mb-0" style="font-size: 0.85rem;">
                                    <thead style="background-color: #f8f9fa; position: sticky; top: 0;">
                                        <tr>
                                            <th style="padding: 6px;">Disciplina</th>
                                            <th style="padding: 6px;">Professor</th>
                                            <th style="padding: 6px;">Carga</th>
                                            <th style="padding: 6px; width: 50px;">Acções</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($disciplinasComProfessores as $item)
                                            @php
                                                $disciplina = $item['disciplina'];
                                                $professor = $item['professor'];
                                                $cargaMin = $disciplina->pivot->carga_horaria_semanal ?? $disciplina->carga_horaria_semanal ?? null;
                                                $horas = $cargaMin !== null ? floor($cargaMin / 60) : null;
                                                $minutos = $cargaMin !== null ? ($cargaMin % 60) : null;
                                                $cargaLabel = $cargaMin === null ? '-' : ($horas > 0 ? "{$horas}h" : '') . ($minutos > 0 ? " {$minutos}min" : ($horas === 0 ? "{$minutos}min" : ''));
                                            @endphp
                                            <tr>
                                                <td style="padding: 5px;">
                                                    <strong>{{ $disciplina->nome }}</strong>
                                                </td>
                                                <td style="padding: 5px;">
                                                    @if($professor)
                                                        <span class="badge bg-info">{{ $professor->professor_nome }}</span>
                                                    @else
                                                        <span class="text-muted" style="font-size: 0.75rem;">Sem professor</span>
                                                    @endif
                                                </td>
                                                <td style="padding: 5px;">
                                                    <small class="text-muted">{{ trim($cargaLabel) }}</small>
                                                </td>
                                                <td style="padding: 5px;">
                                                    <form action="{{ route('admin.turmas.remover-disciplina', ['turma' => $turma, 'disciplina' => $disciplina]) }}" 
                                                          method="POST" 
                                                          class="d-inline"
                                                          onsubmit="return confirm('Tem certeza que deseja remover esta disciplina da turma?');">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #f8d7da; color: #721c24; border: none;" title="Remover">
                                                            <i class="bi bi-trash"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <p class="text-muted text-center mb-0" style="font-size: 0.85rem; padding: 20px;">
                                <i class="bi bi-inbox"></i> Nenhuma disciplina atribuída
                            </p>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Disciplinas Disponíveis -->
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header" style="background-color: #f8f9fa; padding: 8px;">
                        <small class="text-muted" style="font-weight: 600;">
                            <i class="bi bi-plus-circle text-primary"></i> Disciplinas Disponíveis ({{ $disciplinasDisponiveis->count() }})
                        </small>
                    </div>
                    <div class="card-body" style="padding: 10px;">
                        @if($disciplinasDisponiveis->count() > 0)
                            <form id="atribuir-multiplas-form" action="{{ route('admin.turmas.atribuir-disciplinas.store', $turma) }}" method="POST">
                                @csrf
                                <input type="hidden" name="ano_letivo_id" value="{{ $anoLetivo->id }}">
                                
                                <div class="mb-2 d-flex justify-content-between align-items-center">
                                    <div>
                                        <input type="checkbox" id="selectAllDisciplinas" style="width: 16px; height: 16px; cursor: pointer;">
                                        <label for="selectAllDisciplinas" class="ms-1" style="font-size: 0.85rem; cursor: pointer;">Selecionar todas</label>
                                    </div>
                                    <button type="submit" class="btn btn-sm btn-primary" id="btnAtribuirMultiplas" disabled>
                                        <i class="bi bi-plus-circle"></i> Atribuir Selecionadas
                                    </button>
                                </div>
                                
                                <div class="table-responsive" style="max-height: 450px; overflow-y: auto;">
                                    <table class="table table-sm table-bordered mb-0" style="font-size: 0.85rem;">
                                        <thead style="background-color: #f8f9fa; position: sticky; top: 0;">
                                            <tr>
                                                <th style="padding: 6px; width: 30px;">
                                                    <input type="checkbox" id="selectAllHeader" style="width: 16px; height: 16px;">
                                                </th>
                                                <th style="padding: 6px;">Disciplina</th>
                                                <th style="padding: 6px;">Carga</th>
                                                <th style="padding: 6px;">Professor</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($disciplinasDisponiveis as $disciplina)
                                                @php
                                                    $professoresDisciplina = $professoresPorDisciplina[$disciplina->id] ?? collect();
                                                @endphp
                                                <tr class="disciplina-row" data-disciplina-id="{{ $disciplina->id }}" data-tem-professor="{{ $professoresDisciplina->count() > 0 ? '1' : '0' }}">
                                                    <td style="padding: 5px;">
                                                        @if($professoresDisciplina->count() > 0)
                                                            <input type="checkbox" 
                                                                   name="disciplinas[{{ $disciplina->id }}][selecionada]" 
                                                                   value="1"
                                                                   class="disciplina-checkbox"
                                                                   data-disciplina-id="{{ $disciplina->id }}"
                                                                   style="width: 16px; height: 16px; cursor: pointer;">
                                                        @else
                                                            <span style="font-size: 0.7rem; color: #6c757d;">-</span>
                                                        @endif
                                                    </td>
                                                    <td style="padding: 5px;">
                                                        <strong>{{ $disciplina->nome }}</strong>
                                                    </td>
                                                    <td style="padding: 5px;">
                                                        <small class="text-muted">{{ $disciplina->carga_horaria_formatada }}</small>
                                                    </td>
                                                    <td style="padding: 5px;">
                                                        @if($professoresDisciplina->count() > 0)
                                                            <select name="disciplinas[{{ $disciplina->id }}][professor_id]" 
                                                                    class="form-select form-select-sm professor-select" 
                                                                    style="min-width: 150px;" 
                                                                    data-disciplina-id="{{ $disciplina->id }}"
                                                                    disabled>
                                                                <option value="">Selecione...</option>
                                                                @foreach($professoresDisciplina as $prof)
                                                                    <option value="{{ $prof['id'] }}">{{ $prof['name'] }}</option>
                                                                @endforeach
                                                            </select>
                                                        @else
                                                            <small class="text-danger" style="font-size: 0.7rem;">
                                                                Sem professor disponível
                                                            </small>
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </form>
                        @else
                            <p class="text-muted text-center mb-0" style="font-size: 0.85rem; padding: 20px;">
                                <i class="bi bi-inbox"></i> Nenhuma disciplina disponível
                            </p>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const selectAllHeader = document.getElementById('selectAllHeader');
    const selectAllDisciplinas = document.getElementById('selectAllDisciplinas');
    const checkboxes = document.querySelectorAll('.disciplina-checkbox');
    const btnAtribuirMultiplas = document.getElementById('btnAtribuirMultiplas');
    const form = document.getElementById('atribuir-multiplas-form');
    
    // Selecionar todas (header)
    if (selectAllHeader) {
        selectAllHeader.addEventListener('change', function() {
            checkboxes.forEach(checkbox => {
                if (checkbox.closest('tr').dataset.temProfessor === '1') {
                    checkbox.checked = this.checked;
                    toggleProfessorSelect(checkbox);
                }
            });
            if (selectAllDisciplinas) {
                selectAllDisciplinas.checked = this.checked;
            }
            updateButtonState();
        });
    }
    
    // Selecionar todas (label)
    if (selectAllDisciplinas) {
        selectAllDisciplinas.addEventListener('change', function() {
            checkboxes.forEach(checkbox => {
                if (checkbox.closest('tr').dataset.temProfessor === '1') {
                    checkbox.checked = this.checked;
                    toggleProfessorSelect(checkbox);
                }
            });
            if (selectAllHeader) {
                selectAllHeader.checked = this.checked;
            }
            updateButtonState();
        });
    }
    
    // Checkboxes individuais
    checkboxes.forEach(checkbox => {
        checkbox.addEventListener('change', function() {
            toggleProfessorSelect(this);
            updateSelectAllState();
            updateButtonState();
        });
    });
    
    function toggleProfessorSelect(checkbox) {
        const row = checkbox.closest('tr');
        const select = row.querySelector('.professor-select');
        if (select) {
            select.disabled = !checkbox.checked;
            if (!checkbox.checked) {
                select.value = '';
            }
        }
    }
    
    function updateSelectAllState() {
        const checkboxesComProfessor = Array.from(checkboxes).filter(cb => cb.closest('tr').dataset.temProfessor === '1');
        const allChecked = checkboxesComProfessor.length > 0 && checkboxesComProfessor.every(cb => cb.checked);
        const someChecked = checkboxesComProfessor.some(cb => cb.checked);
        
        if (selectAllHeader) {
            selectAllHeader.checked = allChecked && checkboxesComProfessor.length > 0;
            selectAllHeader.indeterminate = someChecked && !allChecked;
        }
        if (selectAllDisciplinas) {
            selectAllDisciplinas.checked = allChecked && checkboxesComProfessor.length > 0;
            selectAllDisciplinas.indeterminate = someChecked && !allChecked;
        }
    }
    
    function updateButtonState() {
        if (btnAtribuirMultiplas) {
            const hasSelected = Array.from(checkboxes).some(cb => cb.checked);
            btnAtribuirMultiplas.disabled = !hasSelected;
        }
    }
    
    // Validação ao submeter o formulário
    if (form) {
        form.addEventListener('submit', function(e) {
            const disciplinasSelecionadas = Array.from(checkboxes).filter(cb => cb.checked);
            
            if (disciplinasSelecionadas.length === 0) {
                e.preventDefault();
                alert('Por favor, selecione pelo menos uma disciplina.');
                return false;
            }
            
            // Validar se todas as disciplinas selecionadas têm professor
            let disciplinasSemProfessor = [];
            disciplinasSelecionadas.forEach(checkbox => {
                const row = checkbox.closest('tr');
                const select = row.querySelector('.professor-select');
                if (!select || !select.value) {
                    const disciplinaNome = row.querySelector('td:nth-child(2) strong').textContent;
                    disciplinasSemProfessor.push(disciplinaNome);
                }
            });
            
            if (disciplinasSemProfessor.length > 0) {
                e.preventDefault();
                alert('Por favor, selecione um professor para todas as disciplinas selecionadas:\n\n' + disciplinasSemProfessor.join('\n'));
                return false;
            }
        });
    }
    
    // Inicializar estado
    updateButtonState();
});
</script>
@endsection
