@extends('layouts.app')

@section('title', 'Alocar Professores - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <div>
                <h5 class="mb-0" style="font-weight: 600;">Alocar Professores</h5>
                <small class="text-muted">{{ $turma->codigo }} - {{ $turma->nome }}@if($anoLetivo) | {{ $anoLetivo->ano }}@endif</small>
            </div>
            <a href="{{ route('admin.turmas.index') }}" class="btn btn-sm btn-secondary">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>

        <div class="row">
            <!-- Professores Alocados -->
            <div class="col-md-6">
                <div class="mb-2">
                    <small class="text-muted" style="font-weight: 600;">Professores Alocados ({{ $alocacoes->count() }})</small>
                    </div>
                        @if($alocacoes->count() > 0)
                            <div class="table-responsive">
                        <table class="table table-sm table-bordered" style="font-size: 0.85rem; margin-bottom: 0;">
                                    <thead style="background-color: #f8f9fa;">
                                        <tr>
                                            <th style="padding: 6px;">Professor</th>
                                            <th style="padding: 6px;">Disciplina</th>
                                            <th style="padding: 6px;">Modelo</th>
                                            <th style="padding: 6px;">Ações</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($alocacoesAgrupadas as $professorId => $alocacoesProfessor)
                                            @php
                                                $primeiraAlocacao = $alocacoesProfessor->first();
                                                $totalDisciplinas = $alocacoesProfessor->count();
                                            @endphp
                                            @foreach($alocacoesProfessor as $index => $alocacao)
                                                <tr>
                                                    @if($index === 0)
                                                        <td rowspan="{{ $totalDisciplinas }}" class="align-middle" style="padding: 5px;">
                                                            <strong style="font-size: 0.85rem;">{{ $primeiraAlocacao->professor_nome }}</strong>
                                                            @if($totalDisciplinas > 1)
                                                                <br><span style="font-size: 0.75rem; padding: 2px 6px; background: #e2e3e5; color: #383d41; border-radius: 3px;">
                                                                    {{ $totalDisciplinas }} disciplinas
                                                                </span>
                                                            @endif
                                                        </td>
                                                    @endif
                                                    <td style="padding: 5px;">{{ $alocacao->disciplina_nome }}</td>
                                                    <td style="padding: 5px;">
                                                        <span style="font-size: 0.75rem; padding: 2px 6px; background: #e7f3ff; color: #0066cc; border-radius: 3px;">{{ $alocacao->modelo_avaliacao }}</span>
                                                    </td>
                                                    <td style="padding: 5px;">
                                                        <form action="{{ route('admin.turmas.remover-professor', ['turmaId' => $turma->id, 'professorId' => $professorId]) }}" 
                                                              method="POST" 
                                                              class="d-inline"
                                                              onsubmit="return confirm('Tem certeza que deseja remover {{ $primeiraAlocacao->professor_nome }} da disciplina {{ $alocacao->disciplina_nome }}?');">
                                                            @csrf
                                                            @method('DELETE')
                                                            <input type="hidden" name="disciplina_id" value="{{ $alocacao->disciplina_id }}">
                                                            <button type="submit" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #f8d7da; color: #721c24; border: none;" title="Remover">
                                                                <i class="bi bi-x-circle"></i>
                                                            </button>
                                                        </form>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <p class="text-muted text-center mb-0" style="font-size: 0.85rem; padding: 10px;">
                                Nenhum professor alocado
                            </p>
                        @endif
            </div>

            <!-- Alocar Novo Professor -->
            <div class="col-md-6">
                <div class="mb-2">
                    <small class="text-muted" style="font-weight: 600;">Alocar Professor</small>
                    </div>
                <form action="{{ route('admin.turmas.alocar-professores.store', $turma) }}" method="POST" style="background: #f8f9fa; padding: 10px; border-radius: 4px;">
                            @csrf
                            <input type="hidden" name="ano_letivo_id" value="{{ $anoLetivo->id }}">
                            
                    <div class="mb-2">
                        <label for="disciplina_id" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Disciplina <span class="text-danger">*</span></label>
                        <select class="form-select form-select-sm @error('disciplina_id') is-invalid @enderror" 
                                        id="disciplina_id" name="disciplina_id" required>
                            <option value="">Selecione...</option>
                                    @foreach($disciplinas as $disciplina)
                                        <option value="{{ $disciplina->id }}" {{ old('disciplina_id') == $disciplina->id ? 'selected' : '' }}>
                                            {{ $disciplina->nome }} ({{ $disciplina->modelo_avaliacao }})
                                        </option>
                                    @endforeach
                                </select>
                                @error('disciplina_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                    <div class="mb-2">
                        <label for="professor_id" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Professor <span class="text-danger">*</span></label>
                        <select class="form-select form-select-sm @error('professor_id') is-invalid @enderror" 
                                        id="professor_id" name="professor_id" required disabled>
                            <option value="">Primeiro selecione uma disciplina</option>
                                    @foreach($professores as $professor)
                                        <option value="{{ $professor->id }}" data-disciplinas="{{ json_encode($professoresPorDisciplina ?? []) }}" {{ old('professor_id') == $professor->id ? 'selected' : '' }}>
                                    {{ $professor->user->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('professor_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                    <div class="mt-2">
                        <button type="submit" class="btn btn-sm btn-primary w-100">
                            Alocar Professor
                                </button>
                            </div>
                        </form>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const disciplinaSelect = document.getElementById('disciplina_id');
    const professorSelect = document.getElementById('professor_id');
    const anoLetivoId = {{ $anoLetivo->id ?? 'null' }};
    
    // Dados iniciais de todos os professores
    const todosProfessores = @json($professores->map(function($p) {
        return ['id' => $p->id, 'name' => $p->user->name];
    })->values());
    
    // Dados de professores por disciplina
    const professoresPorDisciplina = @json($professoresPorDisciplina ?? []);
    
    // Função para atualizar lista de professores
    function atualizarProfessores(disciplinaId) {
        // Limpar opções atuais (exceto a primeira)
        professorSelect.innerHTML = '<option value="">Selecione...</option>';
        professorSelect.disabled = true;
        
        if (!disciplinaId) {
            return;
        }
        
        // Buscar professores via AJAX
        fetch(`{{ route('admin.professores.por-disciplina') }}?disciplina_id=${disciplinaId}&ano_letivo_id=${anoLetivoId}`, {
            method: 'GET',
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.professores && data.professores.length > 0) {
                data.professores.forEach(prof => {
                    const option = document.createElement('option');
                    option.value = prof.id;
                    option.textContent = prof.name;
                    professorSelect.appendChild(option);
                });
                professorSelect.disabled = false;
            } else {
                // Se não houver professores específicos, mostrar todos
                todosProfessores.forEach(prof => {
                    const option = document.createElement('option');
                    option.value = prof.id;
                    option.textContent = prof.name;
                    professorSelect.appendChild(option);
                });
                professorSelect.disabled = false;
            }
        })
        .catch(error => {
            console.error('Erro ao buscar professores:', error);
            // Em caso de erro, mostrar todos os professores
            todosProfessores.forEach(prof => {
                const option = document.createElement('option');
                option.value = prof.id;
                option.textContent = prof.name;
                professorSelect.appendChild(option);
            });
            professorSelect.disabled = false;
        });
    }
    
    // Event listener para mudança de disciplina
    disciplinaSelect.addEventListener('change', function() {
        const disciplinaId = this.value;
        atualizarProfessores(disciplinaId);
    });
    
    // Se já houver uma disciplina selecionada (old input), atualizar professores
    @if(old('disciplina_id'))
        atualizarProfessores({{ old('disciplina_id') }});
        // Restaurar professor selecionado se houver
        @if(old('professor_id'))
            setTimeout(() => {
                professorSelect.value = {{ old('professor_id') }};
            }, 500);
        @endif
    @endif
});
</script>
@endsection

