@extends('layouts.app')

@section('title', 'Alocar Alunos - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <div>
                <h5 class="mb-0" style="font-weight: 600;">Alocar Alunos</h5>
                <small class="text-muted">{{ $turma->codigo }} - {{ $turma->nome }}@if($anoLetivo) | {{ $anoLetivo->ano }}@endif</small>
            </div>
            <a href="{{ route('admin.turmas.index') }}" class="btn btn-sm btn-secondary">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>

        <div class="row">
            <!-- Alunos da Turma -->
            <div class="col-md-6">
                <div class="mb-2">
                    <small class="text-muted" style="font-weight: 600;">Alunos Alocados ({{ $alunosTurma->count() }})</small>
                </div>
                @if($alunosTurma->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-sm table-bordered" style="font-size: 0.85rem; margin-bottom: 0;">
                                    <thead style="background-color: #f8f9fa;">
                                        <tr>
                                            <th style="padding: 6px;">Código</th>
                                            <th style="padding: 6px;">Nome</th>
                                            <th style="padding: 6px;">Acções</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($alunosTurma as $aluno)
                                            <tr>
                                                <td style="padding: 5px;">{{ $aluno->codigo_estudante }}</td>
                                                <td style="padding: 5px;">{{ $aluno->user->name }}</td>
                                                <td style="padding: 5px;">
                                                    <form action="{{ route('admin.turmas.remover-aluno', ['turma' => $turma, 'aluno' => $aluno]) }}" 
                                                          method="POST" 
                                                          class="d-inline"
                                                          onsubmit="return confirm('Tem certeza que deseja remover este aluno da turma?');">
                                                        @csrf
                                                        @method('DELETE')
                                                        <input type="hidden" name="ano_letivo_id" value="{{ $anoLetivo->id }}">
                                                        <button type="submit" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #f8d7da; color: #721c24; border: none;">
                                                            <i class="bi bi-x-circle"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <p class="text-muted text-center mb-0" style="font-size: 0.85rem; padding: 10px;">
                                Nenhum aluno alocado
                            </p>
                        @endif
            </div>

            <!-- Alunos Disponíveis -->
            <div class="col-md-6">
                <div class="mb-2">
                    <small class="text-muted" style="font-weight: 600;">Alunos Disponíveis ({{ $alunosDisponiveis->count() }})</small>
                </div>
                @if($alunosDisponiveis->count() > 0)
                    <form action="{{ route('admin.turmas.alocar-alunos.store', $turma) }}" method="POST">
                        @csrf
                        <input type="hidden" name="ano_letivo_id" value="{{ $anoLetivo->id }}">
                        
                        <div class="table-responsive" style="max-height: 400px; overflow-y: auto;">
                            <table class="table table-sm table-bordered" style="font-size: 0.85rem; margin-bottom: 0;">
                                <thead class="sticky-top" style="background-color: #f8f9fa;">
                                    <tr>
                                        <th width="30" style="padding: 6px;">
                                            <input type="checkbox" id="selectAll" title="Selecionar todos" style="width: 16px; height: 16px;">
                                        </th>
                                        <th style="padding: 6px;">Código</th>
                                        <th style="padding: 6px;">Nome</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($alunosDisponiveis as $aluno)
                                        <tr>
                                            <td style="padding: 5px;">
                                                <input type="checkbox" 
                                                       name="aluno_id[]" 
                                                       value="{{ $aluno->id }}"
                                                       class="aluno-checkbox"
                                                       style="width: 16px; height: 16px;">
                                            </td>
                                            <td style="padding: 5px;">{{ $aluno->codigo_estudante }}</td>
                                            <td style="padding: 5px;">{{ $aluno->user->name }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="mt-2">
                            <button type="submit" class="btn btn-sm btn-primary w-100" id="btnAlocar" disabled>
                                Alocar Selecionados
                            </button>
                        </div>
                    </form>
                @else
                    <p class="text-muted text-center mb-0" style="font-size: 0.85rem; padding: 10px;">
                        Todos os alunos já estão alocados
                    </p>
                @endif
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const selectAll = document.getElementById('selectAll');
    const checkboxes = document.querySelectorAll('.aluno-checkbox');
    const btnAlocar = document.getElementById('btnAlocar');
    
    if (selectAll) {
        selectAll.addEventListener('change', function() {
            checkboxes.forEach(checkbox => {
                checkbox.checked = this.checked;
            });
            updateButtonState();
        });
    }
    
    checkboxes.forEach(checkbox => {
        checkbox.addEventListener('change', function() {
            if (selectAll) {
                selectAll.checked = Array.from(checkboxes).every(cb => cb.checked);
            }
            updateButtonState();
        });
    });
    
    function updateButtonState() {
        if (btnAlocar) {
            const hasSelected = Array.from(checkboxes).some(cb => cb.checked);
            btnAlocar.disabled = !hasSelected;
        }
    }
});
</script>
@endsection

