@extends('layouts.app')

@section('title', 'Editar Professor - SGE')

@section('content')
<div class="row">
    <div class="col-md-10">
        <div class="card">
            <div class="card-header bg-primary-custom text-white py-2">
                <h5 class="mb-0">Editar Professor</h5>
            </div>
            <div class="card-body p-2">
                <form method="POST" action="{{ route('admin.professores.update', $professor) }}" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    <div class="row g-1">
                        <div class="col-md-6">
                            <label for="name" class="form-label small mb-0">Nome *</label>
                            <input type="text" class="form-control form-control-sm @error('name') is-invalid @enderror" 
                                   id="name" name="name" value="{{ old('name', $professor->user->name) }}" required>
                            @error('name')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="numero_funcionario" class="form-label small mb-0">Código do Professor</label>
                            <input type="text" class="form-control form-control-sm" 
                                   id="numero_funcionario" name="numero_funcionario" 
                                   value="{{ old('numero_funcionario', $professor->numero_funcionario) }}" 
                                   readonly disabled>
                        </div>

                        <div class="col-md-6">
                            <label for="genero" class="form-label small mb-0">Género</label>
                            <select class="form-select form-select-sm @error('genero') is-invalid @enderror" 
                                    id="genero" name="genero">
                                <option value="">Selecione</option>
                                <option value="M" {{ old('genero', $professor->genero) == 'M' ? 'selected' : '' }}>Masculino</option>
                                <option value="F" {{ old('genero', $professor->genero) == 'F' ? 'selected' : '' }}>Feminino</option>
                                <option value="Outro" {{ old('genero', $professor->genero) == 'Outro' ? 'selected' : '' }}>Outro</option>
                            </select>
                            @error('genero')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="telefone" class="form-label small mb-0">Contacto</label>
                            <input type="text" class="form-control form-control-sm @error('telefone') is-invalid @enderror" 
                                   id="telefone" name="telefone" value="{{ old('telefone', $professor->telefone) }}" 
                                   placeholder="Ex: 842528792">
                            @error('telefone')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="nivel_ensino" class="form-label small mb-0">Nível de Ensino *</label>
                            <select class="form-select form-select-sm @error('nivel_ensino') is-invalid @enderror"
                                    id="nivel_ensino" name="nivel_ensino" required>
                                <option value="">Selecione</option>
                                <option value="PRIMARIO" {{ old('nivel_ensino', $professor->nivel_ensino ?? 'AMBOS') == 'PRIMARIO' ? 'selected' : '' }}>Primário</option>
                                <option value="SECUNDARIO" {{ old('nivel_ensino', $professor->nivel_ensino ?? 'AMBOS') == 'SECUNDARIO' ? 'selected' : '' }}>Secundário</option>
                                <option value="AMBOS" {{ old('nivel_ensino', $professor->nivel_ensino ?? 'AMBOS') == 'AMBOS' ? 'selected' : '' }}>Ambos</option>
                            </select>
                            @error('nivel_ensino')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Campos de Salário -->
                        <div class="col-md-6" id="salario_fixo_field" style="display: none;">
                            <label for="salario_fixo" class="form-label small mb-0">Salário Fixo (MT) *</label>
                            <input type="number" step="0.01" min="0" 
                                   class="form-control form-control-sm @error('salario_fixo') is-invalid @enderror" 
                                   id="salario_fixo" name="salario_fixo" 
                                   value="{{ old('salario_fixo', $professor->salario_fixo) }}" 
                                   placeholder="Ex: 15000.00">
                            <small class="form-text text-muted" style="font-size: 0.7rem;">Salário fixo para professores da primária</small>
                            @error('salario_fixo')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6" id="valor_hora_field" style="display: none;">
                            <label for="valor_hora" class="form-label small mb-0">Valor por Hora (MT) *</label>
                            <input type="number" step="0.01" min="0" 
                                   class="form-control form-control-sm @error('valor_hora') is-invalid @enderror" 
                                   id="valor_hora" name="valor_hora" 
                                   value="{{ old('valor_hora', $professor->valor_hora) }}" 
                                   placeholder="Ex: 500.00">
                            <small class="form-text text-muted" style="font-size: 0.7rem;">Valor por hora para professores do secundário</small>
                            @error('valor_hora')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="numero_dependentes" class="form-label small mb-0">Número de Dependentes</label>
                            <input type="number" min="0" max="10" 
                                   class="form-control form-control-sm @error('numero_dependentes') is-invalid @enderror" 
                                   id="numero_dependentes" name="numero_dependentes" 
                                   value="{{ old('numero_dependentes', $professor->numero_dependentes ?? 0) }}" 
                                   placeholder="0">
                            <small class="form-text text-muted" style="font-size: 0.7rem;">Usado para cálculo de IRPS (máximo 4 para efeitos fiscais)</small>
                            @error('numero_dependentes')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="documento_identificacao" class="form-label small mb-0">Documento</label>
                            @if($professor->documento_identificacao)
                                <div class="mb-1">
                                    <a href="{{ asset('storage/' . $professor->documento_identificacao) }}" target="_blank" class="btn btn-sm btn-info py-0 px-2" style="font-size: 0.7rem;">
                                        <i class="bi bi-file-earmark-pdf"></i> Ver
                                    </a>
                                </div>
                            @endif
                            <input type="file" class="form-control form-control-sm @error('documento_identificacao') is-invalid @enderror" 
                                   id="documento_identificacao" name="documento_identificacao" 
                                   accept=".pdf,.jpg,.jpeg,.png">
                            @error('documento_identificacao')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        @if($anoLetivo)
                        <div class="col-md-6">
                            <label for="turma_id" class="form-label small mb-0">Turma</label>
                            <select class="form-select form-select-sm @error('turma_id') is-invalid @enderror" 
                                    id="turma_id" name="turma_id">
                                <option value="">Selecione</option>
                                @foreach($turmas ?? [] as $turma)
                                    <option value="{{ $turma->id }}"
                                            data-nivel="{{ $turma->nivel_ensino ?? 'PRIMARIO' }}">
                                        {{ $turma->codigo }} - Turma {{ $turma->nome }}
                                    </option>
                                @endforeach
                            </select>
                            @error('turma_id')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="disciplinas" class="form-label small mb-0">Disciplinas</label>
                            <select class="form-select form-select-sm @error('disciplinas') is-invalid @enderror" 
                                    id="disciplinas" name="disciplinas[]" multiple size="3">
                                @foreach($disciplinas ?? [] as $disciplina)
                                    <option value="{{ $disciplina->id }}"
                                            data-nivel="{{ $disciplina->nivel_ensino ?? 'PRIMARIO' }}">
                                        {{ $disciplina->nome }}
                                    </option>
                                @endforeach
                            </select>
                            <small class="text-muted" style="font-size: 0.7rem;">Ctrl para múltiplas</small>
                            @error('disciplinas')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        @if($alocacoesAtuais && $alocacoesAtuais->count() > 0)
                        <div class="col-md-12">
                            <label class="form-label small mb-0">Alocações ({{ $anoLetivo->ano_inicial }}):</label>
                            <div class="table-responsive" style="max-height: 100px; overflow-y: auto;">
                                <table class="table table-sm table-bordered mb-0" style="font-size: 0.75rem;">
                                    <thead>
                                        <tr>
                                            <th style="padding: 0.2rem;">Turma</th>
                                            <th style="padding: 0.2rem;">Disciplina</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($alocacoesAtuais as $alocacao)
                                            @php
                                                $turmaAloc = \App\Models\Turma::find($alocacao->turma_id);
                                                $disciplinaAloc = \App\Models\Disciplina::find($alocacao->disciplina_id);
                                            @endphp
                                            <tr>
                                                <td style="padding: 0.2rem;">{{ $turmaAloc ? $turmaAloc->codigo . ' - ' . $turmaAloc->nome : 'N/A' }}</td>
                                                <td style="padding: 0.2rem;">{{ $disciplinaAloc ? $disciplinaAloc->nome : 'N/A' }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        @endif
                        @endif
                    </div>

                    <div class="mt-1">
                        <button type="submit" class="btn btn-primary-custom btn-sm py-1 px-3">Atualizar</button>
                        <a href="{{ route('admin.professores.index') }}" class="btn btn-secondary btn-sm py-1 px-3">Cancelar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

<script>
function initProfessorEditForm() {
    const nivelSelect = document.getElementById('nivel_ensino');
    const disciplinasSelect = document.getElementById('disciplinas');
    const turmasSelect = document.getElementById('turma_id');

    function filtrarDisciplinas() {
        if (!nivelSelect || !disciplinasSelect) return;
        const nivel = nivelSelect.value || 'AMBOS';
        const options = Array.from(disciplinasSelect.options);
        options.forEach(option => {
            const nivelDisciplina = option.getAttribute('data-nivel') || 'PRIMARIO';
            const visivel = (nivel === 'AMBOS') || (nivelDisciplina === nivel);
            option.hidden = !visivel;
            if (!visivel) {
                option.selected = false;
            }
        });
    }

    function filtrarTurmas() {
        if (!nivelSelect || !turmasSelect) return;
        const nivel = nivelSelect.value || 'AMBOS';
        const options = Array.from(turmasSelect.options);
        options.forEach(option => {
            if (!option.value) return;
            const nivelTurma = option.getAttribute('data-nivel') || 'PRIMARIO';
            const visivel = (nivel === 'AMBOS') || (nivelTurma === nivel);
            option.hidden = !visivel;
            if (!visivel && option.selected) {
                option.selected = false;
            }
        });
    }

    // Função para mostrar/ocultar campos de salário baseado no nível
    function atualizarCamposSalario() {
        const nivel = nivelSelect.value;
        const salarioFixoField = document.getElementById('salario_fixo_field');
        const valorHoraField = document.getElementById('valor_hora_field');
        const salarioFixoInput = document.getElementById('salario_fixo');
        const valorHoraInput = document.getElementById('valor_hora');

        if (nivel === 'PRIMARIO' || nivel === 'AMBOS') {
            if (salarioFixoField) salarioFixoField.style.display = 'block';
            if (salarioFixoInput) salarioFixoInput.required = true;
        } else {
            if (salarioFixoField) salarioFixoField.style.display = 'none';
            if (salarioFixoInput) {
                salarioFixoInput.required = false;
                if (nivel === 'SECUNDARIO') salarioFixoInput.value = '';
            }
        }

        if (nivel === 'SECUNDARIO' || nivel === 'AMBOS') {
            if (valorHoraField) valorHoraField.style.display = 'block';
            if (valorHoraInput) valorHoraInput.required = true;
        } else {
            if (valorHoraField) valorHoraField.style.display = 'none';
            if (valorHoraInput) {
                valorHoraInput.required = false;
                if (nivel === 'PRIMARIO') valorHoraInput.value = '';
            }
        }
    }

    // Função para mostrar/ocultar campos de salário baseado no nível
    function atualizarCamposSalario() {
        const nivel = nivelSelect.value;
        const salarioFixoField = document.getElementById('salario_fixo_field');
        const valorHoraField = document.getElementById('valor_hora_field');
        const salarioFixoInput = document.getElementById('salario_fixo');
        const valorHoraInput = document.getElementById('valor_hora');

        if (nivel === 'PRIMARIO' || nivel === 'AMBOS') {
            if (salarioFixoField) salarioFixoField.style.display = 'block';
            if (salarioFixoInput) salarioFixoInput.required = true;
        } else {
            if (salarioFixoField) salarioFixoField.style.display = 'none';
            if (salarioFixoInput) {
                salarioFixoInput.required = false;
                if (nivel === 'SECUNDARIO') salarioFixoInput.value = '';
            }
        }

        if (nivel === 'SECUNDARIO' || nivel === 'AMBOS') {
            if (valorHoraField) valorHoraField.style.display = 'block';
            if (valorHoraInput) valorHoraInput.required = true;
        } else {
            if (valorHoraField) valorHoraField.style.display = 'none';
            if (valorHoraInput) {
                valorHoraInput.required = false;
                if (nivel === 'PRIMARIO') valorHoraInput.value = '';
            }
        }
    }

    if (nivelSelect) {
        nivelSelect.addEventListener('change', function() {
            filtrarDisciplinas();
            filtrarTurmas();
            atualizarCamposSalario();
        });
        filtrarDisciplinas();
        filtrarTurmas();
        atualizarCamposSalario(); // Executar ao carregar
    }
}

window.initProfessorEditForm = initProfessorEditForm;

document.addEventListener('DOMContentLoaded', function() {
    initProfessorEditForm();
});
</script>
