<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Folha de Salário - {{ $mesNome }}/{{ $ano }}</title>
    <style>
        @media print {
            .no-print {
                display: none !important;
            }
            body {
                margin: 0;
                padding: 0;
            }
        }
        /* Esconder botão no PDF */
        .btn-print {
            display: none;
        }
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 20px;
            color: #333;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
        }
        .header h1 {
            margin: 0;
            font-size: 20px;
            font-weight: bold;
        }
        .header h2 {
            margin: 5px 0;
            font-size: 16px;
            font-weight: normal;
        }
        .info-box {
            margin-bottom: 20px;
            padding: 10px;
            background-color: #f5f5f5;
            border: 1px solid #ddd;
        }
        .info-box p {
            margin: 5px 0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        table th, table td {
            border: 1px solid #333;
            padding: 8px;
            text-align: left;
        }
        table th {
            background-color: #333;
            color: white;
            font-weight: bold;
        }
        table tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .total-row {
            font-weight: bold;
            background-color: #e8e8e8 !important;
        }
        .footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px solid #333;
            text-align: center;
            font-size: 10px;
        }
        .btn-print {
            position: fixed;
            top: 20px;
            right: 20px;
            padding: 10px 20px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 14px;
        }
        .btn-print:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    @if(!isset($logotipoBase64) && isset($logotipoUrl))
        <button class="btn-print no-print" onclick="window.print()" style="position: fixed; top: 20px; right: 20px; padding: 10px 20px; background-color: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 14px;">
            <i class="bi bi-printer"></i> Imprimir
        </button>
    @endif

    <div class="header">
        <div style="text-align: center; margin-bottom: 15px;">
            @if($logotipoBase64)
                <img src="{{ $logotipoBase64 }}" alt="Logotipo" style="max-height: 80px; max-width: 200px; margin-bottom: 10px;">
            @elseif(isset($logotipoUrl) && $logotipoUrl)
                <img src="{{ $logotipoUrl }}" alt="Logotipo" style="max-height: 80px; max-width: 200px; margin-bottom: 10px;">
            @endif
            <div style="text-align: center;">
                <h2 style="margin: 5px 0; font-size: 16px; font-weight: normal;">FOLHA DE SALÁRIO</h2>
                <h3 style="margin: 5px 0; font-size: 14px; font-weight: normal;">{{ $mesNome }} de {{ $ano }}</h3>
            </div>
        </div>
        @if($professorEspecifico && $professorEspecifico->user)
            <p style="margin: 10px 0 0 0;"><strong>Professor:</strong> {{ $professorEspecifico->user->name }} ({{ $professorEspecifico->numero_funcionario }})</p>
        @else
            <p style="margin: 10px 0 0 0;"><strong>Todos os Professores</strong></p>
        @endif
    </div>

    <div class="info-box">
        <p><strong>Período:</strong> {{ $mesNome }} de {{ $ano }}</p>
        <p><strong>Data de Emissão:</strong> {{ now()->format('d/m/Y H:i') }}</p>
        <p><strong>Total de Professores:</strong> {{ $payments->count() }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th style="width: 3%;">#</th>
                <th style="width: 10%;">Código</th>
                <th style="width: 20%;">Nome do Professor</th>
                <th style="width: 8%;">Ensino</th>
                <th style="width: 7%;">Horas</th>
                <th style="width: 12%;" class="text-right">Valor Bruto</th>
                <th style="width: 10%;" class="text-right">INSS (3%)</th>
                <th style="width: 10%;" class="text-right">IRPS</th>
                <th style="width: 12%;" class="text-right">Valor Líquido</th>
                <th style="width: 8%;">Data Pagamento</th>
            </tr>
        </thead>
        <tbody>
            @foreach($payments as $index => $payment)
                @if($payment->professor && $payment->professor->user)
                <tr>
                    <td class="text-center">{{ $index + 1 }}</td>
                    <td>{{ $payment->professor->numero_funcionario }}</td>
                    <td>{{ $payment->professor->user->name }}</td>
                    <td class="text-center">
                        @if(($payment->professor->nivel_ensino ?? 'AMBOS') === 'PRIMARIO')
                            Primário
                        @elseif(($payment->professor->nivel_ensino ?? 'AMBOS') === 'SECUNDARIO')
                            Secundário
                        @else
                            Ambos
                        @endif
                    </td>
                    <td class="text-center">
                        @if($payment->horas_trabalhadas)
                            {{ number_format($payment->horas_trabalhadas, 2) }}h
                        @else
                            -
                        @endif
                    </td>
                    <td class="text-right">{{ number_format($payment->valor_total, 2, ',', '.') }} MT</td>
                    <td class="text-right">{{ number_format($payment->inss ?? 0, 2, ',', '.') }} MT</td>
                    <td class="text-right">{{ number_format($payment->irps ?? 0, 2, ',', '.') }} MT</td>
                    <td class="text-right"><strong>{{ number_format($payment->valor_liquido ?? ($payment->valor_total - ($payment->inss ?? 0) - ($payment->irps ?? 0)), 2, ',', '.') }} MT</strong></td>
                    <td class="text-center">
                        @if($payment->data_pagamento)
                            {{ \Carbon\Carbon::parse($payment->data_pagamento)->format('d/m/Y') }}
                        @else
                            -
                        @endif
                    </td>
                </tr>
                @endif
            @endforeach
        </tbody>
        <tfoot>
            <tr class="total-row">
                <td colspan="5" class="text-right"><strong>TOTAL GERAL:</strong></td>
                <td class="text-right"><strong>{{ number_format($payments->sum('valor_total'), 2, ',', '.') }} MT</strong></td>
                <td class="text-right"><strong>{{ number_format($payments->sum('inss'), 2, ',', '.') }} MT</strong></td>
                <td class="text-right"><strong>{{ number_format($payments->sum('irps'), 2, ',', '.') }} MT</strong></td>
                <td class="text-right"><strong>{{ number_format($payments->sum(function($p) { return $p->valor_liquido ?? ($p->valor_total - ($p->inss ?? 0) - ($p->irps ?? 0)); }), 2, ',', '.') }} MT</strong></td>
                <td></td>
            </tr>
        </tfoot>
    </table>

    <div class="footer">
        <p>Documento gerado em {{ now()->format('d/m/Y H:i') }} pelo Sistema Integrado de Gestão Escolar (SIGE)</p>
        <p>Este documento é uma cópia autêntica da folha de salário</p>
    </div>
</body>
</html>
