@extends('layouts.app')

@section('title', 'Scanner de presença – Crachá Professor')

@section('content')
<div class="row justify-content-center">
    <div class="col-12 col-lg-10">
        <div class="d-flex justify-content-between align-items-center mb-3" style="border-bottom: 1px solid #dee2e6; padding-bottom: 10px;">
            <h5 class="mb-0" style="font-weight: 600;">Scanner de presença</h5>
            <div class="d-flex gap-2">
                <a href="{{ route('admin.presenca-professor.index') }}" class="btn btn-sm btn-outline-primary">Lista de presenças</a>
                <a href="{{ route('admin.cartoes-professores.index') }}" class="btn btn-sm btn-outline-secondary">Crachás</a>
            </div>
        </div>
        <p class="text-muted small mb-3">Use o telemóvel ou tablet para apontar a câmara ao QR code do crachá do professor. A presença é registada automaticamente. Ao marcar, é emitido um som de confirmação.</p>
        <p class="text-muted small mb-2"><strong>Entrada e saída:</strong> O primeiro scan do dia conta como <em>entrada</em> e o último scan do mesmo dia conta como <em>saída</em>. Ou seja, o professor define a hora de saída ao passar o crachá ao sair.</p>

        <div class="alert alert-info mb-3" role="alert">
            <strong>Câmara no telemóvel:</strong> Os browsers só permitem acesso à câmara em <strong>HTTPS</strong> ou em <strong>localhost</strong>. Se abrir por <code>http://IP:8000</code> no telemóvel, a câmara não funciona. Para testar noutro dispositivo use um túnel HTTPS (ex.: <a href="https://ngrok.com" target="_blank" rel="noopener">ngrok</a>: instale, execute <code>ngrok http 8000</code> e abra o link <strong>https://</strong> no telemóvel).
        </div>

        <div id="result" class="alert d-none mb-3" role="alert"></div>
        <div id="reader" class="bg-dark rounded overflow-hidden" style="max-width: 100%;"></div>

        <p class="mt-2 small text-muted">Abra esta página no dispositivo que será usado como scanner (telefone ou tablet).</p>
    </div>
</div>

<script src="https://unpkg.com/html5-qrcode@2.3.8/html5-qrcode.min.js"></script>
<script>
(function() {
    const marcarUrl = '{{ route("admin.presenca-professor.marcar") }}';
    const token = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || '';

    const resultEl = document.getElementById('result');
    let lastScanned = '';
    let cooldownUntil = 0;

    function playBeep() {
        try {
            var ctx = new (window.AudioContext || window.webkitAudioContext)();
            var osc = ctx.createOscillator();
            var gain = ctx.createGain();
            osc.connect(gain);
            gain.connect(ctx.destination);
            osc.frequency.value = 800;
            osc.type = 'sine';
            gain.gain.setValueAtTime(0.25, ctx.currentTime);
            gain.gain.exponentialRampToValueAtTime(0.01, ctx.currentTime + 0.15);
            osc.start(ctx.currentTime);
            osc.stop(ctx.currentTime + 0.15);
        } catch (e) {}
    }

    function showResult(success, message) {
        resultEl.className = 'alert mb-3 ' + (success ? 'alert-success' : 'alert-danger');
        resultEl.textContent = message;
        resultEl.classList.remove('d-none');
        if (success) playBeep();
        setTimeout(function() { resultEl.classList.add('d-none'); }, 4000);
    }

    function onScanSuccess(decodedText) {
        const now = Date.now();
        if (decodedText === lastScanned && now < cooldownUntil) return;
        const match = /^P:(\d+)$/.exec(decodedText.trim());
        if (!match) {
            showResult(false, 'QR inválido. Use o crachá do professor.');
            return;
        }
        lastScanned = decodedText;
        cooldownUntil = now + 3000;

        fetch(marcarUrl, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json',
                'X-CSRF-TOKEN': token,
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: JSON.stringify({ codigo: decodedText })
        })
        .then(function(r) { return r.json().then(function(j) { return { ok: r.ok, json: j }; }); })
        .then(function(_ref) {
            var ok = _ref.ok, json = _ref.json;
            if (ok && json.success) {
                showResult(true, 'Presença registada: ' + (json.nome || 'OK'));
            } else {
                showResult(false, json.message || 'Erro ao registar presença.');
            }
        })
        .catch(function() {
            showResult(false, 'Erro de rede. Tente novamente.');
        });
    }

    function onScanFailure() {}

    var scanner = new Html5QrcodeScanner('reader', {
        fps: 10,
        qrbox: { width: 260, height: 260 },
        aspectRatio: 1
    }, false);
    scanner.render(onScanSuccess, onScanFailure);
})();
</script>
@endsection
