@extends('layouts.app')

@section('title', 'Recuperação de Senha - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">
                <i class="bi bi-key-fill text-warning me-2"></i>
                Recuperação de Senha
            </h5>
        </div>

        <div class="card mb-3">
            <div class="card-body">
                <form method="GET" action="{{ route('admin.password-reset.index') }}" class="row g-2">
                    <div class="col-md-10">
                        <input type="text" class="form-control form-control-sm" name="search" 
                               value="{{ $search ?? '' }}" 
                               placeholder="Pesquisar por nome, email, código de estudante ou número de funcionário...">
                    </div>
                    <div class="col-md-2">
                        <button type="submit" class="btn btn-sm btn-primary w-100">
                            <i class="bi bi-search"></i> Buscar
                        </button>
                    </div>
                    @if($search ?? false)
                        <div class="col-12">
                            <a href="{{ route('admin.password-reset.index') }}" class="btn btn-sm btn-secondary">
                                <i class="bi bi-x-circle"></i> Limpar
                            </a>
                        </div>
                    @endif
                </form>
            </div>
        </div>

        @if($users && $users->count() > 0)
            <div class="table-responsive">
                <table class="table table-sm table-bordered" style="font-size: 0.85rem;">
                    <thead style="background-color: #f8f9fa;">
                        <tr>
                            <th style="padding: 6px;">Nome</th>
                            <th style="padding: 6px;">Email</th>
                            <th style="padding: 6px;">Tipo</th>
                            <th style="padding: 6px;">Código/Número</th>
                            <th style="padding: 6px;">Status</th>
                            <th style="padding: 6px;">Acções</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($users as $user)
                            <tr>
                                <td style="padding: 5px;">{{ $user->name }}</td>
                                <td style="padding: 5px;">{{ $user->email }}</td>
                                <td style="padding: 5px;">
                                    @php
                                        $badgeColors = [
                                            'superadmin' => 'danger',
                                            'admin' => 'primary',
                                            'funcionario' => 'info',
                                            'professor' => 'success',
                                            'aluno' => 'warning',
                                        ];
                                        $badgeColor = $badgeColors[$user->tipo] ?? 'secondary';
                                        $tipoLabels = [
                                            'superadmin' => 'Superadmin',
                                            'admin' => 'Admin',
                                            'funcionario' => 'Funcionário',
                                            'professor' => 'Professor',
                                            'aluno' => 'Aluno',
                                        ];
                                        $tipoLabel = $tipoLabels[$user->tipo] ?? ucfirst($user->tipo);
                                    @endphp
                                    <span class="badge bg-{{ $badgeColor }}">{{ $tipoLabel }}</span>
                                </td>
                                <td style="padding: 5px;">
                                    @if($user->aluno)
                                        {{ $user->aluno->codigo_estudante }}
                                    @elseif($user->professor)
                                        {{ $user->professor->numero_funcionario }}
                                    @elseif($user->funcionario)
                                        {{ $user->funcionario->numero_funcionario }}
                                    @else
                                        -
                                    @endif
                                </td>
                                <td style="padding: 5px;">
                                    @if($user->is_active)
                                        <span class="badge bg-success">Activo</span>
                                    @else
                                        <span class="badge bg-danger">Inactivo</span>
                                    @endif
                                </td>
                                <td style="padding: 5px;">
                                    <a href="{{ route('admin.password-reset.show', $user) }}" 
                                       class="btn btn-sm btn-warning" 
                                       style="padding: 2px 6px; font-size: 0.75rem;" 
                                       title="Redefinir Senha">
                                        <i class="bi bi-key"></i> Redefinir
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @elseif($search ?? false)
            <div class="alert alert-info">
                <i class="bi bi-info-circle me-2"></i>
                Nenhum usuário encontrado com os critérios de busca.
            </div>
        @else
            <div class="alert alert-secondary">
                <i class="bi bi-info-circle me-2"></i>
                Use o campo de busca acima para encontrar usuários e redefinir suas senhas.
            </div>
        @endif
    </div>
</div>
@endsection

