@extends('layouts.app')

@section('title', 'Inscrições Pendentes - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Inscrições Pendentes</h5>
            <div class="badge bg-warning text-dark">
                {{ $inscricoes->total() }} pendente(s)
            </div>
        </div>

        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        <div class="table-responsive">
            <table class="table table-sm table-bordered" style="font-size: 0.85rem; margin-bottom: 0;">
                <thead style="background-color: #f8f9fa;">
                    <tr>
                        <th style="padding: 6px;">Código</th>
                        <th style="padding: 6px;">Nome</th>
                        <th style="padding: 6px;">Telefone</th>
                        <th style="padding: 6px;">Data Submissão</th>
                        <th style="padding: 6px;">Encarregado</th>
                        <th style="padding: 6px;">Contacto Encarregado</th>
                        <th style="padding: 6px;">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($inscricoes as $inscricao)
                        <tr>
                            <td style="padding: 5px;">{{ $inscricao->codigo_estudante ?? 'N/A' }}</td>
                            <td style="padding: 5px;">{{ $inscricao->user->name ?? 'N/A' }}</td>
                            <td style="padding: 5px;">{{ $inscricao->telefone ?? '-' }}</td>
                            <td style="padding: 5px;">
                                {{ $inscricao->data_submissao ? $inscricao->data_submissao->format('d/m/Y H:i') : '-' }}
                            </td>
                            <td style="padding: 5px;">{{ $inscricao->nome_encarregado ?? '-' }}</td>
                            <td style="padding: 5px;">{{ $inscricao->telefone_encarregado ?? '-' }}</td>
                            <td style="padding: 5px;">
                                <div style="display: flex; gap: 4px;">
                                    <a href="{{ route('admin.inscricoes.visualizar', $inscricao) }}" 
                                       class="btn btn-sm" 
                                       style="padding: 2px 6px; font-size: 0.75rem; background: #e7f3ff; color: #0066cc; border: none;" 
                                       title="Visualizar">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <button type="button" 
                                            class="btn btn-sm aprovar-btn" 
                                            data-id="{{ $inscricao->id }}"
                                            style="padding: 2px 6px; font-size: 0.75rem; background: #d4edda; color: #155724; border: none;" 
                                            title="Aprovar">
                                        <i class="bi bi-check-circle"></i>
                                    </button>
                                    <button type="button" 
                                            class="btn btn-sm rejeitar-btn" 
                                            data-id="{{ $inscricao->id }}"
                                            style="padding: 2px 6px; font-size: 0.75rem; background: #f8d7da; color: #721c24; border: none;" 
                                            title="Rejeitar">
                                        <i class="bi bi-x-circle"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center py-4">
                                <i class="bi bi-inbox" style="font-size: 2rem; color: #ccc;"></i>
                                <p class="text-muted mt-2 mb-0">Nenhuma inscrição pendente</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($inscricoes->hasPages())
            <div class="mt-3">
                {{ $inscricoes->links() }}
            </div>
        @endif
    </div>
</div>

<!-- Modal para Rejeitar -->
<div class="modal fade" id="modalRejeitar" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Rejeitar Inscrição</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="formRejeitar" method="POST">
                @csrf
                @method('POST')
                <div class="modal-body">
                    <p>Tem certeza que deseja rejeitar esta inscrição?</p>
                    <div class="mb-3">
                        <label for="observacoes_rejeitar" class="form-label">Observações <span class="text-danger">*</span></label>
                        <textarea class="form-control" id="observacoes_rejeitar" name="observacoes" rows="4" required minlength="10" placeholder="Explique o motivo da rejeição (mínimo 10 caracteres)"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-danger">Rejeitar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Aprovar inscrição
    document.querySelectorAll('.aprovar-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const id = this.getAttribute('data-id');
            if (confirm('Tem certeza que deseja aprovar esta inscrição?')) {
                fetch(`{{ url('admin/inscricoes') }}/${id}/aprovar`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                    },
                    body: JSON.stringify({})
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        alert(data.message);
                        location.reload();
                    }
                })
                .catch(error => {
                    console.error('Erro:', error);
                    alert('Erro ao aprovar inscrição');
                });
            }
        });
    });

    // Rejeitar inscrição
    document.querySelectorAll('.rejeitar-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const id = this.getAttribute('data-id');
            const form = document.getElementById('formRejeitar');
            form.action = `{{ url('admin/inscricoes') }}/${id}/rejeitar`;
            
            const modal = new bootstrap.Modal(document.getElementById('modalRejeitar'));
            modal.show();
        });
    });
});
</script>
@endsection
