@extends('layouts.app')

@section('title', 'Inscrições - SIGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Inscrições - Todos os Alunos</h5>
            <a href="{{ route('admin.inscricoes.renovados') }}" class="btn btn-sm btn-outline-success">Ver Renovados</a>
        </div>

        <form method="GET" action="{{ route('admin.inscricoes.index') }}" class="mb-2" style="display: flex; gap: 8px; align-items: end;">
            <select class="form-select form-select-sm" id="ano_letivo_id" name="ano_letivo_id" style="width: 150px;">
                <option value="">Todos os Anos</option>
                @foreach($anosLetivos as $ano)
                    <option value="{{ $ano->id }}" {{ $anoLetivoId == $ano->id ? 'selected' : '' }}>
                        @php
                            $anoFinal = strpos($ano->ano, '/') !== false ? explode('/', $ano->ano)[1] : $ano->ano;
                        @endphp
                        {{ $anoFinal }}
                        @if($ano->ativo) (Activo) @endif
                    </option>
                @endforeach
            </select>
            <input type="text" class="form-control form-control-sm" id="search" name="search" 
                   value="{{ request('search') }}" placeholder="Pesquisar..." style="flex: 1;">
            <button type="submit" class="btn btn-sm btn-primary">Filtrar</button>
            @if(request('search') || request('ano_letivo_id'))
                <a href="{{ route('admin.inscricoes.index') }}" class="btn btn-sm btn-secondary">Limpar</a>
            @endif
        </form>

        @if($anoLetivoSelecionado)
            @php
                $anoFinal = strpos($anoLetivoSelecionado->ano, '/') !== false ? explode('/', $anoLetivoSelecionado->ano)[1] : $anoLetivoSelecionado->ano;
            @endphp
            <div class="mb-2" style="font-size: 0.85rem; color: #6c757d;">
                Ano Lectivo: <strong>{{ $anoFinal }}</strong> | Total: <strong>{{ $alunosNaoRenovadosPaginated->total() }}</strong>
            </div>
        @endif

        <div class="js-ajax-pagination">
            <div class="table-responsive">
                <table class="table table-sm table-bordered" style="font-size: 0.85rem; margin-bottom: 0;">
                <thead style="background-color: #f8f9fa;">
                    <tr>
                        <th style="padding: 6px;">Código</th>
                        <th style="padding: 6px;">Nome</th>
                        <th style="padding: 6px;">Turma Anterior</th>
                        <th style="padding: 6px;">Classe</th>
                        <th style="padding: 6px;">Status</th>
                        <th style="padding: 6px;">Acções</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($alunosNaoRenovadosPaginated as $item)
                        @php
                            $aluno = $item['aluno'];
                            $turmaAnterior = $item['turma_anterior'];
                            $status = $item['status'];
                            $classeAtual = $turmaAnterior ? preg_match('/(\d+)/', $turmaAnterior->codigo, $matches) ? $matches[1] : 'N/A' : 'N/A';
                        @endphp
                        <tr>
                            <td style="padding: 5px;">{{ $aluno->codigo_estudante ?? 'N/A' }}</td>
                            <td style="padding: 5px;">{{ $aluno->user->name }}</td>
                            <td style="padding: 5px;">
                                @if($turmaAnterior)
                                    {{ $turmaAnterior->codigo }} - {{ $turmaAnterior->nome }}
                                @else
                                    <span style="color: #999;">Sem turma</span>
                                @endif
                            </td>
                            <td style="padding: 5px;">
                                @if($classeAtual != 'N/A')
                                    {{ $classeAtual }}ª Classe
                                @else
                                    <span style="color: #999;">-</span>
                                @endif
                            </td>
                            <td style="padding: 5px;">
                                @if($status == 'aprovado')
                                    <span style="font-size: 0.75rem; padding: 2px 6px; background: #d4edda; color: #155724; border-radius: 3px;">Aprovado</span>
                                @elseif($status == 'reprovado')
                                    <span style="font-size: 0.75rem; padding: 2px 6px; background: #f8d7da; color: #721c24; border-radius: 3px;">Reprovado</span>
                                @else
                                    <span style="font-size: 0.75rem; padding: 2px 6px; background: #e2e3e5; color: #383d41; border-radius: 3px;">Sem Avaliação</span>
                                @endif
                            </td>
                            <td style="padding: 5px;">
                                @if($anoLetivoId && $anoLetivoAtual && $anoLetivoAtual->id != $anoLetivoId)
                                    <a href="{{ route('admin.inscricoes.renovar', ['aluno' => $aluno, 'ano_letivo_anterior_id' => $anoLetivoId]) }}" 
                                       class="btn btn-sm" style="padding: 2px 8px; font-size: 0.75rem; background: #0d6efd; color: #fff; border: none; border-radius: 3px;">
                                        Renovar
                                    </a>
                                @else
                                    <span style="color: #999;">-</span>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center" style="padding: 20px; color: #6c757d;">
                                @if($anoLetivoSelecionado)
                                    Nenhum aluno não renovado encontrado.
                                @else
                                    Selecione um ano letivo de referência para ver os alunos.
                                @endif
                            </td>
                        </tr>
                    @endforelse
                </tbody>
                </table>
            </div>

            @if(method_exists($alunosNaoRenovadosPaginated, 'links'))
                <div class="mt-3">
                    {{ $alunosNaoRenovadosPaginated->appends(request()->query())->links() }}
                </div>
            @endif
        </div>

    </div>
</div>
@endsection
