@extends('layouts.app')

@section('title', 'Criar Funcionário - SGE')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header bg-primary-custom text-white py-2">
                <h5 class="mb-0">Criar Funcionário</h5>
            </div>
            <div class="card-body p-3">
                <form method="POST" action="{{ route('admin.funcionarios-servicos.store') }}">
                    @csrf

                    <div class="row g-2">
                        <div class="col-md-6">
                            <label for="nome" class="form-label small mb-0">Nome *</label>
                            <input type="text" class="form-control form-control-sm @error('nome') is-invalid @enderror"
                                   id="nome" name="nome" value="{{ old('nome') }}" required>
                            @error('nome')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            @include('admin.funcionarios-servicos._cargo_fields', ['cargoAtual' => old('cargo')])
                        </div>
                    </div>

                    <div class="row g-2 mt-1">
                        <div class="col-md-4">
                            <label for="salario_base" class="form-label small mb-0">Salário Base *</label>
                            <input type="number" step="0.01" min="0"
                                   class="form-control form-control-sm @error('salario_base') is-invalid @enderror"
                                   id="salario_base" name="salario_base" value="{{ old('salario_base', 0) }}" required>
                            @error('salario_base')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-4">
                            <label for="numero_dependentes" class="form-label small mb-0">Dependentes</label>
                            <input type="number" min="0"
                                   class="form-control form-control-sm @error('numero_dependentes') is-invalid @enderror"
                                   id="numero_dependentes" name="numero_dependentes" value="{{ old('numero_dependentes', 0) }}">
                            @error('numero_dependentes')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-4">
                            <label for="telefone" class="form-label small mb-0">Telefone</label>
                            <input type="text" class="form-control form-control-sm @error('telefone') is-invalid @enderror"
                                   id="telefone" name="telefone" value="{{ old('telefone') }}">
                            @error('telefone')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="row g-2 mt-1">
                        <div class="col-md-12">
                            <label for="endereco" class="form-label small mb-0">Endereço</label>
                            <input type="text" class="form-control form-control-sm @error('endereco') is-invalid @enderror"
                                   id="endereco" name="endereco" value="{{ old('endereco') }}">
                            @error('endereco')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="mt-3">
                        <button type="submit" class="btn btn-sm btn-primary-custom">Salvar</button>
                        <a href="{{ route('admin.funcionarios-servicos.index') }}" class="btn btn-sm btn-secondary">Cancelar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

