@php
    $cargosPadrao = ['ADMINISTRAÇÃO', 'LIMPEZA', 'SEGURANÇA', 'PORTARIA', 'MANUTENÇÃO', 'COZINHA', 'MOTORISTA', 'JARDINAGEM', 'OUTRO'];
    $cargoAtual = old('cargo', $cargoAtual ?? '');
    $cargoUpper = $cargoAtual ? mb_strtoupper(trim($cargoAtual)) : '';
    $cargoEhPadrao = $cargoUpper && in_array($cargoUpper, $cargosPadrao, true) && $cargoUpper !== 'OUTRO';
    $valorSelect = $cargoEhPadrao ? $cargoUpper : ($cargoAtual ? 'OUTRO' : '');
    $valorOutro = $cargoEhPadrao ? '' : $cargoAtual;
@endphp

<label class="form-label small mb-0">Cargo *</label>
<select class="form-select form-select-sm @error('cargo') is-invalid @enderror" 
        id="cargo_select">
    <option value="">-- Selecione um cargo --</option>
    @foreach($cargosPadrao as $cargo)
        <option value="{{ $cargo }}" {{ $valorSelect === $cargo ? 'selected' : '' }}>
            {{ $cargo }}
        </option>
    @endforeach
</select>
<input type="text" 
       class="form-control form-control-sm mt-2 @error('cargo') is-invalid @enderror" 
       id="cargo_outro" 
       value="{{ $valorOutro }}" 
       placeholder="Digite o cargo personalizado..." 
       style="{{ $valorSelect === 'OUTRO' ? '' : 'display:none;' }}">
<input type="hidden" id="cargo" name="cargo" value="{{ $cargoEhPadrao ? $cargoUpper : ($cargoAtual ?: '') }}">
@error('cargo')
    <div class="invalid-feedback small d-block">{{ $message }}</div>
@enderror

<script>
(function() {
    'use strict';
    
    function init() {
        const cargoSelect = document.getElementById('cargo_select');
        const cargoOutro = document.getElementById('cargo_outro');
        const cargoHidden = document.getElementById('cargo');
        
        if (!cargoSelect || !cargoOutro || !cargoHidden) return;
        
        // Inicializar com valor existente (para edição)
        const valorInicial = cargoHidden.value.trim();
        if (valorInicial) {
            const valorUpper = valorInicial.toUpperCase();
            const cargosPadrao = ['ADMINISTRAÇÃO', 'LIMPEZA', 'SEGURANÇA', 'PORTARIA', 'MANUTENÇÃO', 'COZINHA', 'MOTORISTA', 'JARDINAGEM', 'OUTRO'];
            
            if (cargosPadrao.includes(valorUpper) && valorUpper !== 'OUTRO') {
                cargoSelect.value = valorUpper;
                cargoOutro.style.display = 'none';
                cargoHidden.value = valorUpper;
            } else {
                cargoSelect.value = 'OUTRO';
                cargoOutro.style.display = '';
                cargoOutro.value = valorInicial;
                cargoHidden.value = valorInicial;
            }
        }
        
        function atualizarCargo() {
            const valorSelect = cargoSelect.value;
            
            if (valorSelect === 'OUTRO') {
                cargoOutro.style.display = '';
                const valorOutro = cargoOutro.value.trim();
                cargoHidden.value = valorOutro || '';
            } else if (valorSelect) {
                cargoOutro.style.display = 'none';
                cargoHidden.value = valorSelect;
            } else {
                cargoOutro.style.display = 'none';
                cargoHidden.value = '';
            }
        }
        
        cargoSelect.addEventListener('change', function() {
            atualizarCargo();
            if (cargoSelect.value === 'OUTRO') {
                setTimeout(() => cargoOutro.focus(), 50);
            }
        });
        
        cargoOutro.addEventListener('input', atualizarCargo);
        cargoOutro.addEventListener('blur', atualizarCargo);
        
        const form = cargoSelect.closest('form');
        if (form) {
            form.addEventListener('submit', function(e) {
                // Forçar atualização antes do submit
                atualizarCargo();
                
                // Garantir valor final
                const valorFinal = cargoSelect.value === 'OUTRO' 
                    ? cargoOutro.value.trim() 
                    : (cargoSelect.value || '');
                
                cargoHidden.value = valorFinal;
                
                // Validar
                if (!valorFinal) {
                    e.preventDefault();
                    e.stopPropagation();
                    alert('Por favor, selecione ou digite um cargo.');
                    if (cargoSelect.value === 'OUTRO') {
                        cargoOutro.focus();
                    } else {
                        cargoSelect.focus();
                    }
                    return false;
                }
            }, true);
        }
    }
    
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', init);
    } else {
        init();
    }
})();
</script>

