@extends('layouts.app')

@section('title', 'Pagamentos de Funcionários - SIGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">
                <i class="bi bi-people text-success me-2"></i>
                Pagamentos de Funcionários
            </h4>
            <div class="btn-group">
                <form action="{{ route('admin.funcionario-payments.gerar-mes-seguinte') }}" method="POST" class="d-inline" onsubmit="return confirm('Deseja gerar os pagamentos do mês seguinte baseado nos pagamentos do mês atual?');">
                    @csrf
                    <input type="hidden" name="mes" value="{{ request('mes', date('m')) }}">
                    <input type="hidden" name="ano" value="{{ request('ano', date('Y')) }}">
                    <button type="submit" class="btn btn-warning btn-sm" title="Gerar Pagamentos do Mês Seguinte">
                        <i class="bi bi-calendar-plus me-1"></i> Gerar Mês Seguinte
                    </button>
                </form>

                <button type="button" class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#modalFolhaSalario" title="Download Folha de Salário">
                    <i class="bi bi-download me-1"></i> Download Folha
                </button>
                <button type="button" class="btn btn-info btn-sm" data-bs-toggle="modal" data-bs-target="#modalFolhaSalarioImprimir" title="Visualizar Folha de Salário">
                    <i class="bi bi-printer me-1"></i> Imprimir
                </button>

                <button type="button" class="btn btn-primary btn-sm" id="btn-novo-pagamento">
                    <i class="bi bi-plus-circle me-1"></i> Novo Pagamento
                </button>

                <form action="{{ route('admin.funcionario-payments.marcar-todos-pago') }}" method="POST" class="d-inline" id="form-marcar-todos-pago" style="display: none;">
                    @csrf
                    <input type="hidden" name="mes" value="{{ request('mes', '') }}">
                    <input type="hidden" name="ano" value="{{ request('ano', '') }}">
                    <input type="hidden" name="funcionario_id" value="{{ request('funcionario_id', '') }}">
                    <input type="hidden" name="status" value="{{ request('status', '') }}">
                </form>
                <button type="button" class="btn btn-success btn-sm" id="btn-marcar-todos-pago" title="Marcar todos os pagamentos pendentes como pagos">
                    <i class="bi bi-check-all me-1"></i> Marcar Todos como Pago
                </button>
            </div>
        </div>

        <!-- Filtros -->
        <div class="card mb-3">
            <div class="card-body">
                <form method="GET" action="{{ route('admin.funcionario-payments.index') }}" class="row g-2" id="filtros-form">
                    <div class="col-md-4">
                        <label for="funcionario_id" class="form-label small">Funcionário</label>
                        <select name="funcionario_id" id="funcionario_id" class="form-select form-select-sm">
                            <option value="">Todos</option>
                            @foreach($funcionarios as $func)
                                <option value="{{ $func->id }}" {{ request('funcionario_id') == $func->id ? 'selected' : '' }}>
                                    {{ $func->nome }} - {{ $func->cargo }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label for="mes" class="form-label small">Mês</label>
                        <select name="mes" id="mes" class="form-select form-select-sm">
                            <option value="">Todos</option>
                            @for($i = 1; $i <= 12; $i++)
                                <option value="{{ $i }}" {{ request('mes') == $i ? 'selected' : '' }}>
                                    {{ ['', 'Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'][$i] }}
                                </option>
                            @endfor
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label for="ano" class="form-label small">Ano</label>
                        <input type="number" name="ano" id="ano" class="form-control form-control-sm"
                               value="{{ request('ano', date('Y')) }}" min="2020" max="2100">
                    </div>
                    <div class="col-md-2">
                        <label for="status" class="form-label small">Status</label>
                        <select name="status" id="status" class="form-select form-select-sm">
                            <option value="">Todos</option>
                            <option value="PENDENTE" {{ request('status') == 'PENDENTE' ? 'selected' : '' }}>Pendente</option>
                            <option value="PAGO" {{ request('status') == 'PAGO' ? 'selected' : '' }}>Pago</option>
                            <option value="CANCELADO" {{ request('status') == 'CANCELADO' ? 'selected' : '' }}>Cancelado</option>
                        </select>
                    </div>
                    <div class="col-md-2 d-flex align-items-end gap-2">
                        <button type="button" class="btn btn-primary btn-sm" id="btn-filtrar">
                            <i class="bi bi-search me-1"></i> Filtrar
                        </button>
                        <a href="{{ route('admin.funcionario-payments.index') }}" class="btn btn-secondary btn-sm" id="btn-limpar">
                            <i class="bi bi-x-circle me-1"></i> Limpar
                        </a>
                    </div>
                </form>
            </div>
        </div>

        <!-- Tabela -->
        <div class="card">
            <div class="card-body">
                <div id="loading-payments" class="text-center py-4" style="display: none;">
                    <div class="spinner-border text-success" role="status">
                        <span class="visually-hidden">Carregando...</span>
                    </div>
                    <p class="mt-2">Carregando pagamentos...</p>
                </div>

                <div id="payments-table-container">
                    @if($payments->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-sm table-hover" style="font-size: 0.85rem;" id="payments-table">
                                <thead>
                                    <tr>
                                        <th style="padding: 6px;">Funcionário</th>
                                        <th style="padding: 6px;">Mês/Ano</th>
                                        <th style="padding: 6px;">Dep.</th>
                                        <th style="padding: 6px;">Bruto</th>
                                        <th style="padding: 6px;">INSS</th>
                                        <th style="padding: 6px;">IRPS</th>
                                        <th style="padding: 6px;">Líquido</th>
                                        <th style="padding: 6px;">Status</th>
                                        <th style="padding: 6px;">Data</th>
                                        <th style="padding: 6px;">Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Linha para criar novo pagamento (sem horas/valor-hora) -->
                                    <tr class="table-info" id="linha-novo-pagamento" style="display: none;">
                                        <td style="padding: 5px;">
                                            <select class="form-select form-select-sm novo-pagamento-funcionario" style="width: 220px; font-size: 0.85rem;">
                                                <option value="">Selecione...</option>
                                                @foreach($funcionarios as $func)
                                                    <option value="{{ $func->id }}"
                                                            data-dependentes="{{ $func->numero_dependentes ?? 0 }}"
                                                            data-salario-base="{{ $func->salario_base ?? 0 }}">
                                                        {{ $func->nome }} - {{ $func->cargo }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </td>
                                        <td style="padding: 5px;">
                                            <div style="display:flex; gap:4px;">
                                                <select class="form-select form-select-sm novo-pagamento-mes" style="width: 90px; font-size: 0.85rem;">
                                                    @for($i = 1; $i <= 12; $i++)
                                                        <option value="{{ $i }}" {{ date('m') == $i ? 'selected' : '' }}>
                                                            {{ ['', 'Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'][$i] }}
                                                        </option>
                                                    @endfor
                                                </select>
                                                <input type="number" class="form-control form-control-sm novo-pagamento-ano"
                                                       value="{{ date('Y') }}" min="2020" max="2100"
                                                       style="width: 80px; font-size: 0.85rem;">
                                            </div>
                                        </td>
                                        <td style="padding: 5px;">
                                            <span class="badge bg-secondary novo-pagamento-dependentes">0</span>
                                        </td>
                                        <td style="padding: 5px;">
                                            <input type="number"
                                                   class="form-control form-control-sm novo-pagamento-valor-bruto"
                                                   min="0" step="0.01" placeholder="0.00"
                                                   style="width: 120px; font-size: 0.85rem; padding: 2px 6px; font-weight: 600;">
                                        </td>
                                        <td style="padding: 5px;"><span class="text-info novo-pagamento-inss">0,00</span></td>
                                        <td style="padding: 5px;"><span class="text-warning novo-pagamento-irps">0,00</span></td>
                                        <td style="padding: 5px;"><strong class="text-success novo-pagamento-liquido">0,00</strong></td>
                                        <td style="padding: 5px;"><span class="badge bg-warning" style="font-size:0.75rem;">Pendente</span></td>
                                        <td style="padding: 5px;"><span class="text-muted">-</span></td>
                                        <td style="padding: 5px;">
                                            <div class="btn-group btn-group-sm">
                                                <button type="button" class="btn btn-success btn-sm salvar-novo-pagamento" title="Salvar" style="padding: 2px 5px; font-size: 0.7rem;">
                                                    <i class="bi bi-check-circle"></i>
                                                </button>
                                                <button type="button" class="btn btn-secondary btn-sm cancelar-novo-pagamento" title="Cancelar" style="padding: 2px 5px; font-size: 0.7rem;">
                                                    <i class="bi bi-x-circle"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>

                                    @foreach($payments as $payment)
                                        @php
                                            $mesesAbrev = ['', 'Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'];
                                            $anoAbrev = substr($payment->ano, -2);
                                            $deps = $payment->funcionarioServico ? ($payment->funcionarioServico->numero_dependentes ?? 0) : 0;
                                        @endphp
                                        <tr style="font-size: 0.85rem;">
                                            <td style="padding: 5px;">
                                                @if($payment->funcionarioServico)
                                                    <div style="font-size: 0.85rem;">{{ $payment->funcionarioServico->nome }}</div>
                                                    <small class="text-muted" style="font-size: 0.75rem;">{{ $payment->funcionarioServico->cargo }}</small>
                                                @else
                                                    <div class="text-danger" style="font-size: 0.85rem;">Funcionário eliminado</div>
                                                    <small class="text-muted" style="font-size: 0.75rem;">ID: {{ $payment->funcionario_servico_id }}</small>
                                                @endif
                                            </td>
                                            <td style="padding: 5px;">{{ $mesesAbrev[$payment->mes] }}/{{ $anoAbrev }}</td>
                                            <td style="padding: 5px;"><span class="badge bg-secondary">{{ $deps }}</span></td>
                                            <td style="padding: 5px;">
                                                @if($payment->status !== 'PAGO')
                                                    <input type="number" class="form-control form-control-sm editar-valor-bruto"
                                                           data-payment-id="{{ $payment->id }}"
                                                           value="{{ number_format($payment->valor_total, 2, '.', '') }}"
                                                           min="0" step="0.01"
                                                           style="width: 120px; font-size: 0.8rem; padding: 2px 4px; font-weight: 600;">
                                                @else
                                                    <strong style="font-size: 0.85rem;">{{ number_format($payment->valor_total, 2, ',', '.') }}</strong>
                                                @endif
                                            </td>
                                            <td style="padding: 5px;"><span class="text-info valor-inss" data-payment-id="{{ $payment->id }}">{{ number_format($payment->inss ?? 0, 2, ',', '.') }}</span></td>
                                            <td style="padding: 5px;"><span class="text-warning valor-irps" data-payment-id="{{ $payment->id }}">{{ number_format($payment->irps ?? 0, 2, ',', '.') }}</span></td>
                                            <td style="padding: 5px;"><strong class="text-success valor-liquido" data-payment-id="{{ $payment->id }}">{{ number_format($payment->valor_liquido ?? 0, 2, ',', '.') }}</strong></td>
                                            <td style="padding: 5px;">
                                                @if($payment->status === 'PAGO')
                                                    <span class="badge bg-success" style="font-size: 0.75rem;">Pago</span>
                                                @elseif($payment->status === 'CANCELADO')
                                                    <span class="badge bg-danger" style="font-size: 0.75rem;">Cancelado</span>
                                                @else
                                                    <span class="badge bg-warning" style="font-size: 0.75rem;">Pendente</span>
                                                @endif
                                            </td>
                                            <td style="padding: 5px; font-size: 0.85rem;">
                                                @if($payment->data_pagamento)
                                                    {{ \Carbon\Carbon::parse($payment->data_pagamento)->format('d/m/y') }}
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td style="padding: 5px;">
                                                @if($payment->status === 'PENDENTE')
                                                    <form action="{{ route('admin.funcionario-payments.marcar-pago', $payment) }}" method="POST" class="d-inline marcar-pago-form">
                                                        @csrf
                                                        <button type="submit" class="btn btn-success btn-sm" title="Marcar como pago" style="padding: 2px 5px; font-size: 0.7rem;">
                                                            <i class="bi bi-check-circle"></i>
                                                        </button>
                                                    </form>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="alert alert-info text-center mb-0">
                            <i class="bi bi-info-circle me-2"></i>
                            Nenhum pagamento encontrado.
                        </div>
                    @endif
                </div>

                {{-- Paginação fora do container re-renderizado via AJAX --}}
                <div class="mt-3" id="pagination-container">
                    @if($payments->hasPages())
                        {{ $payments->appends(request()->query())->links() }}
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const updateTimeouts = {};

    function obterPaginaAtual() {
        const paginationContainer = document.getElementById('pagination-container');
        if (paginationContainer) {
            const active = paginationContainer.querySelector('.page-item.active .page-link, .pagination .active');
            if (active) {
                const p = parseInt(active.textContent.trim());
                if (p && !isNaN(p)) return p;
            }
        }
        const urlParams = new URLSearchParams(window.location.search);
        return parseInt(urlParams.get('page')) || 1;
    }

    function carregarPagamentos(page = 1) {
        const loading = document.getElementById('loading-payments');
        const container = document.getElementById('payments-table-container');
        const paginationContainer = document.getElementById('pagination-container');
        const formFiltros = document.getElementById('filtros-form');
        if (!container || !formFiltros) return;

        const params = new URLSearchParams();
        const funcionarioId = document.getElementById('funcionario_id');
        const mes = document.getElementById('mes');
        const ano = document.getElementById('ano');
        const status = document.getElementById('status');

        if (funcionarioId && funcionarioId.value) params.append('funcionario_id', funcionarioId.value);
        if (mes && mes.value) params.append('mes', mes.value);
        if (ano && ano.value) params.append('ano', ano.value);
        if (status && status.value) params.append('status', status.value);
        if (page && page > 1) params.append('page', page);

        if (loading) loading.style.display = 'block';
        container.style.opacity = '0.5';
        if (paginationContainer) paginationContainer.style.display = 'none';

        fetch('{{ route("admin.funcionario-payments.index") }}?' + params.toString(), {
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            }
        })
        .then(r => r.json())
        .then(data => {
            if (!data.success) throw new Error(data.message || 'Erro ao carregar dados');
            renderizarTabela(data.payments, data.funcionarios);
            if (data.pagination) atualizarPaginacao(data.pagination);
        })
        .catch(err => {
            console.error(err);
            alert('Erro ao carregar pagamentos.');
        })
        .finally(() => {
            if (loading) loading.style.display = 'none';
            container.style.opacity = '1';
            if (paginationContainer) paginationContainer.style.display = 'block';
        });
    }

    function renderizarTabela(payments, funcionarios) {
        const container = document.getElementById('payments-table-container');
        if (!container) return;

        if (!payments || payments.length === 0) {
            container.innerHTML = '<div class="alert alert-info text-center mb-0"><i class="bi bi-info-circle me-2"></i>Nenhum pagamento encontrado.</div>';
            return;
        }

        const csrf = '{{ csrf_token() }}';
        let html = '<div class="table-responsive">';
        html += '<table class="table table-sm table-hover" style="font-size: 0.85rem;" id="payments-table">';
        html += '<thead><tr>';
        html += '<th style="padding:6px;">Funcionário</th>';
        html += '<th style="padding:6px;">Mês/Ano</th>';
        html += '<th style="padding:6px;">Dep.</th>';
        html += '<th style="padding:6px;">Bruto</th>';
        html += '<th style="padding:6px;">INSS</th>';
        html += '<th style="padding:6px;">IRPS</th>';
        html += '<th style="padding:6px;">Líquido</th>';
        html += '<th style="padding:6px;">Status</th>';
        html += '<th style="padding:6px;">Data</th>';
        html += '<th style="padding:6px;">Ações</th>';
        html += '</tr></thead><tbody>';

        payments.forEach(p => {
            const podeEditar = p.status !== 'PAGO';
            const statusClass = p.status === 'PAGO' ? 'bg-success' : (p.status === 'CANCELADO' ? 'bg-danger' : 'bg-warning');
            const statusText = p.status === 'PAGO' ? 'Pago' : (p.status === 'CANCELADO' ? 'Cancelado' : 'Pendente');

            html += `<tr style="font-size:0.85rem;">`;
            html += `<td style="padding:5px;"><div style="font-size:0.85rem;">${p.funcionario_nome}</div><small class="text-muted" style="font-size:0.75rem;">${p.funcionario_codigo} • ${p.cargo}</small></td>`;
            html += `<td style="padding:5px;">${p.mes_abrev}/${p.ano_abrev}</td>`;
            html += `<td style="padding:5px;"><span class="badge bg-secondary">${p.numero_dependentes ?? 0}</span></td>`;

            html += `<td style="padding:5px;">`;
            if (podeEditar) {
                html += `<input type="number" class="form-control form-control-sm editar-valor-bruto" data-payment-id="${p.id}" value="${parseFloat(p.valor_total).toFixed(2)}" min="0" step="0.01" style="width:120px; font-size:0.8rem; padding:2px 4px; font-weight:600;">`;
            } else {
                html += `<strong style="font-size:0.85rem;">${parseFloat(p.valor_total).toFixed(2).replace('.', ',')}</strong>`;
            }
            html += `</td>`;

            html += `<td style="padding:5px;"><span class="text-info valor-inss" data-payment-id="${p.id}">${parseFloat(p.inss).toFixed(2).replace('.', ',')}</span></td>`;
            html += `<td style="padding:5px;"><span class="text-warning valor-irps" data-payment-id="${p.id}">${parseFloat(p.irps).toFixed(2).replace('.', ',')}</span></td>`;
            html += `<td style="padding:5px;"><strong class="text-success valor-liquido" data-payment-id="${p.id}">${parseFloat(p.valor_liquido).toFixed(2).replace('.', ',')}</strong></td>`;
            html += `<td style="padding:5px;"><span class="badge ${statusClass}" style="font-size:0.75rem;">${statusText}</span></td>`;
            html += `<td style="padding:5px; font-size:0.85rem;">${p.data_pagamento ? p.data_pagamento : '<span class="text-muted">-</span>'}</td>`;

            html += `<td style="padding:5px;">`;
            if (p.status === 'PENDENTE') {
                const urlMarcar = '{{ route("admin.funcionario-payments.marcar-pago", ":id") }}'.replace(':id', p.id);
                html += `<form action="${urlMarcar}" method="POST" class="d-inline marcar-pago-form"><input type="hidden" name="_token" value="${csrf}"><button type="submit" class="btn btn-success btn-sm" title="Marcar como pago" style="padding:2px 5px; font-size:0.7rem;"><i class="bi bi-check-circle"></i></button></form>`;
            } else {
                html += `<span class="text-muted">-</span>`;
            }
            html += `</td>`;
            html += `</tr>`;
        });

        html += '</tbody></table></div>';
        container.innerHTML = html;
    }

    function atualizarPaginacao(pagination) {
        const paginationContainer = document.getElementById('pagination-container');
        if (!paginationContainer || !pagination) return;
        if (pagination.last_page <= 1) {
            paginationContainer.innerHTML = '';
            return;
        }

        let html = '<nav><ul class="pagination pagination-sm justify-content-center mb-0">';

        if (pagination.current_page > 1) {
            html += `<li class="page-item"><a class="page-link pagination-link" href="#" data-page="${pagination.current_page - 1}">Anterior</a></li>`;
        } else {
            html += '<li class="page-item disabled"><span class="page-link">Anterior</span></li>';
        }

        const startPage = Math.max(1, pagination.current_page - 2);
        const endPage = Math.min(pagination.last_page, pagination.current_page + 2);

        if (startPage > 1) {
            html += `<li class="page-item"><a class="page-link pagination-link" href="#" data-page="1">1</a></li>`;
            if (startPage > 2) html += '<li class="page-item disabled"><span class="page-link">...</span></li>';
        }

        for (let i = startPage; i <= endPage; i++) {
            if (i === pagination.current_page) {
                html += `<li class="page-item active"><span class="page-link">${i}</span></li>`;
            } else {
                html += `<li class="page-item"><a class="page-link pagination-link" href="#" data-page="${i}">${i}</a></li>`;
            }
        }

        if (endPage < pagination.last_page) {
            if (endPage < pagination.last_page - 1) html += '<li class="page-item disabled"><span class="page-link">...</span></li>';
            html += `<li class="page-item"><a class="page-link pagination-link" href="#" data-page="${pagination.last_page}">${pagination.last_page}</a></li>`;
        }

        if (pagination.current_page < pagination.last_page) {
            html += `<li class="page-item"><a class="page-link pagination-link" href="#" data-page="${pagination.current_page + 1}">Próximo</a></li>`;
        } else {
            html += '<li class="page-item disabled"><span class="page-link">Próximo</span></li>';
        }

        html += '</ul></nav>';
        html += `<div class="text-center mt-2" style="font-size:0.85rem; color:#666;">Mostrando ${((pagination.current_page - 1) * pagination.per_page) + 1} a ${Math.min(pagination.current_page * pagination.per_page, pagination.total)} de ${pagination.total} registros</div>`;
        paginationContainer.innerHTML = html;
    }

    function atualizarPagamento(paymentId) {
        const valorBrutoInput = document.querySelector('.editar-valor-bruto[data-payment-id="' + paymentId + '"]');
        if (!valorBrutoInput) return;
        const valorTotal = parseFloat(valorBrutoInput.value) || 0;
        if (valorTotal <= 0) return;

        valorBrutoInput.disabled = true;

        fetch('{{ route("admin.funcionario-payments.update", ":id") }}'.replace(':id', paymentId), {
            method: 'PUT',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Accept': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: JSON.stringify({ valor_total: valorTotal })
        })
        .then(r => r.json())
        .then(data => {
            if (!data.success) throw new Error(data.message || 'Erro ao atualizar');
            const inssEl = document.querySelector('.valor-inss[data-payment-id="' + paymentId + '"]');
            const irpsEl = document.querySelector('.valor-irps[data-payment-id="' + paymentId + '"]');
            const liqEl = document.querySelector('.valor-liquido[data-payment-id="' + paymentId + '"]');
            if (inssEl) inssEl.textContent = parseFloat(data.inss).toFixed(2).replace('.', ',');
            if (irpsEl) irpsEl.textContent = parseFloat(data.irps).toFixed(2).replace('.', ',');
            if (liqEl) liqEl.textContent = parseFloat(data.valor_liquido).toFixed(2).replace('.', ',');
        })
        .catch(err => {
            console.error(err);
            alert('Erro ao atualizar pagamento.');
            carregarPagamentos(obterPaginaAtual());
        })
        .finally(() => {
            valorBrutoInput.disabled = false;
        });
    }

    function configurarEventDelegation() {
        const container = document.getElementById('payments-table-container');
        if (!container) return;

        container.addEventListener('input', function(e) {
            if (e.target.classList.contains('editar-valor-bruto')) {
                const paymentId = e.target.getAttribute('data-payment-id');
                if (updateTimeouts[paymentId]) clearTimeout(updateTimeouts[paymentId]);
                updateTimeouts[paymentId] = setTimeout(() => atualizarPagamento(paymentId), 1200);
            }
        });

        container.addEventListener('submit', function(e) {
            if (e.target.classList.contains('marcar-pago-form')) {
                e.preventDefault();
                const form = e.target;
                fetch(form.action, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'Accept': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: JSON.stringify({})
                })
                .then(r => r.json())
                .then(data => {
                    if (data.success) {
                        carregarPagamentos(obterPaginaAtual());
                    } else {
                        alert(data.message || 'Não foi possível marcar como pago.');
                    }
                })
                .catch(() => alert('Erro ao marcar como pago.'));
            }
        });
    }

    // Prevenir submit normal
    const formFiltros = document.getElementById('filtros-form');
    if (formFiltros) {
        formFiltros.addEventListener('submit', function(e) {
            e.preventDefault();
            carregarPagamentos(1);
            return false;
        }, true);
    }

    // Botões filtros
    const btnFiltrar = document.getElementById('btn-filtrar');
    const btnLimpar = document.getElementById('btn-limpar');
    if (btnFiltrar) btnFiltrar.addEventListener('click', e => { e.preventDefault(); carregarPagamentos(1); });
    if (btnLimpar) btnLimpar.addEventListener('click', e => { e.preventDefault(); document.getElementById('funcionario_id').value=''; document.getElementById('mes').value=''; document.getElementById('ano').value=''; document.getElementById('status').value=''; carregarPagamentos(1); });
    ['funcionario_id','mes','ano','status'].forEach(id => {
        const el = document.getElementById(id);
        if (el) el.addEventListener('change', () => carregarPagamentos(1));
    });

    // Novo pagamento
    const btnNovoPagamento = document.getElementById('btn-novo-pagamento');
    const linhaNovo = document.getElementById('linha-novo-pagamento');
    if (btnNovoPagamento && linhaNovo) {
        btnNovoPagamento.addEventListener('click', () => {
            linhaNovo.style.display = linhaNovo.style.display === 'none' ? '' : 'none';
        });
    }
    if (linhaNovo) {
        const selFunc = linhaNovo.querySelector('.novo-pagamento-funcionario');
        const brutoInput = linhaNovo.querySelector('.novo-pagamento-valor-bruto');
        const depsBadge = linhaNovo.querySelector('.novo-pagamento-dependentes');
        const inssEl = linhaNovo.querySelector('.novo-pagamento-inss');
        const irpsEl = linhaNovo.querySelector('.novo-pagamento-irps');
        const liqEl = linhaNovo.querySelector('.novo-pagamento-liquido');

        if (selFunc) {
            selFunc.addEventListener('change', () => {
                const opt = selFunc.options[selFunc.selectedIndex];
                const deps = opt ? parseInt(opt.getAttribute('data-dependentes') || '0') : 0;
                if (depsBadge) depsBadge.textContent = deps;
            });
        }

        function calcLocal() {
            const bruto = parseFloat(brutoInput?.value) || 0;
            const inss = bruto * 0.03;
            const irps = 0; // IRPS real vem do servidor no POST
            const liq = bruto - inss - irps;
            if (inssEl) inssEl.textContent = inss.toFixed(2).replace('.', ',');
            if (irpsEl) irpsEl.textContent = irps.toFixed(2).replace('.', ',');
            if (liqEl) liqEl.textContent = liq.toFixed(2).replace('.', ',');
        }
        if (brutoInput) brutoInput.addEventListener('input', calcLocal);

        const btnCancelar = linhaNovo.querySelector('.cancelar-novo-pagamento');
        if (btnCancelar) btnCancelar.addEventListener('click', () => {
            linhaNovo.style.display = 'none';
            if (selFunc) selFunc.value = '';
            if (brutoInput) brutoInput.value = '';
            if (depsBadge) depsBadge.textContent = '0';
            if (inssEl) inssEl.textContent = '0,00';
            if (irpsEl) irpsEl.textContent = '0,00';
            if (liqEl) liqEl.textContent = '0,00';
        });

        const btnSalvar = linhaNovo.querySelector('.salvar-novo-pagamento');
        if (btnSalvar) {
            btnSalvar.addEventListener('click', function() {
                const funcionarioId = selFunc?.value;
                const mes = linhaNovo.querySelector('.novo-pagamento-mes')?.value;
                const ano = linhaNovo.querySelector('.novo-pagamento-ano')?.value;
                const valorTotal = parseFloat(brutoInput?.value) || 0;
                if (!funcionarioId || !mes || !ano || valorTotal <= 0) {
                    alert('Preencha funcionário, mês, ano e valor bruto.');
                    return;
                }

                this.disabled = true;
                fetch('{{ route("admin.funcionario-payments.store") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'Accept': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: JSON.stringify({
                        funcionario_id: parseInt(funcionarioId),
                        mes: parseInt(mes),
                        ano: parseInt(ano),
                        valor_total: valorTotal
                    })
                })
                .then(r => r.json())
                .then(data => {
                    if (!data.success) throw new Error(data.message || 'Erro ao criar pagamento');
                    linhaNovo.style.display = 'none';
                    this.disabled = false;
                    carregarPagamentos(1);
                })
                .catch(err => {
                    console.error(err);
                    alert(err.message || 'Erro ao criar pagamento.');
                    this.disabled = false;
                });
            });
        }
    }

    // Marcar todos como pago (AJAX)
    const btnMarcarTodos = document.getElementById('btn-marcar-todos-pago');
    if (btnMarcarTodos) {
        btnMarcarTodos.addEventListener('click', function() {
            if (!confirm('Deseja marcar todos os pagamentos pendentes como pagos?\n\nEsta ação não pode ser desfeita.')) return;

            const params = new URLSearchParams();
            const funcionarioId = document.getElementById('funcionario_id')?.value;
            const mes = document.getElementById('mes')?.value;
            const ano = document.getElementById('ano')?.value;
            if (funcionarioId) params.append('funcionario_id', funcionarioId);
            if (mes) params.append('mes', mes);
            if (ano) params.append('ano', ano);

            fetch('{{ route("admin.funcionario-payments.marcar-todos-pago") }}' + (params.toString() ? ('?' + params.toString()) : ''), {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest'
                },
                body: JSON.stringify({})
            })
            .then(r => r.json())
            .then(data => {
                alert(data.message || 'Concluído.');
                carregarPagamentos(obterPaginaAtual());
            })
            .catch(() => alert('Erro ao marcar todos como pago.'));
        });
    }

    // Paginação (delegation)
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('pagination-link')) {
            e.preventDefault();
            const p = parseInt(e.target.getAttribute('data-page'));
            if (p) carregarPagamentos(p);
        }
        const link = e.target.closest('.pagination a');
        if (link && link.href && (link.href.includes('funcionario-payments') || link.href.includes('page='))) {
            e.preventDefault();
            const url = new URL(link.href);
            const p = parseInt(url.searchParams.get('page')) || 1;
            carregarPagamentos(p);
        }
    }, true);

    configurarEventDelegation();
});
</script>

<!-- Modal para Download Folha de Salário -->
<div class="modal fade" id="modalFolhaSalario" tabindex="-1" aria-labelledby="modalFolhaSalarioLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalFolhaSalarioLabel">
                    <i class="bi bi-download me-2"></i>Download Folha de Salário
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('admin.funcionario-payments.folha-salario') }}" method="GET" id="form-download-folha">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="folha_mes" class="form-label">Mês</label>
                        <select name="mes" id="folha_mes" class="form-select" required>
                            @for($i = 1; $i <= 12; $i++)
                                <option value="{{ $i }}" {{ (int)request('mes', date('m')) === $i ? 'selected' : '' }}>
                                    {{ ['', 'Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'][$i] }}
                                </option>
                            @endfor
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="folha_ano" class="form-label">Ano</label>
                        <input type="number" name="ano" id="folha_ano" class="form-control" 
                               value="{{ request('ano', date('Y')) }}" min="2020" max="2100" required>
                    </div>
                    <div class="mb-3">
                        <label for="folha_funcionario_id" class="form-label">Funcionário</label>
                        <select name="funcionario_id" id="folha_funcionario_id" class="form-select">
                            <option value="">Todos os Funcionários</option>
                            @foreach($funcionarios as $func)
                                <option value="{{ $func->id }}" {{ request('funcionario_id') == $func->id ? 'selected' : '' }}>
                                    {{ $func->nome }} - {{ $func->cargo }}
                                </option>
                            @endforeach
                        </select>
                        <small class="text-muted">Deixe em branco para gerar folha de todos os funcionários</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-success">
                        <i class="bi bi-download me-1"></i> Download
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal para Imprimir Folha de Salário -->
<div class="modal fade" id="modalFolhaSalarioImprimir" tabindex="-1" aria-labelledby="modalFolhaSalarioImprimirLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalFolhaSalarioImprimirLabel">
                    <i class="bi bi-printer me-2"></i>Imprimir Folha de Salário
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('admin.funcionario-payments.folha-salario.visualizar') }}" method="GET" target="_blank" id="form-imprimir-folha">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="imprimir_mes" class="form-label">Mês</label>
                        <select name="mes" id="imprimir_mes" class="form-select" required>
                            @for($i = 1; $i <= 12; $i++)
                                <option value="{{ $i }}" {{ (int)request('mes', date('m')) === $i ? 'selected' : '' }}>
                                    {{ ['', 'Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'][$i] }}
                                </option>
                            @endfor
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="imprimir_ano" class="form-label">Ano</label>
                        <input type="number" name="ano" id="imprimir_ano" class="form-control" 
                               value="{{ request('ano', date('Y')) }}" min="2020" max="2100" required>
                    </div>
                    <div class="mb-3">
                        <label for="imprimir_funcionario_id" class="form-label">Funcionário</label>
                        <select name="funcionario_id" id="imprimir_funcionario_id" class="form-select">
                            <option value="">Todos os Funcionários</option>
                            @foreach($funcionarios as $func)
                                <option value="{{ $func->id }}" {{ request('funcionario_id') == $func->id ? 'selected' : '' }}>
                                    {{ $func->nome }} - {{ $func->cargo }}
                                </option>
                            @endforeach
                        </select>
                        <small class="text-muted">Deixe em branco para imprimir folha de todos os funcionários</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-info">
                        <i class="bi bi-printer me-1"></i> Imprimir
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endpush
@endsection

