<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Boletim de Matrícula - {{ $configuracao['escola'] }}</title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
            font-family: 'Times New Roman', Times, serif;
        }
        
        @page {
            size: A4;
            margin: 15mm;
        }
        
        body {
            background-color: #f5f5f5;
            color: #333;
            line-height: 1.6;
            padding: 20px;
            max-width: 1000px;
            margin: 0 auto;
        }
        
        .document-container {
            background-color: white;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
            border: 1px solid #ddd;
            padding: 30px;
            position: relative;
        }
        
        .header {
            text-align: center;
            padding-bottom: 15px;
            margin-bottom: 25px;
        }
        
        .emblema-topo {
            display: flex;
            justify-content: center;
            margin-bottom: 20px;
        }
        
        .emblema {
            width: 100px;
            height: 100px;
            object-fit: contain;
        }
        
        .emblema-fallback {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            background: linear-gradient(135deg, #006600, #ffcc00, #ff0000, #000000, #ffffff);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 12px;
            text-align: center;
            padding: 10px;
            border: 2px solid #ddd;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
        }
        
        .republica {
            font-size: 18px;
            font-weight: bold;
            text-transform: uppercase;
            margin-bottom: 5px;
            color: #006600;
        }
        
        .provincia {
            font-size: 16px;
            font-weight: bold;
            margin-bottom: 5px;
            color: #006600;
        }
        
        .distrito {
            font-size: 15px;
            font-weight: bold;
            margin-bottom: 10px;
            color: #006600;
        }
        
        .escola {
            font-size: 18px;
            font-weight: bold;
            text-transform: uppercase;
            margin-bottom: 5px;
            color: #900;
        }
        
        .titulo {
            font-size: 20px;
            font-weight: bold;
            text-transform: uppercase;
            margin-top: 15px;
            padding: 10px;
            background-color: #f0f0f0;
            border: 1px solid #ccc;
            color: #000;
        }
        
        .foto-visto {
            display: flex;
            justify-content: space-between;
            margin: 25px 0;
            align-items: flex-start;
        }
        
        .foto-area {
            width: 150px;
            height: 180px;
            border: 2px solid #333;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: #f9f9f9;
            font-style: italic;
            color: #666;
            overflow: hidden;
        }
        
        .foto-area img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .visto-area {
            text-align: center;
            width: 200px;
            padding-top: 20px;
        }
        
        .visto-text {
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        .visto-line {
            border-top: 1px solid #333;
            width: 100%;
            margin-top: 40px;
        }
        
        .visto-assinatura {
            font-size: 14px;
            margin-top: 5px;
        }
        
        .form-section {
            margin-bottom: 25px;
        }
        
        .section-title {
            font-weight: bold;
            font-size: 16px;
            text-decoration: underline;
            margin-bottom: 15px;
            color: #006600;
        }
        
        .form-group {
            margin-bottom: 12px;
            display: flex;
            flex-wrap: wrap;
        }
        
        .form-label {
            width: 100%;
            margin-bottom: 5px;
            font-weight: bold;
        }
        
        .input-field {
            flex: 1;
            min-width: 200px;
            padding: 8px 10px;
            border: none;
            border-bottom: 1px solid #666;
            margin-right: 15px;
            margin-bottom: 8px;
            font-size: 15px;
            background-color: transparent;
        }
        
        .input-field:focus {
            outline: none;
            border-bottom: 2px solid #900;
        }
        
        .input-field-small {
            width: 80px;
        }
        
        .input-field-medium {
            width: 150px;
        }
        
        .input-group {
            display: flex;
            align-items: center;
            flex-wrap: wrap;
            gap: 5px;
        }
        
        .input-group span {
            white-space: nowrap;
        }
        
        .table-container {
            margin: 20px 0;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        th, td {
            border: 1px solid #333;
            padding: 10px;
            text-align: center;
        }
        
        th {
            background-color: #f0f0f0;
            font-weight: bold;
        }
        
        .declaracao {
            margin: 25px 0;
            padding: 15px;
            border: 1px solid #ccc;
            background-color: #f9f9f9;
            font-size: 15px;
            line-height: 1.7;
        }
        
        .assinaturas {
            display: flex;
            justify-content: space-between;
            margin-top: 40px;
            padding-top: 20px;
            border-top: 1px solid #333;
        }
        
        .assinatura-area {
            text-align: center;
            width: 45%;
        }
        
        .assinatura-line {
            border-top: 1px solid #333;
            width: 100%;
            margin-top: 40px;
        }
        
        .assinatura-label {
            margin-top: 5px;
            font-weight: bold;
        }
        
        .data-local {
            margin-top: 20px;
            font-style: italic;
        }
        
        @media print {
            body {
                background-color: white;
                padding: 0;
            }
            
            .document-container {
                box-shadow: none;
                border: none;
                padding: 20px;
            }
            
            .no-print {
                display: none;
            }
            
            .emblema {
                width: 80px;
                height: 80px;
            }
        }
        
        .print-btn {
            display: block;
            width: 200px;
            margin: 20px auto;
            padding: 10px 15px;
            background-color: #006600;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            text-align: center;
            transition: background-color 0.3s;
        }
        
        .print-btn:hover {
            background-color: #008800;
        }
        
        .emblema-container {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }
        
        .emblema-legenda {
            font-size: 12px;
            color: #666;
            margin-top: 5px;
            font-style: italic;
        }
    </style>
</head>
<body>
    <div class="document-container">
        <div class="header">
            <div class="emblema-topo">
                <div class="emblema-container">
                    <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRrnygkYHScEgMfdru0i6n-whqZS5e9mSPLwA&s" 
                         alt="Emblema da República de Moçambique" 
                         class="emblema"
                         onerror="this.style.display='none'; document.getElementById('emblema-fallback').style.display='flex';">
                    <div id="emblema-fallback" class="emblema-fallback" style="display: none;">
                        Emblema<br>Moçambique
                    </div>
                    <div class="emblema-legenda">República de Moçambique</div>
                </div>
            </div>
            
            <div class="republica">{{ $configuracao['republica'] }}</div>
            <div class="provincia">{{ $configuracao['provincia'] }}</div>
            <div class="distrito">{{ $configuracao['distrito'] }}</div>
            <div class="escola">{{ $configuracao['escola'] }}</div>
            <div class="titulo">BOLETIM DE MATRÍCULA/INSCRIÇÕES DE ALUNOS INTERNOS</div>
        </div>
        
        <div class="foto-visto">
            <div class="foto-area">
                @if($aluno->foto)
                    <img src="{{ asset('storage/' . $aluno->foto) }}" style="width: 100%; height: 100%; object-fit: cover;">
                @else
                    Foto do Aluno
                @endif
            </div>
            
            <div class="visto-area">
                <div class="visto-text">Visto do diretor da escola</div>
                <div class="visto-line"></div>
                <div class="visto-assinatura">Diretor da Escola</div>
            </div>
        </div>
        
        <div class="form-section">
            <div class="section-title">DADOS DO ALUNO</div>
            
            <div class="form-group">
                <label class="form-label">Nome do aluno (a)</label>
                <div class="input-field" style="border-bottom: 1px solid #333; padding: 8px 10px;">{{ $aluno->user->name }}</div>
            </div>
            
            <div class="form-group">
                <div class="input-group">
                    <span>nascido (a)</span>
                    <div class="input-field" style="border-bottom: 1px solid #333; padding: 8px 10px;">{{ $aluno->local_nascimento ?? '________________' }}</div>
                    <span>aos</span>
                    <div class="input-field-small" style="border-bottom: 1px solid #333; padding: 8px 10px; text-align: center;">{{ $aluno->data_nascimento ? $aluno->data_nascimento->format('d') : '___' }}</div>
                    <span>/</span>
                    <div class="input-field-small" style="border-bottom: 1px solid #333; padding: 8px 10px; text-align: center;">{{ $aluno->data_nascimento ? $aluno->data_nascimento->format('m') : '___' }}</div>
                    <span>/</span>
                    <div class="input-field-medium" style="border-bottom: 1px solid #333; padding: 8px 10px; text-align: center;">{{ $aluno->data_nascimento ? $aluno->data_nascimento->format('Y') : '____' }}</div>
                </div>
            </div>
            
            <div class="form-group">
                <div class="input-group">
                    <span>natural de</span>
                    <div class="input-field" style="border-bottom: 1px solid #333; padding: 8px 10px;">{{ $aluno->naturalidade ?? '________________' }}</div>
                    <span>, distrito de</span>
                    <div class="input-field" style="border-bottom: 1px solid #333; padding: 8px 10px;">{{ $aluno->distrito_natural ?? '________________' }}</div>
                    <span>província de</span>
                    <div class="input-field" style="border-bottom: 1px solid #333; padding: 8px 10px;">{{ $aluno->provincia_natural ?? '________________' }}</div>
                </div>
            </div>
            
            <div class="form-group">
                <div class="input-group">
                    <span>portador de {{ $aluno->tipo_documento ?? 'BI ou cédula pessoal' }} nº</span>
                    <div class="input-field-medium" style="border-bottom: 1px solid #333; padding: 8px 10px; text-align: center;">{{ $aluno->num_documento ?? '________________' }}</div>
                    <span>emitido em</span>
                    <div class="input-field" style="border-bottom: 1px solid #333; padding: 8px 10px;">{{ $aluno->local_emissao ?? '________________' }}</div>
                    <span>aos</span>
                    <div class="input-field-small" style="border-bottom: 1px solid #333; padding: 8px 10px; text-align: center;">{{ $aluno->data_emissao ? $aluno->data_emissao->format('d') : '___' }}</div>
                    <span>/</span>
                    <div class="input-field-small" style="border-bottom: 1px solid #333; padding: 8px 10px; text-align: center;">{{ $aluno->data_emissao ? $aluno->data_emissao->format('m') : '___' }}</div>
                    <span>/</span>
                    <div class="input-field-medium" style="border-bottom: 1px solid #333; padding: 8px 10px; text-align: center;">{{ $aluno->data_emissao ? $aluno->data_emissao->format('Y') : '____' }}</div>
                </div>
            </div>
            
            <div class="form-group">
                <div class="input-group">
                    <span>filho de</span>
                    <div class="input-field" style="border-bottom: 1px solid #333; padding: 8px 10px;">{{ $aluno->nome_pai ?? '________________' }}</div>
                    <span>e de</span>
                    <div class="input-field" style="border-bottom: 1px solid #333; padding: 8px 10px;">{{ $aluno->nome_mae ?? '________________' }}</div>
                    <span>.</span>
                </div>
            </div>
        </div>
        
        <div class="form-section">
            <div class="section-title">DADOS DE ENCARREGADO DE EDUCAÇÃO</div>
            
            <div class="form-group">
                <div class="input-group">
                    <span>Nome de encarregado de educação</span>
                    <div class="input-field" style="border-bottom: 1px solid #333; padding: 8px 10px;">{{ $aluno->nome_encarregado ?? '________________' }}</div>
                    <span>residente em</span>
                    <div class="input-field" style="border-bottom: 1px solid #333; padding: 8px 10px;">{{ $aluno->endereco_encarregado ?? '________________' }}</div>
                </div>
            </div>
            
            <div class="form-group">
                <div class="input-group">
                    <span>profissão</span>
                    <div class="input-field" style="border-bottom: 1px solid #333; padding: 8px 10px;">{{ $aluno->profissao_encarregado ?? '________________' }}</div>
                    <span>, contacto</span>
                    <div class="input-field" style="border-bottom: 1px solid #333; padding: 8px 10px;">{{ $aluno->telefone_encarregado ?? '________________' }}</div>
                    <span>.</span>
                </div>
            </div>
        </div>
        
        <div class="declaracao">
            Na qualidade de encarregado de educação do aluno acima citado, confirmo a veracidade dos dados e desejo inscrever/matricular o meu encarregando (a) neste estabelecimento de ensino.
        </div>
        
        <div class="table-container">
            <table>
                <tr>
                    <th>Classe</th>
                    <th>Turma</th>
                </tr>
                <tr>
                    <td>
                        @php
                            $turmaAtual = $aluno->turmas()->wherePivot('ano_letivo_id', \App\Models\AnoLetivo::where('ativo', true)->first()?->id)->first();
                        @endphp
                        {{ $turmaAtual ? $turmaAtual->codigo : '________________' }}
                    </td>
                    <td>{{ $turmaAtual ? 'Turma ' . $turmaAtual->nome : '________________' }}</td>
                </tr>
            </table>
        </div>
        
        <div class="data-local">
            {{ $configuracao['escola'] }}, aos {{ date('d') }} / {{ date('m') }} / {{ date('Y') }}
        </div>
        
        <div class="assinaturas">
            <div class="assinatura-area">
                <div class="assinatura-line"></div>
                <div class="assinatura-label">Encarregado de educação</div>
            </div>
            
            <div class="assinatura-area">
                <div class="assinatura-line"></div>
                <div class="assinatura-label">Chefe da secretaria</div>
            </div>
        </div>
    </div>
    
    <button class="print-btn no-print" onclick="window.print()">Imprimir Formulário</button>
</body>
</html>
