<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cartão de Estudante - {{ $aluno->user?->name ?? $aluno->codigo_estudante }}</title>
    <style>
        :root {
            --cor-principal: {{ $configuracao['cor_principal'] }};
            --cor-secundaria: {{ $configuracao['cor_secundaria'] }};
            --cor-destaque: {{ $configuracao['cor_destaque'] }};
        }
        
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        body {
            background-color: #f5f5f5;
            padding: 20px;
            font-family: 'Arial', 'Helvetica', sans-serif;
        }
        
        @page {
            size: 85.60mm 53.98mm;
            margin: 0;
        }
        
        @if(isset($download) && $download)
        html {
            width: 85.60mm !important;
            margin: 0 !important;
            padding: 0 !important;
        }
        
        body {
            width: 85.60mm !important;
            margin: 0 !important;
            padding: 0 !important;
            background: white !important;
        }
        
        .cartao-container {
            page-break-after: always !important;
            page-break-inside: avoid !important;
            page-break-before: auto !important;
            margin: 0 !important;
            padding: 0 !important;
            width: 85.60mm !important;
            height: 53.98mm !important;
            position: relative !important;
            box-sizing: border-box !important;
        }
        
        .cartao-verso {
            page-break-after: always !important;
            page-break-inside: avoid !important;
            page-break-before: auto !important;
            margin: 0 !important;
            padding: 0 !important;
            width: 85.60mm !important;
            height: 53.98mm !important;
            position: relative !important;
            box-sizing: border-box !important;
        }
        
        .print-btn {
            display: none !important;
        }
        @php
            $cp = $configuracao['cor_principal'] ?? '#1a237e';
            $cs = $configuracao['cor_secundaria'] ?? '#64b5f6';
            $cd = $configuracao['cor_destaque'] ?? '#ffb300';
        @endphp
        .forma-azul-escuro { fill: {{ $cp }} !important; }
        .forma-azul-claro { fill: {{ $cs }} !important; }
        .linha-dourada { stroke: {{ $cd }} !important; }
        .detalhe-dourado { fill: {{ $cd }} !important; }
        .escola-nome, .escola-slogan { color: {{ $cp }} !important; }
        .foto-placeholder { color: {{ $cp }} !important; }
        .faixa-inferior { background: {{ $cp }} !important; }
        .onda-principal, .onda-secundaria { fill: {{ $cd }} !important; }
        .onda-destaque { stroke: {{ $cd }} !important; }
        .faixa-nome { border-bottom-color: {{ $cd }} !important; }
        .faixa-content { color: #fff !important; }
        .cartao-verso { border-color: {{ $cd }} !important; }
        .verso-qr { border-color: {{ $cd }} !important; }
        .verso-texto, .verso-aviso, .verso-contacto { color: {{ $cp }} !important; }
        .verso-ano, .verso-validade { color: {{ $cp }} !important; }
        .verso-qr { left: 50% !important; top: 50% !important; transform: none !important; margin-left: -11mm !important; margin-top: -11mm !important; }
        .verso-onda-meio { top: 50% !important; transform: none !important; margin-top: -4mm !important; }
        .pdf-page { display: block !important; width: 85.60mm !important; height: 53.98mm !important; page-break-after: always !important; page-break-inside: avoid !important; overflow: visible !important; margin: 0 !important; padding: 0 !important; }
        .pdf-page:last-of-type,
        .pdf-page.pdf-page-last { page-break-after: auto !important; }
        .cartao-container, .cartao-verso { page-break-after: avoid !important; page-break-inside: avoid !important; }
        .cartao-container { overflow: visible !important; }
        .faixa-inferior { visibility: visible !important; display: block !important; }
        .faixa-info-container { gap: 0 !important; }
        .faixa-info-container .info-card { margin-right: 4mm; }
        .faixa-info-container .info-card:last-child { margin-right: 0; }
        .info-card { gap: 0 !important; }
        .info-card .info-card-label { margin-right: 1mm; }
        @endif
        
        .cartao-container {
            width: 85.60mm;
            height: 53.98mm;
            background: #ffffff;
            border-radius: 12px;
            position: relative;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            overflow: hidden;
            display: flex;
            flex-direction: column;
        }
        
        /* Formas decorativas nos cantos */
        .decoracao-canto-superior {
            position: absolute;
            top: 0;
            left: 0;
            width: 35mm;
            height: 30mm;
            z-index: 1;
            overflow: hidden;
        }
        
        .decoracao-canto-inferior {
            position: absolute;
            bottom: 0;
            right: 0;
            width: 40mm;
            height: 25mm;
            z-index: 1;
            overflow: hidden;
        }
        
        .forma-azul-escuro {
            fill: var(--cor-principal);
            opacity: 0.9;
        }
        
        .forma-azul-claro {
            fill: var(--cor-secundaria);
            opacity: 0.85;
        }
        
        .linha-dourada {
            stroke: var(--cor-destaque);
            stroke-width: 1.2;
            fill: none;
            opacity: 1;
        }
        
        .detalhe-dourado {
            fill: var(--cor-destaque);
            opacity: 0.8;
        }
        
        /* Área do logotipo e escola */
        .header-section {
            position: absolute;
            top: 3mm;
            left: 3mm;
            z-index: 2;
            width: 45mm;
        }
        
        .logo-container {
            display: flex;
            flex-direction: column;
            align-items: flex-start;
        }
        
        .logo-icon {
            width: 38mm;
            height: 38mm;
            margin-bottom: 1.5mm;
        }
        
        .escola-nome {
            font-size: 7pt;
            font-weight: bold;
            color: var(--cor-principal);
            text-transform: uppercase;
            letter-spacing: 0.5px;
            line-height: 1.3;
            margin-bottom: 0.5mm;
        }
        
        .escola-slogan {
            font-size: 5.5pt;
            color: var(--cor-principal);
            text-transform: uppercase;
            letter-spacing: 0.3px;
            line-height: 1.2;
        }
        
        /* Área da foto */
        .foto-section {
            position: absolute;
            top: 3mm;
            right: 3mm;
            width: 25mm;
            height: 30mm;
            z-index: 2;
            background-color: #fff;
            border-radius: 4px;
            overflow: hidden;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .foto-section img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .foto-placeholder {
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, var(--cor-secundaria) 0%, var(--cor-principal) 100%);
            opacity: 0.2;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--cor-principal);
            font-size: 5pt;
            text-align: center;
            padding: 2mm;
        }
        
        
        /* Faixa ondulada na parte inferior */
        .faixa-inferior {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            background: var(--cor-principal);
            padding: 4mm 3mm 2.5mm 3mm;
            z-index: 3;
            min-height: 15mm;
            border-radius: 0 0 12px 12px;
        }
        
        .onda-fundo {
            position: absolute;
            top: -2mm;
            left: 0;
            right: 0;
            width: 100%;
            height: 3mm;
            z-index: 1;
            overflow: visible;
        }
        
        .onda-fundo svg {
            width: 100%;
            height: 100%;
        }
        
        .onda-principal {
            fill: var(--cor-destaque);
        }
        
        .onda-secundaria {
            fill: var(--cor-destaque);
            opacity: 0.7;
        }
        
        .onda-destaque {
            fill: none;
            stroke: var(--cor-destaque);
            stroke-width: 2;
        }
        
        .faixa-content {
            position: relative;
            z-index: 10;
            color: #ffffff;
            text-shadow: 0 1px 3px rgba(0,0,0,0.5);
        }
        
        .faixa-nome {
            font-size: 8pt;
            font-weight: bold;
            text-transform: uppercase;
            line-height: 1.2;
            letter-spacing: 0.3px;
            margin-bottom: 1mm;
            border-bottom: 1px solid var(--cor-destaque);
            padding-bottom: 0.8mm;
            text-shadow: 0 1px 3px rgba(0,0,0,0.5);
        }
        
        .faixa-info-container {
            display: flex;
            justify-content: flex-start;
            gap: 4mm;
            margin-bottom: 0.8mm;
            font-size: 6pt;
        }
        
        .info-card {
            display: flex;
            align-items: center;
            gap: 1mm;
        }
        
        .info-card-label {
            font-weight: 600;
        }
        
        .info-card-value {
            font-weight: normal;
        }
        
        .faixa-codigo {
            font-size: 6pt;
            font-weight: 600;
        }
        
        @media print {
            * {
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
                color-adjust: exact !important;
            }
            
            body {
                background-color: white;
                padding: 0;
                margin: 0;
            }
            
            .cartao-container {
                page-break-after: always;
                margin: 0 auto;
                box-shadow: none;
                border: none;
            }
            
            .faixa-inferior {
                background: var(--cor-principal) !important;
            }
            
            .onda-principal {
                fill: var(--cor-destaque) !important;
            }
            
            .onda-secundaria {
                fill: var(--cor-destaque) !important;
            }
            
            .onda-destaque {
                stroke: var(--cor-destaque) !important;
            }
            
            .faixa-content {
                color: #ffffff !important;
            }
            
            .cartao-verso {
                page-break-after: always;
                margin: 0 auto;
                box-shadow: none;
                background: linear-gradient(160deg, #ffffff 0%, #f0f4f8 100%) !important;
                border: 2px solid var(--cor-destaque) !important;
            }
            
            .verso-qr {
                border: 2px solid var(--cor-destaque) !important;
            }
            
            
            .verso-qr img {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            .no-print {
                display: none !important;
            }
        }
        
        .print-btn {
            display: block;
            width: 200px;
            margin: 20px auto;
            padding: 10px 15px;
            background-color: var(--cor-principal);
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            text-align: center;
            transition: background-color 0.3s;
        }
        
        .print-btn:hover {
            background-color: var(--cor-secundaria);
        }
        
        @media screen {
            .cartao-container {
                margin: 0 auto;
            }
            
            .cartao-verso {
                margin: 20px auto 0;
            }
        }
        
        /* Parte traseira do cartão */
        .cartao-verso {
            width: 85.60mm;
            height: 53.98mm;
            background: linear-gradient(160deg, #ffffff 0%, #f0f4f8 100%);
            border-radius: 12px;
            position: relative;
            box-shadow: 0 4px 16px rgba(0,0,0,0.12);
            overflow: hidden;
            border: 2px solid var(--cor-destaque);
        }
        
        .verso-onda-sup-esq {
            position: absolute;
            top: 0;
            left: 0;
            width: 45mm;
            height: 36mm;
            z-index: 1;
        }
        
        .verso-onda-inf-dir {
            position: absolute;
            bottom: 0;
            right: 0;
            width: 46mm;
            height: 32mm;
            z-index: 1;
        }
        
        .verso-onda-meio {
            position: absolute;
            top: 50%;
            left: 0;
            right: 0;
            height: 8mm;
            transform: translateY(-50%);
            opacity: 0.18;
            z-index: 1;
        }
        
        .verso-qr {
            position: absolute;
            left: 50%;
            top: 50%;
            transform: translate(-50%, -50%);
            width: 22mm;
            height: 22mm;
            z-index: 2;
            background: #fff;
            padding: 2mm;
            border-radius: 8px;
            box-shadow: 0 3px 12px rgba(0,0,0,0.15);
            border: 2px solid var(--cor-destaque);
        }
        
        .verso-qr img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }
        
        .verso-texto {
            position: absolute;
            right: 3mm;
            top: 3mm;
            width: 48mm;
            z-index: 2;
            color: var(--cor-principal);
            font-size: 6.5pt;
            line-height: 1.5;
            font-weight: 600;
        }
        
        .verso-ano, .verso-validade {
            font-weight: 700;
            margin-bottom: 1.2mm;
            letter-spacing: 0.3px;
            text-transform: uppercase;
        }
        
        .verso-aviso {
            position: absolute;
            bottom: 6.5mm;
            left: 4mm;
            right: 4mm;
            text-align: center;
            font-size: 5.5pt;
            line-height: 1.4;
            color: var(--cor-principal);
            z-index: 2;
            font-weight: 600;
        }
        
        .verso-contacto {
            position: absolute;
            bottom: 2mm;
            left: 4mm;
            right: 4mm;
            text-align: center;
            font-size: 5.5pt;
            font-weight: 700;
            color: var(--cor-principal);
            z-index: 2;
            letter-spacing: 0.2px;
            padding: 1mm 0;
            border-top: 1px solid rgba(0,0,0,0.08);
        }
    </style>
</head>
<body>
    @php
        $anoLetivo = \App\Models\AnoLetivo::getAnoLetivoAtual();
        $turmaAtual = $anoLetivo ? $aluno->turmas()->wherePivot('ano_letivo_id', $anoLetivo->id)->first() : null;
        $classe = $turmaAtual ? $turmaAtual->codigo : 'N/A';
    @endphp
    @if(isset($download) && $download)<div class="pdf-page">@endif
    <div class="cartao-container">
        <!-- Formas decorativas -->
        <svg class="decoracao-canto-inferior" viewBox="0 0 120 120" preserveAspectRatio="none">
            <!-- Forma azul clara ondulada no canto inferior direito -->
            <path class="forma-azul-claro" d="M 120,120 C 110,115 100,105 95,90 C 90,75 85,65 80,55 L 120,55 Z" />
            <!-- Linha dourada curva mais espessa -->
            <path class="linha-dourada" d="M 120,108 C 112,102 105,92 100,80 C 95,70 90,62 85,58" />
            <!-- Círculo dourado decorativo -->
            <circle class="detalhe-dourado" cx="95" cy="95" r="4" />
        </svg>
        
        <!-- Header com logo e nome da escola (lado esquerdo) -->
        <div class="header-section">
            <div class="logo-container">
                @php
                    $logotipoUrl = isset($logotipoBase64) && $logotipoBase64 
                        ? $logotipoBase64 
                        : ($configuracao['logotipo'] ? asset('storage/' . $configuracao['logotipo']) : null);
                @endphp
                @if($logotipoUrl)
                    <img src="{{ $logotipoUrl }}" alt="Logo" class="logo-icon" style="max-width: 38mm; max-height: 38mm; object-fit: contain;">
                @else
                    <!-- Ícone SVG de formatura como placeholder (pessoa com capelo em pé sobre livro) -->
                    <svg class="logo-icon" viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg">
                        <!-- Livro aberto (base) -->
                        <path d="M 15,75 L 15,90 L 85,90 L 85,75 Z" fill="{{ $configuracao['cor_principal'] }}" stroke="{{ $configuracao['cor_principal'] }}" stroke-width="1"/>
                        <path d="M 15,75 L 50,70 L 85,75" stroke="{{ $configuracao['cor_destaque'] }}" stroke-width="2" fill="none"/>
                        <path d="M 20,75 L 20,88 L 45,88 L 45,75" fill="#ffffff" opacity="0.3"/>
                        <path d="M 55,75 L 55,88 L 80,88 L 80,75" fill="#ffffff" opacity="0.3"/>
                        
                        <!-- Pessoa (corpo) -->
                        <ellipse cx="50" cy="55" rx="12" ry="18" fill="{{ $configuracao['cor_destaque'] }}"/>
                        <!-- Cabeça -->
                        <circle cx="50" cy="35" r="10" fill="{{ $configuracao['cor_destaque'] }}"/>
                        
                        <!-- Capelo (chapéu de formatura) -->
                        <path d="M 40,28 L 50,22 L 60,28 L 58,32 L 42,32 Z" fill="{{ $configuracao['cor_principal'] }}"/>
                        <circle cx="50" cy="22" r="3" fill="{{ $configuracao['cor_destaque'] }}"/>
                        
                        <!-- Braços erguidos -->
                        <path d="M 38,50 Q 30,45 28,40" stroke="{{ $configuracao['cor_destaque'] }}" stroke-width="3" fill="none" stroke-linecap="round"/>
                        <path d="M 62,50 Q 70,45 72,40" stroke="{{ $configuracao['cor_destaque'] }}" stroke-width="3" fill="none" stroke-linecap="round"/>
                    </svg>
                @endif
                <div class="escola-nome">{{ $configuracao['escola'] }}</div>
                @if($configuracao['slogan'])
                    <div class="escola-slogan">{{ $configuracao['slogan'] }}</div>
                @endif
            </div>
        </div>
        
        <!-- Foto do estudante (lado direito) -->
        <div class="foto-section">
            @php
                $fotoUrl = isset($aluno->foto_base64) && $aluno->foto_base64 
                    ? $aluno->foto_base64 
                    : ($aluno->foto ? asset('storage/' . $aluno->foto) : null);
            @endphp
            @if($fotoUrl)
                <img src="{{ $fotoUrl }}" alt="Foto do Estudante">
            @else
                <div class="foto-placeholder">
                    Sem<br>Foto
                </div>
            @endif
        </div>
        
        <!-- Faixa ondulada na parte inferior -->
        <div class="faixa-inferior">
            <!-- Ondas decorativas no topo -->
            <div class="onda-fundo">
                <svg viewBox="0 0 100 20" preserveAspectRatio="none">
                    <!-- Onda principal -->
                    <path class="onda-principal" d="M 0,8 Q 12,2 25,6 T 50,4 T 75,8 T 100,3 L 100,20 L 0,20 Z" />
                    <!-- Onda secundária -->
                    <path class="onda-secundaria" d="M 0,12 Q 15,5 30,10 T 55,6 T 80,11 T 100,6 L 100,20 L 0,20 Z" opacity="0.6" />
                    <!-- Linha dourada -->
                    <path class="onda-destaque" d="M 0,10 Q 12,3 25,8 T 50,5 T 75,9 T 100,4" />
                </svg>
            </div>
            
            <!-- Conteúdo -->
            <div class="faixa-content">
                <div class="faixa-nome">{{ $aluno->user?->name ?? $aluno->codigo_estudante ?? '' }}</div>
                
                <div class="faixa-info-container">
                    <div class="info-card">
                        <span class="info-card-label">CLASSE:</span>
                        <span class="info-card-value">{{ $classe }}</span>
                    </div>
                    
                    <div class="info-card">
                        <span class="info-card-label">TURMA:</span>
                        <span class="info-card-value">{{ $turmaAtual ? $turmaAtual->nome : 'N/A' }}</span>
                    </div>
                </div>
                
                <div class="faixa-codigo">CÓDIGO DO ESTUDANTE: {{ $aluno->codigo_estudante }}</div>
            </div>
        </div>
    </div>
    @if(isset($download) && $download)</div><div class="pdf-page pdf-page-last">@endif
    
    <!-- Parte traseira do cartão -->
    <div class="cartao-verso">
        <svg class="verso-onda-sup-esq" viewBox="0 0 100 100" preserveAspectRatio="none">
            <path fill="{{ $configuracao['cor_principal'] }}" d="M 0,0 Q 20,15 35,35 T 60,55 L 0,55 Z" />
            <path fill="{{ $configuracao['cor_principal'] }}" opacity="0.6" d="M 0,5 Q 15,25 30,45 T 55,50 L 0,50 Z" />
            <path fill="none" stroke="{{ $configuracao['cor_destaque'] }}" stroke-width="2" d="M 0,18 Q 18,32 32,48 T 58,52" />
        </svg>
        <svg class="verso-onda-inf-dir" viewBox="0 0 100 100" preserveAspectRatio="none">
            <path fill="{{ $configuracao['cor_destaque'] }}" d="M 100,100 Q 80,85 65,65 T 45,35 L 100,35 Z" />
            <path fill="{{ $configuracao['cor_destaque'] }}" opacity="0.6" d="M 100,95 Q 82,78 68,58 T 48,38 L 100,38 Z" />
            <path fill="none" stroke="{{ $configuracao['cor_principal'] }}" stroke-width="2" d="M 100,82 Q 85,65 72,48 T 52,40" />
        </svg>
        <svg class="verso-onda-meio" viewBox="0 0 100 20" preserveAspectRatio="none">
            <path fill="{{ $configuracao['cor_secundaria'] }}" d="M 0,12 Q 20,2 50,10 T 100,6 L 100,20 L 0,20 Z" />
        </svg>
        
        <div class="verso-qr">
            @php
                $qrUrl = isset($qrCodeBase64) && $qrCodeBase64 
                    ? $qrCodeBase64 
                    : 'https://api.qrserver.com/v1/create-qr-code/?size=80x80&data=' . urlencode($aluno->codigo_estudante);
            @endphp
            <img src="{{ $qrUrl }}" alt="QR" width="80" height="80" style="display: block; width: 100%; height: 100%; object-fit: contain;">
        </div>
        
        <div class="verso-texto">
            <div class="verso-ano">ANO LECTIVO: {{ $configuracao['ano_lectivo'] }}</div>
            <div class="verso-validade">VALIDADE: {{ $configuracao['validade'] }}</div>
        </div>
        
        <div class="verso-aviso">
            Este cartão é pessoal e intransmissivel. Em caso de perda, contacte a secretaria 
        </div>
        
        <div class="verso-contacto">
            CONTACTO: {{ $configuracao['contacto'] }} | {{ $configuracao['website'] }}
        </div>
    </div>
    @if(isset($download) && $download)</div>@endif
    
    @if(empty($download))
    <button class="print-btn no-print" onclick="window.print()">Imprimir Cartão</button>
    @endif
</body>
</html>
