@extends('layouts.app')

@section('title', 'Folhetos por Turma - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h2>Folhetos de Aproveitamento por Turma</h2>
        </div>

        <div class="card">
            <div class="card-body">
                <form method="GET" action="{{ route('admin.alunos.folhetos-turma') }}" class="row g-3">
                    <div class="col-md-6">
                        <label for="turma_id" class="form-label">Turma</label>
                        <select class="form-select" name="turma_id" id="turma_id" required>
                            <option value="">Selecione uma turma</option>
                            @foreach($turmas as $turma)
                                <option value="{{ $turma->id }}">{{ $turma->codigo }} - {{ $turma->nome }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label for="trimestre" class="form-label">Trimestre</label>
                        <select class="form-select" name="trimestre" id="trimestre" required>
                            @foreach($trimestres as $trim)
                                <option value="{{ $trim->numero }}" {{ $trim->numero == 1 ? 'selected' : '' }}>
                                    {{ $trim->numero }}º Trimestre
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-12">
                        <button type="submit" class="btn btn-primary">Gerar Folhetos</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

