<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Folheto - {{ $aluno->user->name }}</title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
            font-family: 'Times New Roman', Times, serif;
        }
        
        @page {
            size: A4;
            margin: 0;
        }
        
        @media print {
            @page {
                margin: 0;
                size: A4;
            }
            
            html, body {
                margin: 0 !important;
                padding: 0 !important;
                width: 210mm !important;
                height: auto !important;
                background: white !important;
                overflow: visible !important;
            }
        }
        
        body {
            background-color: white;
            color: #000;
            line-height: 1.4;
            padding: 5mm;
        }
        
        .document {
            background-color: white;
            padding: 5mm;
            width: 200mm;
            height: 55mm;
            box-sizing: border-box;
            border: 1px solid #000;
        }
        
        .header {
            margin-bottom: 2mm;
            text-align: center;
            line-height: 1.2;
        }
        
        .header img {
            max-height: 100px;
            margin-bottom: 2mm;
        }
        
        .header-line {
            font-size: 7pt;
            margin-bottom: 0.5mm;
        }
        
        .escola-nome {
            font-weight: bold;
        }
        
        .info-header {
            font-size: 6.5pt;
            margin-top: 1mm;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 6.5pt;
            margin-bottom: 1mm;
        }
        
        table th,
        table td {
            border: 1px solid #000;
            padding: 2px;
            text-align: center;
        }
        
        table th {
            background-color: #f0f0f0;
            font-weight: bold;
        }
        
        .col-numero {
            width: 20px;
        }
        
        .col-nome {
            width: 120px;
            text-align: left;
            font-size: 6.5pt;
        }
        
        .col-genero {
            width: 25px;
        }
        
        .col-disciplina {
            width: 35px;
        }
        
        .col-media {
            width: 40px;
        }
        
        .col-classificacao {
            width: 100px;
        }
        
        .footer {
            text-align: center;
            margin-top: 1mm;
            font-size: 6.5pt;
        }
        
        @media print {
            body {
                padding: 0 !important;
            }
        }
    </style>
    <script>
        window.onload = function() {
            window.print();
        };
    </script>
</head>
<body>
    <div class="document">
        <div class="header">
            @if(!empty($logotipoBase64))
                <img src="{{ $logotipoBase64 }}" alt="Logotipo da Escola">
            @endif
            <div class="header-line">Aproveitamento Pedagógico do {{ $trimestre->numero }}º Trimestre</div>
            <div class="info-header">
                @if($turma->codigo)
                    {{ strtoupper($turma->codigo) }}
                @endif
                Turma: {{ strtoupper($turma->nome) }} | Ano Lectivo: {{ $anoLetivo->ano_inicial ?? $anoLetivo->ano }}
            </div>
        </div>
        
        <table>
            <thead>
                <tr>
                    <th class="col-numero">Nº</th>
                    <th class="col-nome">Nome Completo</th>
                    <th class="col-genero">Gén.</th>
                    <th colspan="{{ $disciplinas->count() }}" style="text-align: center;">Médias por Disciplina</th>
                    <th class="col-media">Média Trimestral</th>
                    <th class="col-classificacao">Classificação</th>
                </tr>
                <tr>
                    <th></th>
                    <th></th>
                    <th></th>
                    @foreach($disciplinas as $disciplina)
                        @php
                            $abreviacoes = [
                                'Português' => 'Port.',
                                'Matemática' => 'Mat.',
                                'Ciências Naturais' => 'C. Nat.',
                                'Ciências Sociais' => 'C. Soc.',
                                'Educação Visual e Ofícios' => 'EVO',
                                'Educação Física' => 'E. Fis.',
                                'Física' => 'Físi',
                                'História' => 'HIST',
                                'Inglês' => 'Ingl.',
                                'Química' => 'Quím.',
                                'Biologia' => 'Biol.',
                            ];
                            $abrev = $abreviacoes[$disciplina->nome] ?? strtoupper(substr($disciplina->nome, 0, 5));
                        @endphp
                        <th class="col-disciplina">{{ $abrev }}</th>
                    @endforeach
                    <th></th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>1</td>
                    <td style="text-align: left;">{{ strtoupper($aluno->user->name) }}</td>
                    <td>{{ $aluno->genero == 'M' ? 'H' : ($aluno->genero == 'F' ? 'M' : '-') }}</td>
                    @foreach($disciplinas as $disciplina)
                        <td>
                            @if(isset($mediasPorDisciplina[$disciplina->id]) && $mediasPorDisciplina[$disciplina->id] !== null)
                                {{ $mediasPorDisciplina[$disciplina->id] }}
                            @else
                                -
                            @endif
                        </td>
                    @endforeach
                    <td>
                        @if($mediaTrimestralGeral !== null)
                            {{ $mediaTrimestralGeral }}
                        @else
                            -
                        @endif
                    </td>
                    <td><strong>{{ $classificacaoMedia ?? '-' }}</strong></td>
                </tr>
            </tbody>
        </table>
        
        <div class="footer">
            O(A) Director(a) de Turma
        </div>
    </div>
</body>
</html>

