@extends('layouts.app')

@section('title', isset($viewOnly) && $viewOnly ? 'Visualizar Aluno - SGE' : 'Editar Aluno - SGE')

@section('content')
@php
    $isViewOnly = isset($viewOnly) && $viewOnly;
    $disabledAttr = $isViewOnly ? 'disabled readonly' : '';
@endphp
<div class="row">
    <div class="col-md-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <div>
                <h5 class="mb-0" style="font-weight: 600;">{{ $isViewOnly ? __('common.view_student') : __('common.edit_student') }}</h5>
                <small class="text-muted">{{ $aluno->codigo_estudante }}</small>
            </div>
            <div class="d-flex gap-1">
                <a href="{{ route('admin.alunos.ficha-inscricao', $aluno) }}" class="btn btn-sm btn-primary" target="_blank" title="Ficha de Inscrição">
                    <i class="bi bi-file-earmark-text"></i> Ficha de Inscrição
                </a>
                <a href="{{ route('admin.alunos.folheto', $aluno) }}" class="btn btn-sm btn-warning" target="_blank" title="Folheto">
                    <i class="bi bi-file-text"></i>
                </a>
                @if(!$isViewOnly)
                    <a href="{{ route('admin.alunos.view', $aluno) }}" class="btn btn-sm btn-secondary">
                        <i class="bi bi-eye"></i> Ver
                    </a>
                @else
                    <a href="{{ route('admin.alunos.edit', $aluno) }}" class="btn btn-sm btn-primary">
                        <i class="bi bi-pencil"></i> Editar
                    </a>
                @endif
                <a href="{{ route('admin.alunos.index') }}" class="btn btn-sm btn-secondary">
                    <i class="bi bi-arrow-left"></i> Voltar
                </a>
            </div>
        </div>
        
        <div class="card">
            <div class="card-header bg-primary-custom text-white py-2">
                <h5 class="mb-0">{{ $isViewOnly ? __('common.view_student') : __('common.edit_student') }}</h5>
            </div>
            <div class="card-body p-2">
                <form method="POST" action="{{ route('admin.alunos.update', $aluno) }}" enctype="multipart/form-data" id="form-aluno" onsubmit="{{ $isViewOnly ? 'return false;' : '' }}">
                    @csrf
                    @method('PUT')

                    <div class="row g-1">
                        <div class="col-md-12">
                            <h6 class="border-bottom pb-1 mb-2 fw-bold text-primary">{{ __('common.student_data') }}</h6>
                        </div>

                        <div class="col-md-3">
                            <label for="foto" class="form-label small mb-1">Foto do Aluno (Tipo Passe)</label>
                            <div id="foto-preview" style="width: 100%; max-width: 120px; height: 150px; border: 2px solid #333; display: flex; align-items: center; justify-content: center; background-color: #f9f9f9; margin-bottom: 5px;">
                                @if($aluno->foto)
                                    <img src="{{ asset('storage/' . $aluno->foto) }}" style="width: 100%; height: 100%; object-fit: cover;">
                                @else
                                    <span class="text-muted" style="font-size: 0.7rem;">Sem foto</span>
                                @endif
                            </div>
                            <input type="file" class="form-control form-control-sm @error('foto') is-invalid @enderror" 
                                   id="foto" name="foto" accept="image/jpeg,image/jpg,image/png" onchange="previewFoto(this)" {{ $disabledAttr }}>
                            <input type="hidden" id="foto_base64" name="foto_base64">
                            @if($aluno->foto && !$isViewOnly)
                                <div class="form-check mt-1">
                                    <input class="form-check-input" type="checkbox" id="remove_foto" name="remove_foto" value="1">
                                    <label class="form-check-label small" for="remove_foto" style="font-size: 0.7rem;">Remover foto atual</label>
                                </div>
                            @endif
                            @error('foto')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                            @if(!$isViewOnly)
                            <div class="btn-group btn-group-sm w-100 mt-1" role="group">
                                <button type="button" class="btn btn-outline-primary btn-sm" onclick="capturarFoto()">
                                    <i class="bi bi-camera"></i> Capturar
                                </button>
                                <button type="button" class="btn btn-outline-danger btn-sm" onclick="removerFoto()">
                                    <i class="bi bi-trash"></i> Remover
                                </button>
                            </div>
                            @endif
                        </div>

                        <div class="col-md-9">
                            <div class="row g-1">
                                <div class="col-md-12">
                                    <label for="name" class="form-label small mb-0">Nome do aluno (a) *</label>
                                    <input type="text" class="form-control form-control-sm @error('name') is-invalid @enderror" 
                                           id="name" name="name" value="{{ old('name', $aluno->user->name) }}" {{ $disabledAttr }} {{ !$isViewOnly ? 'required' : '' }}>
                                    @error('name')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-4">
                                    <label for="local_nascimento" class="form-label small mb-0">Local de nascimento</label>
                                    <input type="text" class="form-control form-control-sm @error('local_nascimento') is-invalid @enderror" 
                                           id="local_nascimento" name="local_nascimento" value="{{ old('local_nascimento', $aluno->local_nascimento) }}" {{ $disabledAttr }}>
                                    @error('local_nascimento')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>

                        <div class="col-md-2">
                            <label for="dia_nascimento" class="form-label small mb-0">Dia</label>
                            <input type="number" class="form-control form-control-sm" 
                                   id="dia_nascimento" name="dia_nascimento" min="1" max="31" 
                                   value="{{ old('dia_nascimento', $aluno->data_nascimento ? $aluno->data_nascimento->format('d') : '') }}" {{ $disabledAttr }}>
                        </div>

                        <div class="col-md-2">
                            <label for="mes_nascimento" class="form-label small mb-0">Mês</label>
                            <input type="number" class="form-control form-control-sm" 
                                   id="mes_nascimento" name="mes_nascimento" min="1" max="12"
                                   value="{{ old('mes_nascimento', $aluno->data_nascimento ? $aluno->data_nascimento->format('m') : '') }}" {{ $disabledAttr }}>
                        </div>

                                <div class="col-md-2">
                                    <label for="ano_nascimento" class="form-label small mb-0">Ano</label>
                                    <input type="number" class="form-control form-control-sm" 
                                           id="ano_nascimento" name="ano_nascimento" min="1900" max="{{ date('Y') }}"
                                           value="{{ old('ano_nascimento', $aluno->data_nascimento ? $aluno->data_nascimento->format('Y') : '') }}" {{ $disabledAttr }}>
                                </div>

                                <input type="hidden" id="data_nascimento" name="data_nascimento" 
                                       value="{{ old('data_nascimento', $aluno->data_nascimento?->format('Y-m-d')) }}">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <label for="naturalidade" class="form-label small mb-0">Naturalidade</label>
                            <input type="text" class="form-control form-control-sm @error('naturalidade') is-invalid @enderror" 
                                   id="naturalidade" name="naturalidade" value="{{ old('naturalidade', $aluno->naturalidade) }}" {{ $disabledAttr }}>
                            @error('naturalidade')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-4">
                            <label for="distrito_natural" class="form-label small mb-0">Distrito</label>
                            <input type="text" class="form-control form-control-sm @error('distrito_natural') is-invalid @enderror" 
                                   id="distrito_natural" name="distrito_natural" value="{{ old('distrito_natural', $aluno->distrito_natural) }}" {{ $disabledAttr }}>
                            @error('distrito_natural')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-4">
                            <label for="provincia_natural" class="form-label small mb-0">Província</label>
                            <select class="form-select form-select-sm @error('provincia_natural') is-invalid @enderror" 
                                    id="provincia_natural" name="provincia_natural" {{ $disabledAttr }}>
                                <option value="">Selecione</option>
                                <option value="Cabo Delgado" {{ old('provincia_natural', $aluno->provincia_natural) == 'Cabo Delgado' ? 'selected' : '' }}>Cabo Delgado</option>
                                <option value="Gaza" {{ old('provincia_natural', $aluno->provincia_natural) == 'Gaza' ? 'selected' : '' }}>Gaza</option>
                                <option value="Inhambane" {{ old('provincia_natural', $aluno->provincia_natural) == 'Inhambane' ? 'selected' : '' }}>Inhambane</option>
                                <option value="Manica" {{ old('provincia_natural', $aluno->provincia_natural) == 'Manica' ? 'selected' : '' }}>Manica</option>
                                <option value="Maputo" {{ old('provincia_natural', $aluno->provincia_natural) == 'Maputo' ? 'selected' : '' }}>Maputo</option>
                                <option value="Maputo Cidade" {{ old('provincia_natural', $aluno->provincia_natural) == 'Maputo Cidade' ? 'selected' : '' }}>Maputo Cidade</option>
                                <option value="Nampula" {{ old('provincia_natural', $aluno->provincia_natural) == 'Nampula' ? 'selected' : '' }}>Nampula</option>
                                <option value="Niassa" {{ old('provincia_natural', $aluno->provincia_natural) == 'Niassa' ? 'selected' : '' }}>Niassa</option>
                                <option value="Sofala" {{ old('provincia_natural', $aluno->provincia_natural) == 'Sofala' ? 'selected' : '' }}>Sofala</option>
                                <option value="Tete" {{ old('provincia_natural', $aluno->provincia_natural) == 'Tete' ? 'selected' : '' }}>Tete</option>
                                <option value="Zambézia" {{ old('provincia_natural', $aluno->provincia_natural) == 'Zambézia' ? 'selected' : '' }}>Zambézia</option>
                            </select>
                            @if($isViewOnly)
                                <input type="hidden" name="provincia_natural" value="{{ old('provincia_natural', $aluno->provincia_natural) }}">
                            @endif
                            @error('provincia_natural')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label for="tipo_documento" class="form-label small mb-0">Tipo de Documento</label>
                            <select class="form-select form-select-sm @error('tipo_documento') is-invalid @enderror" 
                                    id="tipo_documento" name="tipo_documento" {{ $disabledAttr }}>
                                <option value="">Selecione</option>
                                <option value="BI" {{ old('tipo_documento', $aluno->tipo_documento) == 'BI' ? 'selected' : '' }}>BI</option>
                                <option value="Cédula" {{ old('tipo_documento', $aluno->tipo_documento) == 'Cédula' ? 'selected' : '' }}>Cédula</option>
                                <option value="Passaporte" {{ old('tipo_documento', $aluno->tipo_documento) == 'Passaporte' ? 'selected' : '' }}>Passaporte</option>
                            </select>
                            @error('tipo_documento')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label for="num_documento" class="form-label small mb-0">Nº do Documento</label>
                            <input type="text" class="form-control form-control-sm @error('num_documento') is-invalid @enderror" 
                                   id="num_documento" name="num_documento" value="{{ old('num_documento', $aluno->num_documento) }}" {{ $disabledAttr }}>
                            @error('num_documento')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-4">
                            <label for="local_emissao" class="form-label small mb-0">Local de emissão</label>
                            <input type="text" class="form-control form-control-sm @error('local_emissao') is-invalid @enderror" 
                                   id="local_emissao" name="local_emissao" value="{{ old('local_emissao', $aluno->local_emissao) }}" {{ $disabledAttr }}>
                            @error('local_emissao')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-4">
                            <label for="data_emissao" class="form-label small mb-0">Data de emissão</label>
                            <input type="date" class="form-control form-control-sm @error('data_emissao') is-invalid @enderror" 
                                   id="data_emissao" name="data_emissao" value="{{ old('data_emissao', $aluno->data_emissao?->format('Y-m-d')) }}" {{ $disabledAttr }}>
                            @error('data_emissao')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-12 mt-2">
                            <hr class="my-1">
                            <h6 class="border-bottom pb-1 mb-1 fw-bold text-primary">INFORMAÇÃO COMPLEMENTAR</h6>
                            <small class="text-muted">Para efeitos de benefícios diversos (redução de propinas e uso das instalações para eventos)</small>
                        </div>

                        <div class="col-md-4">
                            <label for="num_irmaos_mais_velhos" class="form-label small mb-0">N° de Irmãos mais velhos</label>
                            <input type="number" min="0" class="form-control form-control-sm @error('num_irmaos_mais_velhos') is-invalid @enderror" 
                                   id="num_irmaos_mais_velhos" name="num_irmaos_mais_velhos" value="{{ old('num_irmaos_mais_velhos', $aluno->num_irmaos_mais_velhos ?? 0) }}" {{ $disabledAttr }}>
                            @error('num_irmaos_mais_velhos')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-4">
                            <label for="num_irmaos_mais_novos" class="form-label small mb-0">N° de Irmãos mais novos</label>
                            <input type="number" min="0" class="form-control form-control-sm @error('num_irmaos_mais_novos') is-invalid @enderror" 
                                   id="num_irmaos_mais_novos" name="num_irmaos_mais_novos" value="{{ old('num_irmaos_mais_novos', $aluno->num_irmaos_mais_novos ?? 0) }}" {{ $disabledAttr }}>
                            @error('num_irmaos_mais_novos')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-4">
                            <label for="num_irmaos_mesma_idade" class="form-label small mb-0">N° de Irmãos com a mesma idade</label>
                            <input type="number" min="0" class="form-control form-control-sm @error('num_irmaos_mesma_idade') is-invalid @enderror" 
                                   id="num_irmaos_mesma_idade" name="num_irmaos_mesma_idade" value="{{ old('num_irmaos_mesma_idade', $aluno->num_irmaos_mesma_idade ?? 0) }}" {{ $disabledAttr }}>
                            @error('num_irmaos_mesma_idade')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-12 mt-2">
                            <hr class="my-1">
                            <h6 class="border-bottom pb-1 mb-1 fw-bold text-primary">IDENTIFICAÇÃO DOS PAIS</h6>
                        </div>

                        <div class="col-md-6">
                            <h6 class="small fw-bold mb-1">Nome do Pai</h6>
                            <div class="row g-1">
                                <div class="col-md-12">
                                    <label for="nome_pai" class="form-label small mb-0">Nome</label>
                                    <input type="text" class="form-control form-control-sm @error('nome_pai') is-invalid @enderror" 
                                           id="nome_pai" name="nome_pai" value="{{ old('nome_pai', $aluno->nome_pai) }}" {{ $disabledAttr }}>
                                    @error('nome_pai')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-12">
                                    <label for="local_trabalho_pai" class="form-label small mb-0">Local de trabalho</label>
                                    <input type="text" class="form-control form-control-sm @error('local_trabalho_pai') is-invalid @enderror" 
                                           id="local_trabalho_pai" name="local_trabalho_pai" value="{{ old('local_trabalho_pai', $aluno->local_trabalho_pai) }}" {{ $disabledAttr }}>
                                    @error('local_trabalho_pai')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="endereco_pai_bairro" class="form-label small mb-0">Bairro</label>
                                    <input type="text" class="form-control form-control-sm @error('endereco_pai_bairro') is-invalid @enderror" 
                                           id="endereco_pai_bairro" name="endereco_pai_bairro" value="{{ old('endereco_pai_bairro', $aluno->endereco_pai_bairro) }}" {{ $disabledAttr }}>
                                    @error('endereco_pai_bairro')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="endereco_pai_rua" class="form-label small mb-0">Avenida/Rua</label>
                                    <input type="text" class="form-control form-control-sm @error('endereco_pai_rua') is-invalid @enderror" 
                                           id="endereco_pai_rua" name="endereco_pai_rua" value="{{ old('endereco_pai_rua', $aluno->endereco_pai_rua) }}" {{ $disabledAttr }}>
                                    @error('endereco_pai_rua')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-3">
                                    <label for="endereco_pai_numero" class="form-label small mb-0">N°</label>
                                    <input type="text" class="form-control form-control-sm @error('endereco_pai_numero') is-invalid @enderror" 
                                           id="endereco_pai_numero" name="endereco_pai_numero" value="{{ old('endereco_pai_numero', $aluno->endereco_pai_numero) }}" {{ $disabledAttr }}>
                                    @error('endereco_pai_numero')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-3">
                                    <label for="endereco_pai_quarteirao" class="form-label small mb-0">Quarteirão/andar</label>
                                    <input type="text" class="form-control form-control-sm @error('endereco_pai_quarteirao') is-invalid @enderror" 
                                           id="endereco_pai_quarteirao" name="endereco_pai_quarteirao" value="{{ old('endereco_pai_quarteirao', $aluno->endereco_pai_quarteirao) }}" {{ $disabledAttr }}>
                                    @error('endereco_pai_quarteirao')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-3">
                                    <label for="endereco_pai_flat" class="form-label small mb-0">Flat</label>
                                    <input type="text" class="form-control form-control-sm @error('endereco_pai_flat') is-invalid @enderror" 
                                           id="endereco_pai_flat" name="endereco_pai_flat" value="{{ old('endereco_pai_flat', $aluno->endereco_pai_flat) }}" {{ $disabledAttr }}>
                                    @error('endereco_pai_flat')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-3">
                                    <label for="telefone_pai" class="form-label small mb-0">Tel</label>
                                    <input type="text" class="form-control form-control-sm @error('telefone_pai') is-invalid @enderror" 
                                           id="telefone_pai" name="telefone_pai" value="{{ old('telefone_pai', $aluno->telefone_pai) }}" {{ $disabledAttr }}>
                                    @error('telefone_pai')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="bi_pai" class="form-label small mb-0">N° do BI</label>
                                    <input type="text" class="form-control form-control-sm @error('bi_pai') is-invalid @enderror" 
                                           id="bi_pai" name="bi_pai" value="{{ old('bi_pai', $aluno->bi_pai) }}" {{ $disabledAttr }}>
                                    @error('bi_pai')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <h6 class="small fw-bold mb-1">Nome da Mãe</h6>
                            <div class="row g-1">
                                <div class="col-md-12">
                                    <label for="nome_mae" class="form-label small mb-0">Nome</label>
                                    <input type="text" class="form-control form-control-sm @error('nome_mae') is-invalid @enderror" 
                                           id="nome_mae" name="nome_mae" value="{{ old('nome_mae', $aluno->nome_mae) }}" {{ $disabledAttr }}>
                                    @error('nome_mae')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-12">
                                    <label for="local_trabalho_mae" class="form-label small mb-0">Local de trabalho</label>
                                    <input type="text" class="form-control form-control-sm @error('local_trabalho_mae') is-invalid @enderror" 
                                           id="local_trabalho_mae" name="local_trabalho_mae" value="{{ old('local_trabalho_mae', $aluno->local_trabalho_mae) }}" {{ $disabledAttr }}>
                                    @error('local_trabalho_mae')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="endereco_mae_bairro" class="form-label small mb-0">Bairro</label>
                                    <input type="text" class="form-control form-control-sm @error('endereco_mae_bairro') is-invalid @enderror" 
                                           id="endereco_mae_bairro" name="endereco_mae_bairro" value="{{ old('endereco_mae_bairro', $aluno->endereco_mae_bairro) }}" {{ $disabledAttr }}>
                                    @error('endereco_mae_bairro')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="endereco_mae_rua" class="form-label small mb-0">Avenida/Rua</label>
                                    <input type="text" class="form-control form-control-sm @error('endereco_mae_rua') is-invalid @enderror" 
                                           id="endereco_mae_rua" name="endereco_mae_rua" value="{{ old('endereco_mae_rua', $aluno->endereco_mae_rua) }}" {{ $disabledAttr }}>
                                    @error('endereco_mae_rua')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-3">
                                    <label for="endereco_mae_numero" class="form-label small mb-0">N°</label>
                                    <input type="text" class="form-control form-control-sm @error('endereco_mae_numero') is-invalid @enderror" 
                                           id="endereco_mae_numero" name="endereco_mae_numero" value="{{ old('endereco_mae_numero', $aluno->endereco_mae_numero) }}" {{ $disabledAttr }}>
                                    @error('endereco_mae_numero')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-3">
                                    <label for="endereco_mae_quarteirao" class="form-label small mb-0">Quarteirão/andar</label>
                                    <input type="text" class="form-control form-control-sm @error('endereco_mae_quarteirao') is-invalid @enderror" 
                                           id="endereco_mae_quarteirao" name="endereco_mae_quarteirao" value="{{ old('endereco_mae_quarteirao', $aluno->endereco_mae_quarteirao) }}" {{ $disabledAttr }}>
                                    @error('endereco_mae_quarteirao')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-3">
                                    <label for="endereco_mae_flat" class="form-label small mb-0">Flat</label>
                                    <input type="text" class="form-control form-control-sm @error('endereco_mae_flat') is-invalid @enderror" 
                                           id="endereco_mae_flat" name="endereco_mae_flat" value="{{ old('endereco_mae_flat', $aluno->endereco_mae_flat) }}" {{ $disabledAttr }}>
                                    @error('endereco_mae_flat')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-3">
                                    <label for="telefone_mae" class="form-label small mb-0">Tel</label>
                                    <input type="text" class="form-control form-control-sm @error('telefone_mae') is-invalid @enderror" 
                                           id="telefone_mae" name="telefone_mae" value="{{ old('telefone_mae', $aluno->telefone_mae) }}" {{ $disabledAttr }}>
                                    @error('telefone_mae')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="bi_mae" class="form-label small mb-0">N° do BI</label>
                                    <input type="text" class="form-control form-control-sm @error('bi_mae') is-invalid @enderror" 
                                           id="bi_mae" name="bi_mae" value="{{ old('bi_mae', $aluno->bi_mae) }}" {{ $disabledAttr }}>
                                    @error('bi_mae')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <label for="genero" class="form-label small mb-0">Género</label>
                            <select class="form-select form-select-sm @error('genero') is-invalid @enderror" 
                                    id="genero" name="genero" {{ $disabledAttr }}>
                                <option value="">Selecione</option>
                                <option value="M" {{ old('genero', $aluno->genero) == 'M' ? 'selected' : '' }}>Masculino</option>
                                <option value="F" {{ old('genero', $aluno->genero) == 'F' ? 'selected' : '' }}>Feminino</option>
                                <option value="Outro" {{ old('genero', $aluno->genero) == 'Outro' ? 'selected' : '' }}>Outro</option>
                            </select>
                            @error('genero')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="telefone" class="form-label small mb-0">Telefone</label>
                            <input type="text" class="form-control form-control-sm @error('telefone') is-invalid @enderror" 
                                   id="telefone" name="telefone" value="{{ old('telefone', $aluno->telefone) }}" {{ $disabledAttr }}>
                            @error('telefone')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-12">
                            <label for="endereco" class="form-label small mb-0">Endereço</label>
                            <textarea class="form-control form-control-sm @error('endereco') is-invalid @enderror" 
                                      id="endereco" name="endereco" rows="1" {{ $disabledAttr }}>{{ old('endereco', $aluno->endereco) }}</textarea>
                            @error('endereco')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-12 mt-2">
                            <hr class="my-1">
                            <h6 class="border-bottom pb-1 mb-1 fw-bold text-primary">DADOS DE SAÚDE DO ALUNO</h6>
                        </div>

                        <div class="col-md-6">
                            <label for="plano_saude" class="form-label small mb-0">É dependente de algum plano de Saúde? Se sim, qual?</label>
                            <input type="text" class="form-control form-control-sm @error('plano_saude') is-invalid @enderror" 
                                   id="plano_saude" name="plano_saude" value="{{ old('plano_saude', $aluno->plano_saude) }}" placeholder="Deixe em branco se não" {{ $disabledAttr }}>
                            @error('plano_saude')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="problema_saude_cronico" class="form-label small mb-0">Tem algum problema de saúde crônico? Se sim, qual?</label>
                            <input type="text" class="form-control form-control-sm @error('problema_saude_cronico') is-invalid @enderror" 
                                   id="problema_saude_cronico" name="problema_saude_cronico" value="{{ old('problema_saude_cronico', $aluno->problema_saude_cronico) }}" placeholder="Deixe em branco se não" {{ $disabledAttr }}>
                            @error('problema_saude_cronico')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="alergias" class="form-label small mb-0">Tem alergias? Se sim, quais?</label>
                            <input type="text" class="form-control form-control-sm @error('alergias') is-invalid @enderror" 
                                   id="alergias" name="alergias" value="{{ old('alergias', $aluno->alergias) }}" placeholder="Deixe em branco se não" {{ $disabledAttr }}>
                            @error('alergias')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="diagnostico_deficiencia" class="form-label small mb-0">Já recebeu algum diagnóstico médico de deficiência? Se sim, qual?</label>
                            <input type="text" class="form-control form-control-sm @error('diagnostico_deficiencia') is-invalid @enderror" 
                                   id="diagnostico_deficiencia" name="diagnostico_deficiencia" value="{{ old('diagnostico_deficiencia', $aluno->diagnostico_deficiencia) }}" placeholder="Deixe em branco se não" {{ $disabledAttr }}>
                            @error('diagnostico_deficiencia')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="dificuldade_motora_auditiva_visual_fala_emocional" class="form-label small mb-0">Apresenta alguma dificuldade motora, auditiva, visual, na fala ou emocional? Se sim, qual?</label>
                            <input type="text" class="form-control form-control-sm @error('dificuldade_motora_auditiva_visual_fala_emocional') is-invalid @enderror" 
                                   id="dificuldade_motora_auditiva_visual_fala_emocional" name="dificuldade_motora_auditiva_visual_fala_emocional" value="{{ old('dificuldade_motora_auditiva_visual_fala_emocional', $aluno->dificuldade_motora_auditiva_visual_fala_emocional) }}" placeholder="Deixe em branco se não" {{ $disabledAttr }}>
                            @error('dificuldade_motora_auditiva_visual_fala_emocional')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="tratamento_medico" class="form-label small mb-0">Está em tratamento médico? Se sim, para que doença?</label>
                            <input type="text" class="form-control form-control-sm @error('tratamento_medico') is-invalid @enderror" 
                                   id="tratamento_medico" name="tratamento_medico" value="{{ old('tratamento_medico', $aluno->tratamento_medico) }}" placeholder="Deixe em branco se não" {{ $disabledAttr }}>
                            @error('tratamento_medico')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="medicacao" class="form-label small mb-0">Está em uso de alguma medicação? Qual? Quando encerrar o uso?</label>
                            <input type="text" class="form-control form-control-sm @error('medicacao') is-invalid @enderror" 
                                   id="medicacao" name="medicacao" value="{{ old('medicacao', $aluno->medicacao) }}" placeholder="Deixe em branco se não" {{ $disabledAttr }}>
                            @error('medicacao')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label for="vacinas_em_dia" class="form-label small mb-0">As vacinas estão em dia?</label>
                            <select class="form-select form-select-sm @error('vacinas_em_dia') is-invalid @enderror" 
                                    id="vacinas_em_dia" name="vacinas_em_dia" {{ $disabledAttr }}>
                                <option value="">Selecione</option>
                                <option value="1" {{ old('vacinas_em_dia', $aluno->vacinas_em_dia) == '1' || $aluno->vacinas_em_dia === true ? 'selected' : '' }}>Sim</option>
                                <option value="0" {{ old('vacinas_em_dia', $aluno->vacinas_em_dia) == '0' || $aluno->vacinas_em_dia === false ? 'selected' : '' }}>Não</option>
                            </select>
                            @error('vacinas_em_dia')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="contato_emergencia" class="form-label small mb-0">Em caso de emergência para quem ligar e em qual número?</label>
                            <input type="text" class="form-control form-control-sm @error('contato_emergencia') is-invalid @enderror" 
                                   id="contato_emergencia" name="contato_emergencia" value="{{ old('contato_emergencia', $aluno->contato_emergencia) }}" {{ $disabledAttr }}>
                            @error('contato_emergencia')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-12">
                            <label for="outras_informacoes_saude" class="form-label small mb-0">Existe alguma outra informação a respeito da saúde do aluno que o Encarregado queira fazer constar da ficha?</label>
                            <textarea class="form-control form-control-sm @error('outras_informacoes_saude') is-invalid @enderror" 
                                      id="outras_informacoes_saude" name="outras_informacoes_saude" rows="2" {{ $disabledAttr }}>{{ old('outras_informacoes_saude', $aluno->outras_informacoes_saude) }}</textarea>
                            @error('outras_informacoes_saude')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-12 mt-2">
                            <hr class="my-1">
                            <h6 class="border-bottom pb-1 mb-1 fw-bold text-primary">INDIVÍDUOS AUTORIZADOS A ACOMPANHAR O ALUNO</h6>
                            <small class="text-muted">Adulto, idôneo ou maior de 16 anos emancipado</small>
                        </div>

                        <div class="col-md-6">
                            <label for="individuo_autorizado_1_nome" class="form-label small mb-0">Nome (1)</label>
                            <input type="text" class="form-control form-control-sm @error('individuo_autorizado_1_nome') is-invalid @enderror" 
                                   id="individuo_autorizado_1_nome" name="individuo_autorizado_1_nome" value="{{ old('individuo_autorizado_1_nome', $aluno->individuo_autorizado_1_nome) }}" {{ $disabledAttr }}>
                            @error('individuo_autorizado_1_nome')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="individuo_autorizado_1_telefone" class="form-label small mb-0">Tel (1)</label>
                            <input type="text" class="form-control form-control-sm @error('individuo_autorizado_1_telefone') is-invalid @enderror" 
                                   id="individuo_autorizado_1_telefone" name="individuo_autorizado_1_telefone" value="{{ old('individuo_autorizado_1_telefone', $aluno->individuo_autorizado_1_telefone) }}" {{ $disabledAttr }}>
                            @error('individuo_autorizado_1_telefone')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="individuo_autorizado_2_nome" class="form-label small mb-0">Nome (2)</label>
                            <input type="text" class="form-control form-control-sm @error('individuo_autorizado_2_nome') is-invalid @enderror" 
                                   id="individuo_autorizado_2_nome" name="individuo_autorizado_2_nome" value="{{ old('individuo_autorizado_2_nome', $aluno->individuo_autorizado_2_nome) }}" {{ $disabledAttr }}>
                            @error('individuo_autorizado_2_nome')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="individuo_autorizado_2_telefone" class="form-label small mb-0">Tel (2)</label>
                            <input type="text" class="form-control form-control-sm @error('individuo_autorizado_2_telefone') is-invalid @enderror" 
                                   id="individuo_autorizado_2_telefone" name="individuo_autorizado_2_telefone" value="{{ old('individuo_autorizado_2_telefone', $aluno->individuo_autorizado_2_telefone) }}" {{ $disabledAttr }}>
                            @error('individuo_autorizado_2_telefone')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="individuo_autorizado_3_nome" class="form-label small mb-0">Nome (3)</label>
                            <input type="text" class="form-control form-control-sm @error('individuo_autorizado_3_nome') is-invalid @enderror" 
                                   id="individuo_autorizado_3_nome" name="individuo_autorizado_3_nome" value="{{ old('individuo_autorizado_3_nome', $aluno->individuo_autorizado_3_nome) }}" {{ $disabledAttr }}>
                            @error('individuo_autorizado_3_nome')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="individuo_autorizado_3_telefone" class="form-label small mb-0">Tel (3)</label>
                            <input type="text" class="form-control form-control-sm @error('individuo_autorizado_3_telefone') is-invalid @enderror" 
                                   id="individuo_autorizado_3_telefone" name="individuo_autorizado_3_telefone" value="{{ old('individuo_autorizado_3_telefone', $aluno->individuo_autorizado_3_telefone) }}" {{ $disabledAttr }}>
                            @error('individuo_autorizado_3_telefone')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-12 mt-1">
                            <hr class="my-1">
                            <h6 class="border-bottom pb-1 mb-1 fw-bold text-primary">DADOS DE ENCARREGADO DE EDUCAÇÃO</h6>
                        </div>

                        <div class="col-md-6">
                            <label for="nome_encarregado" class="form-label small mb-0">Nome do encarregado</label>
                            <input type="text" class="form-control form-control-sm @error('nome_encarregado') is-invalid @enderror" 
                                   id="nome_encarregado" name="nome_encarregado" value="{{ old('nome_encarregado', $aluno->nome_encarregado) }}" {{ $disabledAttr }}>
                            @error('nome_encarregado')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="endereco_encarregado" class="form-label small mb-0">Endereço de residência</label>
                            <input type="text" class="form-control form-control-sm @error('endereco_encarregado') is-invalid @enderror" 
                                   id="endereco_encarregado" name="endereco_encarregado" value="{{ old('endereco_encarregado', $aluno->endereco_encarregado) }}" {{ $disabledAttr }}>
                            @error('endereco_encarregado')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="profissao_encarregado" class="form-label small mb-0">Profissão</label>
                            <input type="text" class="form-control form-control-sm @error('profissao_encarregado') is-invalid @enderror" 
                                   id="profissao_encarregado" name="profissao_encarregado" value="{{ old('profissao_encarregado', $aluno->profissao_encarregado) }}" {{ $disabledAttr }}>
                            @error('profissao_encarregado')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="telefone_encarregado" class="form-label small mb-0">Contacto</label>
                            <input type="text" class="form-control form-control-sm @error('telefone_encarregado') is-invalid @enderror" 
                                   id="telefone_encarregado" name="telefone_encarregado" value="{{ old('telefone_encarregado', $aluno->telefone_encarregado) }}" {{ $disabledAttr }}>
                            @error('telefone_encarregado')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label for="bi_encarregado" class="form-label small mb-0">BI N°</label>
                            <input type="text" class="form-control form-control-sm @error('bi_encarregado') is-invalid @enderror" 
                                   id="bi_encarregado" name="bi_encarregado" value="{{ old('bi_encarregado', $aluno->bi_encarregado) }}" {{ $disabledAttr }}>
                            @error('bi_encarregado')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label for="grau_parentesco" class="form-label small mb-0">Grau de parentesco</label>
                            <input type="text" class="form-control form-control-sm @error('grau_parentesco') is-invalid @enderror" 
                                   id="grau_parentesco" name="grau_parentesco" value="{{ old('grau_parentesco', $aluno->grau_parentesco) }}" placeholder="Ex: Pai, Mãe, Tio, etc." {{ $disabledAttr }}>
                            @error('grau_parentesco')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-12 mt-1">
                            <hr class="my-1">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="pago" name="pago" value="1" {{ old('pago', $aluno->pago ?? true) ? 'checked' : '' }} {{ $disabledAttr }}>
                                <label class="form-check-label small" for="pago">
                                    <strong>Pago</strong> (Marque se a matrícula já foi paga)
                                </label>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <h6 class="border-bottom pb-1 mb-2 fw-bold text-primary mt-2">CONFIGURAÇÃO DE MENSALIDADES</h6>
                        </div>

                        <div class="col-md-4">
                            <label for="modalidade_pagamento" class="form-label small mb-1">Modalidade de Pagamento</label>
                            <select class="form-select form-select-sm @error('modalidade_pagamento') is-invalid @enderror" 
                                    id="modalidade_pagamento" name="modalidade_pagamento" {{ $disabledAttr }}>
                                <option value="MENSAL" {{ old('modalidade_pagamento', $aluno->modalidade_pagamento ?? 'MENSAL') == 'MENSAL' ? 'selected' : '' }}>Mensal</option>
                                <option value="TRIMESTRAL" {{ old('modalidade_pagamento', $aluno->modalidade_pagamento ?? 'MENSAL') == 'TRIMESTRAL' ? 'selected' : '' }}>Trimestral</option>
                                <option value="SEMESTRAL" {{ old('modalidade_pagamento', $aluno->modalidade_pagamento ?? 'MENSAL') == 'SEMESTRAL' ? 'selected' : '' }}>Semestral</option>
                                <option value="ANUAL" {{ old('modalidade_pagamento', $aluno->modalidade_pagamento ?? 'MENSAL') == 'ANUAL' ? 'selected' : '' }}>Anual</option>
                            </select>
                            @error('modalidade_pagamento')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                            <small class="text-muted">Como o aluno prefere pagar as mensalidades</small>
                        </div>

                        <div class="col-md-4">
                            <label for="valor_mensalidade_personalizado" class="form-label small mb-1">Valor Mensalidade Personalizado (MT)</label>
                            <input type="number" step="0.01" min="0" 
                                   class="form-control form-control-sm @error('valor_mensalidade_personalizado') is-invalid @enderror" 
                                   id="valor_mensalidade_personalizado" name="valor_mensalidade_personalizado" 
                                   value="{{ old('valor_mensalidade_personalizado', $aluno->valor_mensalidade_personalizado) }}" 
                                   placeholder="Deixe vazio para usar valor padrão" {{ $disabledAttr }}>
                            @error('valor_mensalidade_personalizado')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                            <small class="text-muted">Valor personalizado para este aluno (opcional)</small>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <label for="nivel_ensino" class="form-label small mb-0">Nível de Ensino</label>
                            <select class="form-select form-select-sm" id="nivel_ensino" name="nivel_ensino" {{ $disabledAttr }}>
                                <option value="">Selecione o nível</option>
                                <option value="PRIMARIO" {{ old('nivel_ensino', $turmaAtual?->nivel_ensino ?? 'PRIMARIO') == 'PRIMARIO' ? 'selected' : '' }}>Primário</option>
                                <option value="SECUNDARIO" {{ old('nivel_ensino', $turmaAtual?->nivel_ensino) == 'SECUNDARIO' ? 'selected' : '' }}>Secundário</option>
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label for="classe" class="form-label small mb-0">Classe</label>
                            <select class="form-select form-select-sm" id="classe" name="classe" {{ $disabledAttr }}>
                                <option value="">Selecione a Classe</option>
                                @foreach($classes as $classe)
                                    <option value="{{ $classe }}" 
                                            {{ old('classe', $turmaAtual?->codigo) == $classe ? 'selected' : '' }}>
                                        {{ $classe }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label for="turma_id" class="form-label small mb-0">Turma *</label>
                            <select class="form-select form-select-sm @error('turma_id') is-invalid @enderror" 
                                    id="turma_id" name="turma_id" {{ $disabledAttr }} {{ !$isViewOnly ? 'required' : '' }}>
                                <option value="">Selecione a Turma</option>
                                @foreach($turmas as $turma)
                                    <option value="{{ $turma->id }}" 
                                            data-classe="{{ $turma->codigo }}"
                                            data-nivel="{{ $turma->nivel_ensino ?? 'PRIMARIO' }}"
                                            {{ old('turma_id', $turmaAtual?->id) == $turma->id ? 'selected' : '' }}>
                                        {{ $turma->codigo }} - {{ $turma->nome }}
                                    </option>
                                @endforeach
                            </select>
                            @error('turma_id')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-3">
                            <label class="form-label small mb-0">Código de Estudante</label>
                            <input type="text" class="form-control form-control-sm" value="{{ $aluno->codigo_estudante }}" disabled>
                        </div>
                    </div>

                    <div class="mt-2">
                        @if(!isset($viewOnly) || !$viewOnly)
                            <button type="submit" class="btn btn-primary-custom btn-sm">Atualizar</button>
                            <a href="{{ route('admin.alunos.index') }}" class="btn btn-secondary btn-sm">Cancelar</a>
                        @else
                            <a href="{{ route('admin.alunos.show', $aluno) }}" class="btn btn-secondary btn-sm">Voltar</a>
                        @endif
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    // Sincronizar campos de data
    document.addEventListener('DOMContentLoaded', function() {
        const diaNasc = document.getElementById('dia_nascimento');
        const mesNasc = document.getElementById('mes_nascimento');
        const anoNasc = document.getElementById('ano_nascimento');
        const dataNasc = document.getElementById('data_nascimento');

        function updateDateField() {
            if (diaNasc.value && mesNasc.value && anoNasc.value) {
                const dia = String(diaNasc.value).padStart(2, '0');
                const mes = String(mesNasc.value).padStart(2, '0');
                const ano = anoNasc.value;
                dataNasc.value = `${ano}-${mes}-${dia}`;
            }
        }

        function updateIndividualFields() {
            if (dataNasc.value) {
                const date = new Date(dataNasc.value);
                diaNasc.value = date.getDate();
                mesNasc.value = date.getMonth() + 1;
                anoNasc.value = date.getFullYear();
            }
        }

        if (diaNasc) diaNasc.addEventListener('change', updateDateField);
        if (mesNasc) mesNasc.addEventListener('change', updateDateField);
        if (anoNasc) anoNasc.addEventListener('change', updateDateField);
        if (dataNasc) dataNasc.addEventListener('change', updateIndividualFields);
    });

    // Filtrar turmas por classe e nível de ensino
    function initAlunoEditForm() {
        const classeSelect = document.getElementById('classe');
        const turmaSelect = document.getElementById('turma_id');
        const nivelSelect = document.getElementById('nivel_ensino');
        if (!classeSelect || !turmaSelect || !nivelSelect) {
            return;
        }

        const todasTurmas = [];
        Array.from(turmaSelect.options).forEach(option => {
            if (option.value) {
                todasTurmas.push({
                    id: option.value,
                    codigo: option.getAttribute('data-classe'),
                    nivel: option.getAttribute('data-nivel') || 'PRIMARIO',
                    label: option.textContent
                });
            }
        });

        function renderClasses() {
            const nivel = nivelSelect.value;
            const classesSet = new Set();
            todasTurmas.forEach(turma => {
                if (!nivel || turma.nivel === nivel) {
                    classesSet.add(turma.codigo);
                }
            });

            const classeAtual = classeSelect.value;
            classeSelect.innerHTML = '<option value="">Selecione a Classe</option>';
            Array.from(classesSet).sort().forEach(classe => {
                const opt = document.createElement('option');
                opt.value = classe;
                opt.textContent = classe;
                if (classe === classeAtual) {
                    opt.selected = true;
                }
                classeSelect.appendChild(opt);
            });
        }

        function renderTurmas() {
            const nivel = nivelSelect.value;
            const classeSelecionada = classeSelect.value;
            const turmaAtual = turmaSelect.value;

            turmaSelect.innerHTML = '<option value="">Selecione a Turma</option>';
            todasTurmas.forEach(turma => {
                if (nivel && turma.nivel !== nivel) {
                    return;
                }
                if (!classeSelecionada || turma.codigo === classeSelecionada) {
                    const opt = document.createElement('option');
                    opt.value = turma.id;
                    opt.textContent = turma.label;
                    opt.setAttribute('data-classe', turma.codigo);
                    opt.setAttribute('data-nivel', turma.nivel);
                    if (turma.id === turmaAtual) {
                        opt.selected = true;
                    }
                    turmaSelect.appendChild(opt);
                }
            });
        }

        nivelSelect.addEventListener('change', function() {
            renderClasses();
            renderTurmas();
        });

        classeSelect.addEventListener('change', function() {
            renderTurmas();
        });

        renderClasses();
        renderTurmas();
    }

    window.initAlunoEditForm = initAlunoEditForm;

    document.addEventListener('DOMContentLoaded', function() {
        initAlunoEditForm();
    });

    function previewFoto(input) {
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            reader.onload = function(e) {
                const preview = document.getElementById('foto-preview');
                preview.innerHTML = `<img src="${e.target.result}" style="width: 100%; height: 100%; object-fit: cover;">`;
            };
            reader.readAsDataURL(input.files[0]);
        }
    }

    function capturarFoto() {
        if (!navigator.mediaDevices || !navigator.mediaDevices.getUserMedia) {
            alert('Seu navegador não suporta captura de vídeo. Use um navegador moderno como Chrome, Firefox ou Edge.');
            return;
        }
        
        // Criar modal para captura
        const modal = document.createElement('div');
        modal.className = 'modal fade';
        modal.id = 'modal-camera';
        modal.setAttribute('data-bs-backdrop', 'static');
        modal.setAttribute('data-bs-keyboard', 'false');
        modal.setAttribute('tabindex', '-1');
        modal.setAttribute('aria-labelledby', 'modal-camera-title');
        modal.setAttribute('aria-modal', 'true');
        // NÃO definir aria-hidden inicialmente - será gerenciado pelo Bootstrap
        modal.innerHTML = `
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modal-camera-title">Capturar Foto do Aluno</h5>
                        <button type="button" class="btn-close" onclick="fecharCamera()" aria-label="Fechar"></button>
                    </div>
                    <div class="modal-body text-center">
                        <video id="video-camera" autoplay playsinline style="width: 100%; max-width: 500px; border: 2px solid #333;"></video>
                        <canvas id="canvas-camera" style="display: none;"></canvas>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary" onclick="tirarFoto()">
                            <i class="bi bi-camera-fill"></i> Capturar Foto
                        </button>
                        <button type="button" class="btn btn-secondary" onclick="fecharCamera()">Cancelar</button>
                    </div>
                </div>
            </div>
        `;
        document.body.appendChild(modal);
        
        // Aguardar um pouco para garantir que o modal foi adicionado ao DOM
        setTimeout(function() {
            // Verificar se bootstrap está disponível
            if (typeof window.bootstrap === 'undefined' || !window.bootstrap.Modal) {
                alert('Bootstrap não está carregado. Por favor, recarregue a página.');
                return;
            }
            
            // REMOVER aria-hidden ANTES de criar e mostrar o modal
            modal.removeAttribute('aria-hidden');
            
            const bsModal = new window.bootstrap.Modal(modal, { 
                backdrop: 'static', 
                keyboard: false,
                focus: true
            });
            
            // Garantir que aria-hidden seja removido ANTES do modal ser mostrado
            modal.addEventListener('show.bs.modal', function() {
                modal.removeAttribute('aria-hidden');
            }, { once: true });
            
            // Garantir que aria-hidden seja removido quando o modal for mostrado
            modal.addEventListener('shown.bs.modal', function() {
                modal.removeAttribute('aria-hidden');
            }, { once: true });
            
            // Configurar acesso à câmera após o modal ser mostrado
            modal.addEventListener('shown.bs.modal', function() {
                video = document.getElementById('video-camera');
                canvas = document.getElementById('canvas-camera');
                
                navigator.mediaDevices.getUserMedia({ 
                    video: { 
                        width: { ideal: 500 },
                        height: { ideal: 600 },
                        facingMode: 'user' 
                    } 
                })
                    .then(function(mediaStream) {
                        stream = mediaStream;
                        if (video) {
                            video.srcObject = stream;
                        }
                    })
                    .catch(function(err) {
                        alert('Erro ao acessar a câmera: ' + err.message + '\n\nCertifique-se de que a câmera está conectada e que você permitiu o acesso.');
                        fecharCamera();
                    });
            }, { once: true });
            
            // Garantir que aria-hidden seja adicionado quando o modal for escondido
            modal.addEventListener('hidden.bs.modal', function() {
                modal.setAttribute('aria-hidden', 'true');
            }, { once: true });
            
            // Remover aria-hidden novamente antes de mostrar (garantia extra)
            setTimeout(function() {
                modal.removeAttribute('aria-hidden');
                bsModal.show();
            }, 10);
        }, 100);
    }

    function tirarFoto() {
        if (!video || !canvas) return;
        
        canvas.width = video.videoWidth;
        canvas.height = video.videoHeight;
        const ctx = canvas.getContext('2d');
        ctx.drawImage(video, 0, 0);
        
        const fotoBase64 = canvas.toDataURL('image/jpeg', 0.8);
        document.getElementById('foto_base64').value = fotoBase64;
        
        const preview = document.getElementById('foto-preview');
        preview.innerHTML = `<img src="${fotoBase64}" style="width: 100%; height: 100%; object-fit: cover;">`;
        
        // Limpar campo de upload de arquivo
        document.getElementById('foto').value = '';
        
        fecharCamera();
    }

    function fecharCamera() {
        if (stream) {
            stream.getTracks().forEach(track => track.stop());
            stream = null;
        }
        const modal = document.getElementById('modal-camera');
        if (modal) {
            try {
                // Verificar se bootstrap está disponível
                if (typeof window.bootstrap !== 'undefined' && window.bootstrap.Modal) {
                    const bsModal = window.bootstrap.Modal.getInstance(modal);
                    if (bsModal) {
                        bsModal.hide();
                    } else {
                        modal.style.display = 'none';
                        modal.setAttribute('aria-hidden', 'true');
                    }
                } else {
                    modal.style.display = 'none';
                    modal.setAttribute('aria-hidden', 'true');
                }
            } catch(e) {
                modal.style.display = 'none';
                modal.setAttribute('aria-hidden', 'true');
            }
            setTimeout(() => {
                if (modal && modal.parentNode) {
                    modal.remove();
                }
            }, 300);
        }
    }

    function removerFoto() {
        document.getElementById('foto').value = '';
        document.getElementById('foto_base64').value = '';
        const preview = document.getElementById('foto-preview');
        preview.innerHTML = '<span class="text-muted small">Sem foto</span>';
    }
</script>
@endsection
