<?php

require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "=== CREDENCIAIS DO SISTEMA ===\n\n";

// Superadmin
$superadmin = \App\Models\User::where('tipo', 'superadmin')->first();
if ($superadmin) {
    echo "🔑 SUPERADMIN:\n";
    echo "   Email: {$superadmin->email}\n";
    echo "   Senha: admin123\n\n";
}

// Admin
$admin = \App\Models\User::where('tipo', 'admin')->first();
if ($admin) {
    echo "🔑 ADMIN:\n";
    echo "   Email: {$admin->email}\n";
    echo "   Senha: admin123\n\n";
}

// Professores
echo "🔑 PROFESSORES:\n";
$professores = \App\Models\Professor::with('user')->limit(5)->get();
$anoAtual = date('Y');
foreach ($professores as $prof) {
    if ($prof->user) {
        echo "   Nome: {$prof->user->name}\n";
        echo "   Email: {$prof->user->email}\n";
        echo "   Código: {$prof->numero_funcionario}\n";
        echo "   Senha: {$anoAtual}\n";
        echo "   ---\n";
    }
}
echo "\n";

// Alunos
echo "🔑 ALUNOS:\n";
$alunos = \App\Models\Aluno::with('user')->limit(5)->get();
foreach ($alunos as $aluno) {
    if ($aluno->user) {
        echo "   Nome: {$aluno->user->name}\n";
        echo "   Código: {$aluno->codigo_estudante}\n";
        echo "   Email: {$aluno->user->email}\n";
        echo "   Senha: {$anoAtual}\n";
        echo "   ---\n";
    }
}
echo "\n";

echo "NOTA: Professores e Alunos devem alterar a senha no primeiro login.\n";
echo "Professores podem fazer login com Email ou Código de Funcionário.\n";
echo "Alunos podem fazer login com Email ou Código de Estudante.\n";

