# Regras de Carregamento do Relacionamento User

## ⚠️ IMPORTANTE: Campo `is_active` Obrigatório

Ao carregar o relacionamento `user` usando `select` limitado, **SEMPRE** inclua o campo `is_active`.

### ❌ ERRADO:
```php
->with('user:id,name')
->with('user:id,name,email')
->with(['aluno.user:id,name'])
```

### ✅ CORRETO:
```php
->with('user:id,name,is_active')
->with('user:id,name,email,is_active')
->with(['aluno.user:id,name,is_active'])
```

## Por quê?

O campo `is_active` é usado nas views para determinar se um aluno, professor ou funcionário está bloqueado ou ativo. Se não for carregado, o sistema interpretará como `null` ou `false`, fazendo com que todos apareçam como bloqueados.

## Verificação Automática

Execute o comando de verificação antes de fazer deploy:

```bash
php artisan check:user-is-active-loading
```

Este comando verifica todos os controllers e alerta sobre carregamentos do relacionamento `user` que não incluem `is_active`.

## Locais Corrigidos

Os seguintes arquivos foram corrigidos para incluir `is_active`:

1. `app/Http/Controllers/AdminController.php`
   - `indexAlunos()` - linha ~141
   - `indexProfessores()` - linha ~1016
   - `inscricoes()` - linha ~2080
   - `renovarAluno()` - linha ~2611

2. `app/Http/Controllers/FinanceiroController.php`
   - `index()` - linha ~122
   - `relatorioFinanceiro()` - linhas ~1133, ~1368

3. `app/Http/Controllers/FuncionarioController.php`
   - `index()` - linha ~41

## Checklist para Novos Códigos

Ao adicionar novo código que carrega o relacionamento `user`:

- [ ] Incluí `is_active` no select do relacionamento `user`?
- [ ] Executei o comando de verificação?
- [ ] Testei que o status aparece corretamente nas views?
