<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Role;
use Illuminate\Support\Facades\Hash;

class SuperadminSeeder extends Seeder
{
    public function run(): void
    {
        $superadmin = User::firstOrCreate(
            ['email' => 'superadmin@sge.pt'],
            [
                'name' => 'Superadmin',
                'password' => Hash::make('admin123'),
                'tipo' => 'superadmin',
                'must_change_password' => false,
                'is_active' => true,
            ]
        );

        $role = Role::where('slug', 'superadmin')->first();
        if ($role && !$superadmin->hasRole($role)) {
            $superadmin->roles()->attach($role);
        }
    }
}



