<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Disciplina;

class DisciplinaSeeder extends Seeder
{
    public function run(): void
    {
        $disciplinas = [
            ['nome' => 'Matemática', 'codigo' => 'MAT', 'modelo_avaliacao' => 'NACIONAL'],
            ['nome' => 'Português', 'codigo' => 'POR', 'modelo_avaliacao' => 'NACIONAL'],
            ['nome' => 'Inglês', 'codigo' => 'ING', 'modelo_avaliacao' => 'CAMBRIDGE'],
            ['nome' => 'Física', 'codigo' => 'FIS', 'modelo_avaliacao' => 'NACIONAL'],
            ['nome' => 'Química', 'codigo' => 'QUI', 'modelo_avaliacao' => 'NACIONAL'],
            ['nome' => 'Biologia', 'codigo' => 'BIO', 'modelo_avaliacao' => 'NACIONAL'],
            ['nome' => 'História', 'codigo' => 'HIS', 'modelo_avaliacao' => 'NACIONAL'],
            ['nome' => 'Geografia', 'codigo' => 'GEO', 'modelo_avaliacao' => 'NACIONAL'],
        ];

        foreach ($disciplinas as $disciplina) {
            Disciplina::firstOrCreate(
                ['codigo' => $disciplina['codigo']],
                array_merge($disciplina, ['ativa' => true])
            );
        }
    }
}



