<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Role;

class DesbloquearTodosAlunosEProfessoresSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Buscar IDs das roles de aluno e professor
        $roleAluno = Role::where('slug', 'aluno')->first();
        $roleProfessor = Role::where('slug', 'professor')->first();

        if (!$roleAluno && !$roleProfessor) {
            $this->command->warn('Roles de aluno e professor não encontradas.');
            return;
        }

        $roleIds = [];
        if ($roleAluno) {
            $roleIds[] = $roleAluno->id;
        }
        if ($roleProfessor) {
            $roleIds[] = $roleProfessor->id;
        }

        if (empty($roleIds)) {
            $this->command->warn('Nenhuma role encontrada.');
            return;
        }

        // Atualizar todos os usuários que têm role de aluno ou professor
        $usersAtualizados = DB::table('users')
            ->whereIn('id', function($query) use ($roleIds) {
                $query->select('user_id')
                    ->from('user_role')
                    ->whereIn('role_id', $roleIds);
            })
            ->update([
                'is_active' => true,
                'updated_at' => now()
            ]);

        $this->command->info("Desbloqueados {$usersAtualizados} alunos e professores com sucesso!");
    }
}
