<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\AnoLetivo;
use App\Models\Trimestre;

class AnoLetivoSeeder extends Seeder
{
    public function run(): void
    {
        $anoAtual = date('Y');
        $anoProximo = $anoAtual + 1;
        $anoString = "{$anoAtual}/{$anoProximo}";

        $anoLetivo = AnoLetivo::firstOrCreate(
            ['ano' => $anoString],
            [
                'data_inicio' => "{$anoAtual}-09-01",
                'data_fim' => "{$anoProximo}-07-31",
                'ativo' => true,
            ]
        );

        // Cria trimestres
        $trimestres = [
            [
                'nome' => '1º Trimestre',
                'numero' => 1,
                'data_inicio' => "{$anoAtual}-09-01",
                'data_fim' => "{$anoAtual}-12-15",
                'ativo' => false,
            ],
            [
                'nome' => '2º Trimestre',
                'numero' => 2,
                'data_inicio' => "{$anoAtual}-12-16",
                'data_fim' => "{$anoProximo}-03-15",
                'ativo' => false,
            ],
            [
                'nome' => '3º Trimestre',
                'numero' => 3,
                'data_inicio' => "{$anoProximo}-03-16",
                'data_fim' => "{$anoProximo}-07-31",
                'ativo' => false,
            ],
        ];

        foreach ($trimestres as $trimestre) {
            Trimestre::firstOrCreate(
                [
                    'ano_letivo_id' => $anoLetivo->id,
                    'numero' => $trimestre['numero'],
                ],
                array_merge($trimestre, ['ano_letivo_id' => $anoLetivo->id])
            );
        }
    }
}



