<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('funcionario_servico_payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('funcionario_servico_id')->constrained('funcionarios_servicos')->onDelete('cascade');
            $table->integer('mes');
            $table->integer('ano');
            $table->decimal('valor_total', 10, 2);
            $table->decimal('inss', 10, 2)->default(0);
            $table->decimal('irps', 10, 2)->default(0);
            $table->decimal('valor_liquido', 10, 2)->default(0);
            $table->enum('status', ['PENDENTE', 'PAGO', 'CANCELADO'])->default('PENDENTE');
            $table->date('data_pagamento')->nullable();
            $table->text('observacoes')->nullable();
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamps();

            $table->index(['funcionario_servico_id', 'mes', 'ano'], 'fsp_fid_mes_ano_idx');
            $table->index('status', 'fsp_status_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('funcionario_servico_payments');
    }
};

