<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('alunos', function (Blueprint $table) {
            $table->enum('status_inscricao', ['PENDENTE', 'APROVADO', 'REJEITADO'])->default('APROVADO')->after('valor_mensalidade_personalizado');
            $table->text('observacoes_inscricao')->nullable()->after('status_inscricao');
            $table->timestamp('data_submissao')->nullable()->after('observacoes_inscricao');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('alunos', function (Blueprint $table) {
            $table->dropColumn(['status_inscricao', 'observacoes_inscricao', 'data_submissao']);
        });
    }
};
