<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('login_attempts', function (Blueprint $table) {
            $table->id();
            $table->string('login', 255)->index();
            $table->string('ip_address', 45)->nullable();
            $table->boolean('success')->default(false);
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('set null');
            $table->text('user_agent')->nullable();
            $table->string('motivo', 100)->nullable(); // 'credenciais_invalidas', 'conta_desativada'
            $table->timestamps();
            $table->index('created_at');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('login_attempts');
    }
};
