<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('professores', function (Blueprint $table) {
            $table->decimal('salario_fixo', 10, 2)->nullable()->after('nivel_ensino')->comment('Salário fixo para professores da primária');
            $table->decimal('valor_hora', 8, 2)->nullable()->after('salario_fixo')->comment('Valor por hora para professores do secundário');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('professores', function (Blueprint $table) {
            $table->dropColumn(['salario_fixo', 'valor_hora']);
        });
    }
};
