<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('disciplinas', function (Blueprint $table) {
            $table->enum('nivel_ensino', ['PRIMARIO', 'SECUNDARIO'])
                ->default('PRIMARIO')
                ->after('modelo_avaliacao');
        });

        DB::table('disciplinas')
            ->whereNull('nivel_ensino')
            ->update(['nivel_ensino' => 'PRIMARIO']);
    }

    public function down(): void
    {
        Schema::table('disciplinas', function (Blueprint $table) {
            $table->dropColumn('nivel_ensino');
        });
    }
};
