<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
            $table->foreignId('aluno_id')->constrained('alunos')->onDelete('cascade');
            $table->foreignId('payment_id')->nullable()->constrained('payments')->onDelete('set null');
            $table->foreignId('ano_letivo_id')->constrained('ano_letivo')->onDelete('cascade');
            $table->string('numero_factura')->unique(); // Número único da factura
            $table->decimal('valor', 10, 2);
            $table->enum('status', ['PENDENTE', 'PAGA', 'CANCELADA'])->default('PENDENTE');
            $table->date('data_emissao');
            $table->date('data_vencimento')->nullable();
            $table->text('descricao')->nullable();
            $table->text('itens')->nullable(); // JSON com itens da factura
            $table->string('caminho_pdf')->nullable(); // Caminho do PDF gerado
            $table->timestamps();
            $table->softDeletes();
        });

        // Adicionar foreign key de payments para invoices após criar invoices
        Schema::table('payments', function (Blueprint $table) {
            $table->foreign('invoice_id')->references('id')->on('invoices')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoices');
    }
};
