<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('alunos', function (Blueprint $table) {
            $table->enum('tipo_documento', ['BI', 'Cédula', 'Passaporte'])->nullable()->after('num_documento');
            $table->string('foto')->nullable()->after('tipo_documento');
        });
    }

    public function down(): void
    {
        Schema::table('alunos', function (Blueprint $table) {
            $table->dropColumn(['tipo_documento', 'foto']);
        });
    }
};
