<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('cambridge_grade_boundaries', function (Blueprint $table) {
            $table->id();
            $table->foreignId('disciplina_id')->constrained('disciplinas')->onDelete('cascade');
            $table->string('ano'); // Ex: 2024
            $table->string('serie')->nullable(); // Ex: June, November
            $table->string('letra', 2); // A, B, C, etc.
            $table->decimal('percent_min', 5, 2); // Percentagem mínima
            $table->decimal('percent_max', 5, 2)->nullable(); // Percentagem máxima (opcional)
            $table->boolean('is_default')->default(false);
            $table->timestamps();
            
            $table->index(['disciplina_id', 'ano', 'serie']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('cambridge_grade_boundaries');
    }
};



